/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.ModelHelper;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Gate;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.GatePluggable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGateCopier
extends ItemBuildCraft {
    private static final int META_EMPTY = 0;
    private static final int META_FULL = 1;

    public ItemGateCopier() {
        this.func_77625_d(1);
        this.func_77656_e(1);
        this.func_77655_b("gateCopier");
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        boolean isCopying = !player.func_70093_af();
        Block block = world.func_180495_p(pos).func_177230_c();
        TileEntity tile = world.func_175625_s(pos);
        NBTTagCompound data = NBTUtils.getItemData(stack);
        PipePluggable pluggable = null;
        Gate gate = null;
        if (tile == null || !(tile instanceof IPipeTile)) {
            isCopying = true;
        } else if (tile instanceof TileGenericPipe && block instanceof BlockGenericPipe) {
            BlockGenericPipe.RaytraceResult rayTraceResult = ((BlockGenericPipe)block).doRayTrace(world, pos, player);
            if (rayTraceResult != null && rayTraceResult.boundingBox != null && rayTraceResult.hitPart == BlockGenericPipe.Part.Pluggable) {
                pluggable = ((TileGenericPipe)tile).getPipePluggable(rayTraceResult.sideHit);
            }
        } else {
            pluggable = ((IPipeTile)tile).getPipePluggable(side);
        }
        if (pluggable instanceof GatePluggable) {
            gate = ((GatePluggable)pluggable).realGate;
        }
        if (isCopying) {
            if (gate == null) {
                stack.func_77982_d(new NBTTagCompound());
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.clear", new Object[0]));
                return true;
            }
        } else {
            if (!data.func_74764_b("logic")) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.noInformation", new Object[0]));
                return true;
            }
            if (gate == null) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.noGate", new Object[0]));
                return true;
            }
            GateDefinition.GateMaterial dataMaterial = GateDefinition.GateMaterial.fromOrdinal(data.func_74771_c("material"));
            GateDefinition.GateMaterial gateMaterial = gate.material;
            if (gateMaterial.numSlots < dataMaterial.numSlots) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.warning.slots", new Object[0]));
            }
            if (gateMaterial.numActionParameters < dataMaterial.numActionParameters) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.warning.actionParameters", new Object[0]));
            }
            if (gateMaterial.numTriggerParameters < dataMaterial.numTriggerParameters) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.warning.triggerParameters", new Object[0]));
            }
            if (data.func_74771_c("logic") != gate.logic.ordinal()) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.warning.logic", new Object[0]));
            }
            gate.readStatementsFromNBT(data);
            if (!gate.verifyGateStatements()) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.warning.load", new Object[0]));
            }
            if (tile instanceof TileGenericPipe) {
                ((TileGenericPipe)tile).sendNetworkUpdate();
            }
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.gatePasted", new Object[0]));
            return true;
        }
        data = new NBTTagCompound();
        stack.func_77982_d(data);
        gate.writeStatementsToNBT(data);
        data.func_74774_a("material", (byte)gate.material.ordinal());
        data.func_74774_a("logic", (byte)gate.logic.ordinal());
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.gateCopier.gateCopied", new Object[0]));
        data.func_74757_a("Unbreakable", true);
        data.func_74768_a("HideFlags", 4);
        return true;
    }

    public int getMetadata(ItemStack stack) {
        return stack.func_77942_o() ? 1 : 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelHelper.registerItemModel(this, 0, "_empty");
        ModelHelper.registerItemModel(this, 1, "_full");
    }
}

