/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.transport.IItemPipe;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.lib.utils.ColorUtils;
import buildcraft.core.lib.utils.ModelHelper;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeToolTipManager;
import buildcraft.transport.TileGenericPipe;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class ItemPipe
extends ItemBuildCraft
implements IItemPipe {
    @SideOnly(value=Side.CLIENT)
    private IIconProvider iconProvider;
    private int pipeIconIndex;

    public ItemPipe(BCCreativeTab creativeTab) {
        super(creativeTab);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public boolean func_180614_a(ItemStack itemstack, EntityPlayer entityplayer, World world, BlockPos pos, EnumFacing side, float par8, float par9, float par10) {
        BlockGenericPipe block = BuildCraftTransport.genericPipeBlock;
        Block worldBlock = world.func_180495_p(pos).func_177230_c();
        if (worldBlock == Blocks.field_150433_aE) {
            side = EnumFacing.UP;
        } else if (!(worldBlock == Blocks.field_150395_bd || worldBlock == Blocks.field_150329_H || worldBlock == Blocks.field_150330_I || worldBlock != null && worldBlock.func_176200_f(world, pos))) {
            pos = pos.func_177972_a(side);
        }
        if (itemstack.field_77994_a == 0) {
            return false;
        }
        if (world.func_175716_a((Block)block, pos, false, side, (Entity)entityplayer, itemstack)) {
            Pipe<?> pipe = BlockGenericPipe.createPipe(this);
            if (pipe == null) {
                BCLog.logger.log(Level.WARN, "Pipe failed to create during placement at {0}", new Object[]{pos});
                return true;
            }
            if (BlockGenericPipe.placePipe(pipe, world, pos, block.func_176223_P(), entityplayer, side)) {
                block.func_180633_a(world, pos, block.func_176223_P(), (EntityLivingBase)entityplayer, itemstack);
                if (!world.field_72995_K) {
                    TileEntity tile = world.func_175625_s(pos);
                    ((TileGenericPipe)tile).initializeFromItemMetadata(itemstack.func_77952_i());
                }
                world.func_72908_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), block.field_149762_H.func_150496_b(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
                --itemstack.field_77994_a;
                return true;
            }
            return false;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void setPipesIcons(IIconProvider iconProvider) {
        this.iconProvider = iconProvider;
    }

    public void setPipeIconIndex(int index) {
        this.pipeIconIndex = index;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSprite() {
        if (this.iconProvider != null) {
            return this.iconProvider.getIcon(this.pipeIconIndex);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advanced) {
        super.func_77624_a(stack, player, list, advanced);
        if (stack.func_77952_i() >= 1) {
            int color = stack.func_77952_i() - 1 & 0xF;
            list.add(ColorUtils.getFormattingTooltip(color) + EnumChatFormatting.ITALIC + BCStringUtils.localize("color." + ColorUtils.getName(color)));
        }
        Class<? extends Pipe<?>> pipe = BlockGenericPipe.pipes.get(this);
        List<String> toolTip = PipeToolTipManager.getToolTip(pipe, advanced);
        list.addAll(toolTip);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int renderPass) {
        return renderPass;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < 17; ++i) {
            ModelHelper.registerItemModel(this, i, "_" + i);
        }
    }
}

