/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.gates.IGate;
import buildcraft.api.statements.ActionState;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.internal.IDropControlInventory;
import buildcraft.core.lib.event.IEventBus;
import buildcraft.core.lib.event.IEventBusProvider;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Gate;
import buildcraft.transport.PipeConnectionBans;
import buildcraft.transport.PipeEventBus;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportStructure;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.gates.GateFactory;
import buildcraft.transport.pipes.events.PipeEvent;
import buildcraft.transport.statements.ActionValve;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Pipe<T extends PipeTransport>
implements IDropControlInventory,
IPipe,
Comparable<Pipe<?>> {
    private static final IEventBusProvider<PipeEvent> eventProvider = PipeEventBus.Provider.INSTANCE;
    public int[] signalStrength = new int[]{0, 0, 0, 0};
    public TileGenericPipe container;
    public final T transport;
    public final Item item;
    public boolean[] wireSet = new boolean[]{false, false, false, false};
    public final Gate[] gates = new Gate[EnumFacing.field_82609_l.length];
    public IEventBus<PipeEvent> eventBus = eventProvider.newBus();
    private boolean initialized = false;
    private boolean scheduleWireUpdate;
    private ArrayList<ActionState> actionStates = new ArrayList();

    public Pipe(T transport, Item item) {
        this.transport = transport;
        this.item = item;
        this.eventBus.registerHandler(this);
    }

    public void setTile(TileEntity tile) {
        this.container = (TileGenericPipe)tile;
        ((PipeTransport)this.transport).setTile((TileGenericPipe)tile);
    }

    public void resolveActions() {
        for (Gate gate : this.gates) {
            if (gate == null) continue;
            gate.resolveActions();
        }
    }

    public boolean blockActivated(EntityPlayer player, EnumFacing side) {
        return false;
    }

    public void onBlockPlaced() {
        ((PipeTransport)this.transport).onBlockPlaced();
    }

    public void onBlockPlacedBy(EntityLivingBase placer) {
    }

    public void onNeighborBlockChange(int blockId) {
        for (EnumFacing face : EnumFacing.values()) {
            ((PipeTransport)this.transport).onNeighborChange(face);
        }
    }

    public boolean canPipeConnect(TileEntity tile, EnumFacing side) {
        if (tile instanceof IPipeTile) {
            Pipe otherPipe = (Pipe)((IPipeTile)tile).getPipe();
            if (!BlockGenericPipe.isFullyDefined(otherPipe)) {
                return false;
            }
            if (!PipeConnectionBans.canPipesConnect(this.getClass(), otherPipe.getClass())) {
                return false;
            }
        }
        return ((PipeTransport)this.transport).canPipeConnect(tile, side);
    }

    public int getIconIndexForItem() {
        return this.getIconIndex(null);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract IIconProvider getIconProvider();

    public abstract int getIconIndex(EnumFacing var1);

    public void updateEntity() {
        ((PipeTransport)this.transport).updateEntity();
        this.actionStates.clear();
        if (!this.container.func_145831_w().field_72995_K) {
            for (Gate gate : this.gates) {
                if (gate == null) continue;
                gate.resolveActions();
                gate.tick();
            }
            if (this.scheduleWireUpdate) {
                this.updateSignalState();
            }
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        int i;
        ((PipeTransport)this.transport).writeToNBT(data);
        for (i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            String key = "Gate[" + i + "]";
            Gate gate = this.gates[i];
            if (gate != null) {
                NBTTagCompound gateNBT = new NBTTagCompound();
                gate.writeToNBT(gateNBT);
                data.func_74782_a(key, (NBTBase)gateNBT);
                continue;
            }
            data.func_82580_o(key);
        }
        for (i = 0; i < 4; ++i) {
            data.func_74757_a("wireSet[" + i + "]", this.wireSet[i]);
        }
    }

    public void readFromNBT(NBTTagCompound data) {
        int i;
        ((PipeTransport)this.transport).readFromNBT(data);
        for (i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            String key = "Gate[" + i + "]";
            this.gates[i] = data.func_74764_b(key) ? GateFactory.makeGate(this, data.func_74775_l(key)) : null;
        }
        if (data.func_74764_b("Gate")) {
            ((PipeTransport)this.transport).container.setGate(GateFactory.makeGate(this, data.func_74775_l("Gate")), 0);
            data.func_82580_o("Gate");
        }
        for (i = 0; i < 4; ++i) {
            this.wireSet[i] = data.func_74767_n("wireSet[" + i + "]");
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        ((PipeTransport)this.transport).initialize();
        this.updateSignalState();
        this.initialized = true;
    }

    public void updateSignalState() {
        for (PipeWire c : PipeWire.values()) {
            if (!this.wireSet[c.ordinal()]) continue;
            this.updateSignalState(c);
        }
    }

    private void updateSignalState(PipeWire c) {
        int prevStrength = this.signalStrength[c.ordinal()];
        boolean isBroadcast = false;
        for (Gate g : this.gates) {
            if (g == null || (g.broadcastSignal & 1 << c.ordinal()) == 0) continue;
            isBroadcast = true;
            break;
        }
        if (isBroadcast) {
            if (prevStrength < 255) {
                this.propagateSignalState(c, 255);
            }
        } else {
            ArrayList<Pipe> pipes = new ArrayList<Pipe>();
            int maxStrength = 0;
            for (EnumFacing dir : EnumFacing.values()) {
                Pipe pipe;
                TileEntity tile = this.container.getTile(dir);
                if (!(tile instanceof IPipeTile) || !this.isWireConnectedTo(tile, pipe = (Pipe)((IPipeTile)tile).getPipe(), c, dir)) continue;
                pipes.add(pipe);
                int pipeStrength = pipe.signalStrength[c.ordinal()];
                if (pipeStrength <= maxStrength) continue;
                maxStrength = pipeStrength;
            }
            this.signalStrength[c.ordinal()] = maxStrength > prevStrength && maxStrength > 1 ? maxStrength - 1 : 0;
            if (prevStrength != this.signalStrength[c.ordinal()]) {
                this.container.scheduleRenderUpdate();
            }
            if (this.signalStrength[c.ordinal()] == 0) {
                for (Pipe p : pipes) {
                    if (p.signalStrength[c.ordinal()] <= 0) continue;
                    p.updateSignalState(c);
                }
            } else {
                for (Pipe p : pipes) {
                    if (p.signalStrength[c.ordinal()] >= this.signalStrength[c.ordinal()] - 1) continue;
                    p.updateSignalState(c);
                }
            }
        }
        this.container.scheduleRenderUpdate();
    }

    protected void propagateSignalState(PipeWire c, int s) {
        this.signalStrength[c.ordinal()] = s;
        for (EnumFacing face : EnumFacing.values()) {
            Pipe pipe;
            TileEntity tile = this.container.getTile(face);
            if (!(tile instanceof IPipeTile) || !this.isWireConnectedTo(tile, pipe = (Pipe)((IPipeTile)tile).getPipe(), c, face)) continue;
            if (s == 0) {
                if (pipe.signalStrength[c.ordinal()] <= 0) continue;
                pipe.updateSignalState(c);
                continue;
            }
            if (pipe.signalStrength[c.ordinal()] >= s) continue;
            pipe.updateSignalState(c);
        }
    }

    public boolean inputOpen(EnumFacing from) {
        return ((PipeTransport)this.transport).inputOpen(from);
    }

    public boolean outputOpen(EnumFacing to) {
        return ((PipeTransport)this.transport).outputOpen(to);
    }

    public void onEntityCollidedWithBlock(Entity entity) {
    }

    public boolean canConnectRedstone() {
        for (Gate gate : this.gates) {
            if (gate == null) continue;
            return true;
        }
        return false;
    }

    public int getMaxRedstoneOutput(EnumFacing dir) {
        int output = 0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            output = Math.max(output, this.getRedstoneOutput(side));
            if (side != dir) continue;
            output = Math.max(output, this.getRedstoneOutputSide(side));
        }
        return output;
    }

    private int getRedstoneOutput(EnumFacing dir) {
        Gate gate = this.gates[dir.ordinal()];
        return gate != null ? gate.getRedstoneOutput() : 0;
    }

    private int getRedstoneOutputSide(EnumFacing dir) {
        Gate gate = this.gates[dir.ordinal()];
        return gate != null ? gate.getSidedRedstoneOutput() : 0;
    }

    public int isPoweringTo(EnumFacing side) {
        EnumFacing o = side.func_176734_d();
        TileEntity tile = this.container.getTile(o);
        if (tile instanceof IPipeTile && this.container.isPipeConnected(o)) {
            return 0;
        }
        return this.getMaxRedstoneOutput(o);
    }

    public int isIndirectlyPoweringTo(EnumFacing l) {
        return this.isPoweringTo(l);
    }

    public void randomDisplayTick(Random random) {
    }

    @Override
    public boolean isWired(PipeWire color) {
        return this.wireSet[color.ordinal()];
    }

    @Override
    public boolean isWireActive(PipeWire color) {
        return this.signalStrength[color.ordinal()] > 0;
    }

    @Deprecated
    public boolean hasGate() {
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            if (!this.hasGate(direction)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasGate(EnumFacing side) {
        return this.container.hasGate(side);
    }

    protected void notifyBlocksOfNeighborChange(EnumFacing side) {
        this.container.func_145831_w().func_180496_d(this.container.func_174877_v().func_177972_a(side), (Block)BuildCraftTransport.genericPipeBlock);
    }

    protected void updateNeighbors(boolean needSelf) {
        if (needSelf) {
            this.container.func_145831_w().func_175685_c(this.container.func_174877_v(), (Block)BuildCraftTransport.genericPipeBlock);
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.notifyBlocksOfNeighborChange(side);
        }
    }

    public void dropItem(ItemStack stack) {
        InvUtils.dropItems(this.container.func_145831_w(), stack, this.container.func_174877_v());
    }

    public ArrayList<ItemStack> computeItemDrop() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (PipeWire pipeWire : PipeWire.VALUES) {
            if (!this.wireSet[pipeWire.ordinal()]) continue;
            result.add(pipeWire.getStack());
        }
        for (PipeWire pipeWire : EnumFacing.field_82609_l) {
            if (!this.container.hasPipePluggable((EnumFacing)pipeWire)) continue;
            Collections.addAll(result, this.container.getPipePluggable((EnumFacing)pipeWire).getDropItems(this.container));
        }
        return result;
    }

    public LinkedList<IActionInternal> getActions() {
        LinkedList<IActionInternal> result = new LinkedList<IActionInternal>();
        for (ActionValve.ValveState state : ActionValve.ValveState.VALUES) {
            result.add(BuildCraftTransport.actionValve[state.ordinal()]);
        }
        return result;
    }

    public void resetGates() {
        for (int i = 0; i < this.gates.length; ++i) {
            Gate gate = this.gates[i];
            if (gate != null) {
                gate.resetGate();
            }
            this.gates[i] = null;
        }
        this.scheduleWireUpdate = true;
        this.container.scheduleRenderUpdate();
    }

    protected void actionsActivated(Collection<StatementSlot> actions) {
    }

    public TileGenericPipe getContainer() {
        return this.container;
    }

    public boolean isWireConnectedTo(TileEntity tile, PipeWire color, EnumFacing dir) {
        if (!(tile instanceof IPipeTile)) {
            return false;
        }
        return this.isWireConnectedTo(tile, (Pipe)((IPipeTile)tile).getPipe(), color, dir);
    }

    public boolean isWireConnectedTo(TileEntity tile, Pipe pipe, PipeWire color, EnumFacing dir) {
        if (!BlockGenericPipe.isFullyDefined(pipe)) {
            return false;
        }
        if (!pipe.wireSet[color.ordinal()]) {
            return false;
        }
        if (this.container.hasBlockingPluggable(dir) || pipe.container.hasBlockingPluggable(dir.func_176734_d())) {
            return false;
        }
        return pipe.transport instanceof PipeTransportStructure || this.transport instanceof PipeTransportStructure || Utils.checkPipesConnections(this.container, tile);
    }

    public void dropContents() {
        ((PipeTransport)this.transport).dropContents();
    }

    public List<ItemStack> getDroppedItems() {
        return ((PipeTransport)this.transport).getDroppedItems();
    }

    public EnumFacing getOpenOrientation() {
        int connectionsNum = 0;
        EnumFacing targetOrientation = null;
        for (EnumFacing o : EnumFacing.field_82609_l) {
            if (!this.container.isPipeConnected(o) || ++connectionsNum != 1) continue;
            targetOrientation = o;
        }
        if (connectionsNum > 1 || connectionsNum == 0) {
            return null;
        }
        return targetOrientation.func_176734_d();
    }

    @Override
    public boolean doDrop() {
        return true;
    }

    public void invalidate() {
    }

    public void validate() {
    }

    public void onChunkUnload() {
    }

    public World getWorld() {
        return this.container.func_145831_w();
    }

    @Override
    public IPipeTile getTile() {
        return this.container;
    }

    @Override
    public IGate getGate(EnumFacing side) {
        if (side == null) {
            return null;
        }
        return this.gates[side.ordinal()];
    }

    private void pushActionState(ActionState state) {
        this.actionStates.add(state);
    }

    private Collection<ActionState> getActionStates() {
        return this.actionStates;
    }

    public void scheduleWireUpdate() {
        this.scheduleWireUpdate = true;
    }

    @Override
    public int compareTo(Pipe<?> pipe) {
        return 0;
    }
}

