/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.core.lib.event.IEventBus;
import buildcraft.core.lib.event.IEventBusProvider;
import buildcraft.transport.pipes.events.PipeEvent;
import buildcraft.transport.pipes.events.PipeEventPriority;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PipeEventBus
implements IEventBus<PipeEvent> {
    private static final EventHandlerCompare COMPARATOR = new EventHandlerCompare();
    private static final HashSet<Object> globalHandlers = new HashSet();
    private final HashSet<Object> registeredHandlers = new HashSet();
    private final HashMap<Object, Map<Method, Class<? extends PipeEvent>>> handlerMethods = Maps.newHashMap();
    private final HashMap<Class<? extends PipeEvent>, List<EventHandler>> eventHandlers = Maps.newHashMap();

    public PipeEventBus() {
        for (Object o : globalHandlers) {
            this.registerHandler(o);
        }
    }

    public static void registerGlobalHandler(Object globalHandler) {
        globalHandlers.add(globalHandler);
    }

    private List<EventHandler> getHandlerList(Class<? extends PipeEvent> event) {
        if (!this.eventHandlers.containsKey(event)) {
            this.eventHandlers.put(event, new ArrayList());
        }
        return this.eventHandlers.get(event);
    }

    @Override
    public void registerHandler(Object handler) {
        if (this.registeredHandlers.contains(handler)) {
            return;
        }
        this.registeredHandlers.add(handler);
        HashMap methods = new HashMap();
        for (Method m : handler.getClass().getDeclaredMethods()) {
            Class<?>[] parameters;
            if (!"eventHandler".equals(m.getName()) || (parameters = m.getParameterTypes()).length != 1 || !PipeEvent.class.isAssignableFrom(parameters[0])) continue;
            Class<?> eventType = parameters[0];
            List<EventHandler> eventHandlerList = this.getHandlerList(eventType);
            eventHandlerList.add(new EventHandler(m, handler));
            this.updateEventHandlers(eventHandlerList);
            methods.put(m, eventType);
        }
        this.handlerMethods.put(handler, methods);
    }

    private void updateEventHandlers(List<EventHandler> eventHandlerList) {
        Collections.sort(eventHandlerList, COMPARATOR);
    }

    @Override
    public void unregisterHandler(Object handler) {
        if (!this.registeredHandlers.contains(handler)) {
            return;
        }
        this.registeredHandlers.remove(handler);
        Map<Method, Class<? extends PipeEvent>> methodMap = this.handlerMethods.get(handler);
        for (Method m : methodMap.keySet()) {
            this.getHandlerList(methodMap.get(m)).remove(new EventHandler(m, handler));
        }
        this.handlerMethods.remove(handler);
    }

    @Override
    public void handleEvent(PipeEvent event) {
        for (EventHandler eventHandler : this.getHandlerList(event.getClass())) {
            try {
                eventHandler.method.invoke(eventHandler.owner, event);
            }
            catch (Exception exception) {}
        }
    }

    private static class EventHandlerCompare
    implements Comparator<EventHandler> {
        private EventHandlerCompare() {
        }

        private int getPriority(EventHandler eh) {
            PipeEventPriority p = eh.method.getAnnotation(PipeEventPriority.class);
            return p != null ? p.priority() : 0;
        }

        @Override
        public int compare(EventHandler o1, EventHandler o2) {
            int priority1 = this.getPriority(o1);
            int priority2 = this.getPriority(o2);
            return priority2 - priority1;
        }
    }

    private class EventHandler {
        public Method method;
        public Object owner;

        public EventHandler(Method m, Object o) {
            this.method = m;
            this.owner = o;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof EventHandler)) {
                return false;
            }
            EventHandler e = (EventHandler)o;
            return e.method.equals(this.method) && e.owner == this.owner;
        }
    }

    public static enum Provider implements IEventBusProvider<PipeEvent>
    {
        INSTANCE;


        @Override
        public IEventBus<PipeEvent> newBus() {
            return new PipeEventBus();
        }
    }
}

