/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.core.ISerializable;
import buildcraft.api.transport.pluggable.IConnectionMatrix;
import buildcraft.api.transport.pluggable.IPipeRenderState;
import buildcraft.transport.utils.ConnectionMatrix;
import buildcraft.transport.utils.TextureMatrix;
import buildcraft.transport.utils.WireMatrix;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.EnumFacing;

public class PipeRenderState
implements ISerializable,
IPipeRenderState,
Comparable<PipeRenderState> {
    public final ConnectionMatrix pipeConnectionMatrix = new ConnectionMatrix();
    public final ConnectionMatrix pipeConnectionExtensions = new ConnectionMatrix();
    public final ConnectionMatrix pipeConnectionBanned = new ConnectionMatrix();
    public final TextureMatrix textureMatrix = new TextureMatrix();
    public final WireMatrix wireMatrix = new WireMatrix();
    boolean glassColorDirty = false;
    private byte glassColor = (byte)-127;
    public final float[] customConnections = new float[6];
    private boolean dirty = true;

    public void clean() {
        this.dirty = false;
        this.glassColorDirty = false;
        this.pipeConnectionMatrix.clean();
        this.textureMatrix.clean();
        this.wireMatrix.clean();
        this.pipeConnectionExtensions.clean();
        this.pipeConnectionBanned.clean();
    }

    public byte getGlassColor() {
        return this.glassColor;
    }

    public void setGlassColor(byte color) {
        if (this.glassColor != color) {
            this.glassColor = color;
            this.glassColorDirty = true;
        }
    }

    public boolean isDirty() {
        return this.dirty || this.pipeConnectionMatrix.isDirty() || this.pipeConnectionBanned.isDirty() || this.pipeConnectionExtensions.isDirty() || this.glassColorDirty || this.textureMatrix.isDirty() || this.wireMatrix.isDirty();
    }

    public boolean needsRenderUpdate() {
        return this.glassColorDirty || this.pipeConnectionMatrix.isDirty() || this.pipeConnectionBanned.isDirty() || this.pipeConnectionExtensions.isDirty() || this.textureMatrix.isDirty() || this.wireMatrix.isDirty();
    }

    public void setExtension(EnumFacing direction, float extension) {
        if (extension <= -0.25f) {
            this.pipeConnectionBanned.setConnected(direction, false);
            this.pipeConnectionExtensions.setConnected(direction, false);
            this.customConnections[direction.ordinal()] = extension;
        } else {
            this.pipeConnectionBanned.setConnected(direction, true);
            this.pipeConnectionExtensions.setConnected(direction, extension != 0.0f);
            this.customConnections[direction.ordinal()] = extension;
        }
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeByte(this.glassColor < -1 ? -1 : (int)this.glassColor);
        this.pipeConnectionMatrix.writeData(data);
        this.pipeConnectionExtensions.writeData(data);
        this.pipeConnectionBanned.writeData(data);
        this.textureMatrix.writeData(data);
        this.wireMatrix.writeData(data);
        for (int i = 0; i < this.customConnections.length; ++i) {
            float f = this.customConnections[i];
            if (!this.pipeConnectionExtensions.isConnected(EnumFacing.field_82609_l[i]) || !this.pipeConnectionBanned.isConnected(EnumFacing.field_82609_l[i])) continue;
            data.writeFloat(f);
        }
    }

    @Override
    public void readData(ByteBuf data) {
        byte g = data.readByte();
        if (g != this.glassColor) {
            this.glassColor = g;
            this.glassColorDirty = true;
        }
        this.pipeConnectionMatrix.readData(data);
        this.pipeConnectionExtensions.readData(data);
        this.pipeConnectionBanned.readData(data);
        this.textureMatrix.readData(data);
        this.wireMatrix.readData(data);
        for (int i = 0; i < this.customConnections.length; ++i) {
            EnumFacing face = EnumFacing.field_82609_l[i];
            this.customConnections[i] = this.pipeConnectionExtensions.isConnected(face) && this.pipeConnectionBanned.isConnected(face) ? data.readFloat() : 0.0f;
        }
    }

    @Override
    public IConnectionMatrix getPipeConnectionMatrix() {
        return this.pipeConnectionMatrix;
    }

    @Override
    public int compareTo(PipeRenderState o) {
        return 0;
    }
}

