/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.utils.BitSetUtils;
import buildcraft.transport.TileGenericPipe;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public abstract class PipeTransport {
    public TileGenericPipe container;
    protected boolean shouldSendPacket = false;
    protected boolean[] inputsOpen = new boolean[EnumFacing.field_82609_l.length];
    protected boolean[] outputsOpen = new boolean[EnumFacing.field_82609_l.length];

    public PipeTransport() {
        for (int b = 0; b < EnumFacing.field_82609_l.length; ++b) {
            this.inputsOpen[b] = true;
            this.outputsOpen[b] = true;
        }
    }

    public abstract IPipeTile.PipeType getPipeType();

    public World getWorld() {
        return this.container.func_145831_w();
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("inputOpen") && nbt.func_74764_b("outputOpen")) {
            BitSet inputBuf = BitSetUtils.fromByteArray(new byte[]{nbt.func_74771_c("inputOpen")});
            BitSet outputBuf = BitSetUtils.fromByteArray(new byte[]{nbt.func_74771_c("outputOpen")});
            for (int b = 0; b < EnumFacing.field_82609_l.length; ++b) {
                this.inputsOpen[b] = inputBuf.get(b);
                this.outputsOpen[b] = outputBuf.get(b);
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        BitSet inputBuf = new BitSet(EnumFacing.field_82609_l.length);
        BitSet outputBuf = new BitSet(EnumFacing.field_82609_l.length);
        for (int b = 0; b < EnumFacing.field_82609_l.length; ++b) {
            if (this.inputsOpen[b]) {
                inputBuf.set(b, true);
            } else {
                inputBuf.set(b, false);
            }
            if (this.outputsOpen[b]) {
                outputBuf.set(b, true);
                continue;
            }
            outputBuf.set(b, false);
        }
        nbt.func_74774_a("inputOpen", BitSetUtils.toByteArray(inputBuf)[0]);
        nbt.func_74774_a("outputOpen", BitSetUtils.toByteArray(outputBuf)[0]);
    }

    public void updateEntity() {
    }

    public void setTile(TileGenericPipe tile) {
        this.container = tile;
    }

    public boolean canPipeConnect(TileEntity tile, EnumFacing side) {
        return true;
    }

    public void onNeighborChange(EnumFacing direction) {
    }

    public void onBlockPlaced() {
    }

    public void initialize() {
    }

    public boolean inputOpen(EnumFacing from) {
        return this.inputsOpen[from.ordinal()];
    }

    public boolean outputOpen(EnumFacing to) {
        return this.outputsOpen[to.ordinal()];
    }

    public void allowInput(EnumFacing from, boolean allow) {
        if (from != null) {
            this.inputsOpen[from.ordinal()] = allow;
        }
    }

    public void allowOutput(EnumFacing to, boolean allow) {
        if (to != null) {
            this.outputsOpen[to.ordinal()] = allow;
        }
    }

    public void dropContents() {
    }

    public List<ItemStack> getDroppedItems() {
        return new ArrayList<ItemStack>();
    }

    public void sendDescriptionPacket() {
    }

    public boolean delveIntoUnloadedChunks() {
        return false;
    }
}

