/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.core.BCLog;
import buildcraft.api.transport.IPipeTile;
import buildcraft.transport.IDiamondPipe;
import buildcraft.transport.TileFilteredBuffer;
import buildcraft.transport.gui.ContainerDiamondPipe;
import buildcraft.transport.gui.ContainerEmeraldFluidPipe;
import buildcraft.transport.gui.ContainerEmeraldPipe;
import buildcraft.transport.gui.ContainerEmzuliPipe;
import buildcraft.transport.gui.ContainerFilteredBuffer;
import buildcraft.transport.gui.ContainerGateInterface;
import buildcraft.transport.gui.GuiDiamondPipe;
import buildcraft.transport.gui.GuiEmeraldFluidPipe;
import buildcraft.transport.gui.GuiEmeraldPipe;
import buildcraft.transport.gui.GuiEmzuliPipe;
import buildcraft.transport.gui.GuiFilteredBuffer;
import buildcraft.transport.gui.GuiGateInterface;
import buildcraft.transport.pipes.PipeFluidsEmerald;
import buildcraft.transport.pipes.PipeItemsEmerald;
import buildcraft.transport.pipes.PipeItemsEmzuli;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import org.apache.logging.log4j.Level;

public class TransportGuiHandler
implements IGuiHandler {
    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        try {
            if (world.func_175623_d(pos)) {
                return null;
            }
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileFilteredBuffer) {
                TileFilteredBuffer filteredBuffer = (TileFilteredBuffer)tile;
                return new ContainerFilteredBuffer(player, filteredBuffer);
            }
            if (!(tile instanceof IPipeTile)) {
                return null;
            }
            IPipeTile pipe = (IPipeTile)tile;
            if (pipe.getPipe() == null) {
                return null;
            }
            switch (id) {
                case 50: {
                    return new ContainerDiamondPipe(player, (IDiamondPipe)((Object)pipe.getPipe()));
                }
                case 52: {
                    return new ContainerEmeraldPipe(player, (PipeItemsEmerald)pipe.getPipe());
                }
                case 53: {
                    return new ContainerEmzuliPipe(player, (PipeItemsEmzuli)pipe.getPipe());
                }
                case 54: {
                    return new ContainerEmeraldFluidPipe(player, (PipeFluidsEmerald)pipe.getPipe());
                }
                case 51: {
                    return new ContainerGateInterface(player, pipe.getPipe());
                }
            }
            return null;
        }
        catch (Exception ex) {
            BCLog.logger.log(Level.ERROR, "Failed to open GUI", (Throwable)ex);
            return null;
        }
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        try {
            if (world.func_175623_d(pos)) {
                return null;
            }
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileFilteredBuffer) {
                TileFilteredBuffer filteredBuffer = (TileFilteredBuffer)tile;
                return new GuiFilteredBuffer(player, filteredBuffer);
            }
            if (!(tile instanceof IPipeTile)) {
                return null;
            }
            IPipeTile pipe = (IPipeTile)tile;
            if (pipe.getPipe() == null) {
                return null;
            }
            switch (id) {
                case 50: {
                    return new GuiDiamondPipe(player, (IDiamondPipe)((Object)pipe.getPipe()));
                }
                case 52: {
                    return new GuiEmeraldPipe(player, (PipeItemsEmerald)pipe.getPipe());
                }
                case 53: {
                    return new GuiEmzuliPipe(player, (PipeItemsEmzuli)pipe.getPipe());
                }
                case 54: {
                    return new GuiEmeraldFluidPipe(player, (PipeFluidsEmerald)pipe.getPipe());
                }
                case 51: {
                    return new GuiGateInterface(player, pipe.getPipe());
                }
            }
            return null;
        }
        catch (Exception ex) {
            BCLog.logger.log(Level.ERROR, "Failed to open GUI", (Throwable)ex);
            return null;
        }
    }
}

