/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.transport.pipe_bc8.IPipeBehaviourFactory;
import buildcraft.api.transport.pipe_bc8.PipeAPI_BC8;
import buildcraft.api.transport.pipe_bc8.PipeDefinition_BC8;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.BCRegistry;
import buildcraft.transport.api.impl.EnumPipeType;
import buildcraft.transport.pipes.bc8.EnumPipeMaterial;
import buildcraft.transport.pipes.bc8.behaviour.BehaviourFactoryBasic;
import buildcraft.transport.pipes.bc8.behaviour.BehaviourFactoryPolishedStone;
import buildcraft.transport.pipes.bc8.behaviour.BehaviourFactoryWooden;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TransportPipes_BC8 {
    private static final Table<EnumPipeMaterial, EnumPipeType, PipeDefinition_BC8> pipes = HashBasedTable.create();

    public static void preInit() {
        for (EnumPipeType type : EnumPipeType.CONTENTS) {
            int i;
            for (int i2 = 0; i2 < 4; ++i2) {
                EnumPipeMaterial material = EnumPipeMaterial.STONES[i2][0];
                TransportPipes_BC8.registerDefinition(material, type, TransportPipes_BC8.createBasicDefinition(type, material, false));
                material = EnumPipeMaterial.STONES[i2][1];
                TransportPipes_BC8.registerDefinition(material, type, TransportPipes_BC8.createPolishedStonesDefinition(type, material));
            }
            Object[] unpolished = new PipeDefinition_BC8[4];
            BehaviourFactoryBasic[] unpolishedFactories = new BehaviourFactoryBasic[4];
            PipeDefinition_BC8[] polished = new PipeDefinition_BC8[4];
            BehaviourFactoryPolishedStone[] polishedFactories = new BehaviourFactoryPolishedStone[4];
            for (i = 0; i < 4; ++i) {
                unpolished[i] = (PipeDefinition_BC8)pipes.get((Object)EnumPipeMaterial.STONES[i][0], (Object)type);
                unpolishedFactories[i] = (BehaviourFactoryBasic)((PipeDefinition_BC8)unpolished[i]).behaviourFactory;
                polished[i] = (PipeDefinition_BC8)pipes.get((Object)EnumPipeMaterial.STONES[i][1], (Object)type);
                polishedFactories[i] = (BehaviourFactoryPolishedStone)polished[i].behaviourFactory;
            }
            for (i = 0; i < 4; ++i) {
                ArrayList otherUnpolished = Lists.newArrayList((Object[])unpolished);
                otherUnpolished.remove(unpolished[i]);
                unpolishedFactories[i].setDefinition((PipeDefinition_BC8)unpolished[i], BehaviourFactoryBasic.EnumListStatus.BLACKLIST, otherUnpolished.toArray(new PipeDefinition_BC8[3]));
                polishedFactories[i].setDefinition(polished[i], BehaviourFactoryBasic.EnumListStatus.WHITELIST, new PipeDefinition_BC8[]{unpolished[i], polished[i]});
            }
            TransportPipes_BC8.registerDefinition(EnumPipeMaterial.WOOD, type, TransportPipes_BC8.createWoodenDefinition(type));
        }
        PipeDefinition_BC8 definition = TransportPipes_BC8.createBasicDefinition(EnumPipeType.STRUCTURE, EnumPipeMaterial.COBBLESTONE, true);
        TransportPipes_BC8.registerDefinition(EnumPipeMaterial.COBBLESTONE, EnumPipeType.STRUCTURE, definition);
    }

    public static void addRecipies() {
        ItemStack[] glassTypes = new ItemStack[17];
        glassTypes[0] = new ItemStack(Blocks.field_150359_w);
        for (int i = 0; i < 16; ++i) {
            glassTypes[i + 1] = new ItemStack((Block)Blocks.field_150399_cn, 1, i);
        }
        for (Table.Cell entry : pipes.cellSet()) {
            EnumPipeMaterial material = (EnumPipeMaterial)((Object)entry.getRowKey());
            EnumPipeType type = (EnumPipeType)entry.getColumnKey();
            PipeDefinition_BC8 definition = (PipeDefinition_BC8)entry.getValue();
            Item pipe = PipeAPI_BC8.PIPE_REGISTRY.getItem(definition);
            for (int i = 0; i < 17; ++i) {
                ItemStack output = new ItemStack(pipe, 1, i);
                if (type == EnumPipeType.ITEM) {
                    ItemStack in1 = material.ingredient1;
                    ItemStack in2 = material.ingredient2;
                    GameRegistry.addShapedRecipe((ItemStack)output, (Object[])new Object[]{"1G2", Character.valueOf('1'), in1, Character.valueOf('G'), glassTypes[i], Character.valueOf('2'), in2});
                    continue;
                }
                ItemStack modifier = type == EnumPipeType.FLUID ? new ItemStack(BuildCraftTransport.pipeWaterproof) : new ItemStack(Items.field_151137_ax);
                Item pipeItem = null;
                ItemStack inputPipe = new ItemStack(pipeItem, 1, i);
                GameRegistry.addShapelessRecipe((ItemStack)output, (Object[])new Object[]{modifier, inputPipe});
                GameRegistry.addShapelessRecipe((ItemStack)inputPipe, (Object[])new Object[]{output});
            }
        }
    }

    public static PipeDefinition_BC8 getPipe(EnumPipeType type, EnumPipeMaterial material) {
        return (PipeDefinition_BC8)pipes.get((Object)material, (Object)type);
    }

    private static PipeDefinition_BC8 createBasicDefinition(EnumPipeType type, EnumPipeMaterial material, boolean defineFactoryFully) {
        BehaviourFactoryBasic factory = new BehaviourFactoryBasic();
        PipeDefinition_BC8 definition = TransportPipes_BC8.createDefinition(type, material, factory);
        if (defineFactoryFully) {
            factory.setDefinition(definition, BehaviourFactoryBasic.EnumListStatus.BLACKLIST, new PipeDefinition_BC8[0]);
        }
        return definition;
    }

    private static PipeDefinition_BC8 createPolishedStonesDefinition(EnumPipeType type, EnumPipeMaterial material) {
        BehaviourFactoryPolishedStone factory = new BehaviourFactoryPolishedStone();
        PipeDefinition_BC8 definition = TransportPipes_BC8.createDefinition(type, material, factory);
        return definition;
    }

    private static PipeDefinition_BC8 createWoodenDefinition(EnumPipeType type) {
        BehaviourFactoryWooden factory = new BehaviourFactoryWooden();
        String[] suffixes = new String[]{"_clear", "_filled"};
        PipeDefinition_BC8 definition = TransportPipes_BC8.createDefinition(type, EnumPipeMaterial.WOOD, suffixes, factory);
        factory.setDefinition(definition);
        return definition;
    }

    private static PipeDefinition_BC8 createDefinition(EnumPipeType type, EnumPipeMaterial material, IPipeBehaviourFactory factory) {
        return TransportPipes_BC8.createDefinition(type, material, new String[]{""}, factory);
    }

    private static PipeDefinition_BC8 createDefinition(EnumPipeType type, EnumPipeMaterial material, String[] suffixes, IPipeBehaviourFactory factory) {
        String name = material.name().toLowerCase(Locale.ROOT) + "_" + type.name().toLowerCase(Locale.ROOT);
        PipeDefinition_BC8 definition = new PipeDefinition_BC8(name, type, material.maxSprites, "buildcrafttransport:pipes/", suffixes, factory);
        return definition;
    }

    private static void registerDefinition(EnumPipeMaterial material, EnumPipeType type, PipeDefinition_BC8 definition) {
        Item item = PipeAPI_BC8.PIPE_REGISTRY.registerDefinition(definition);
        pipes.put((Object)material, (Object)type, (Object)definition);
        BCRegistry.INSTANCE.registerItem(item, false);
        item.func_77637_a((CreativeTabs)BCCreativeTab.get("neptune"));
    }

    public static void init() {
    }

    public static void postInit() {
    }
}

