/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.TransportProxy;
import com.google.common.collect.MapMaker;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TravelingItem {
    public static final TravelingItemCache serverCache = new TravelingItemCache();
    public static final TravelingItemCache clientCache = new TravelingItemCache();
    public static final InsertionHandler DEFAULT_INSERTION_HANDLER = new InsertionHandler();
    private static int maxId = 0;
    public final EnumSet<EnumFacing> blacklist = EnumSet.noneOf(EnumFacing.class);
    public Vec3 pos;
    public final int id;
    public boolean toCenter = true;
    public EnumDyeColor color;
    public EnumFacing input = null;
    public EnumFacing output = null;
    public int displayList;
    public boolean hasDisplayList;
    protected float speed = 0.01f;
    protected ItemStack itemStack;
    protected TileEntity container;
    protected NBTTagCompound extraData;
    protected InsertionHandler insertionHandler = DEFAULT_INSERTION_HANDLER;

    protected TravelingItem(int id) {
        this.id = id;
    }

    public static TravelingItem make(int id) {
        TravelingItem item = new TravelingItem(id);
        TravelingItem.getCache().cache(item);
        return item;
    }

    public static TravelingItem make() {
        return TravelingItem.make(maxId < Short.MAX_VALUE ? (maxId = maxId + 1) : (maxId = Short.MIN_VALUE));
    }

    public static TravelingItem make(Vec3 pos, ItemStack stack) {
        TravelingItem item = TravelingItem.make();
        item.pos = pos;
        item.itemStack = stack.func_77946_l();
        return item;
    }

    public static TravelingItem make(NBTTagCompound nbt) {
        TravelingItem item = TravelingItem.make();
        item.readFromNBT(nbt);
        return item;
    }

    public static TravelingItemCache getCache() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return clientCache;
        }
        return serverCache;
    }

    public void movePosition(Vec3 toAdd) {
        this.pos = this.pos.func_178787_e(toAdd);
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack item) {
        this.itemStack = item;
    }

    public TileEntity getContainer() {
        return this.container;
    }

    public void setContainer(TileEntity container) {
        this.container = container;
    }

    public NBTTagCompound getExtraData() {
        if (this.extraData == null) {
            this.extraData = new NBTTagCompound();
        }
        return this.extraData;
    }

    public boolean hasExtraData() {
        return this.extraData != null;
    }

    public void setInsertionHandler(InsertionHandler handler) {
        if (handler == null) {
            return;
        }
        this.insertionHandler = handler;
    }

    public InsertionHandler getInsertionHandler() {
        return this.insertionHandler;
    }

    public void reset() {
        this.toCenter = true;
        this.blacklist.clear();
        this.input = null;
        this.output = null;
    }

    public void readFromNBT(NBTTagCompound data) {
        this.pos = new Vec3(data.func_74769_h("x"), data.func_74769_h("y"), data.func_74769_h("z"));
        this.setSpeed(data.func_74760_g("speed"));
        this.setItemStack(ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("Item")));
        this.toCenter = data.func_74767_n("toCenter");
        this.input = NBTUtils.readEnum(data.func_74781_a("input"), EnumFacing.class);
        this.output = NBTUtils.readEnum(data.func_74781_a("output"), EnumFacing.class);
        byte c = data.func_74771_c("color");
        if (c != -1) {
            this.color = EnumDyeColor.func_176764_b((int)c);
        }
        if (data.func_74764_b("extraData")) {
            this.extraData = data.func_74775_l("extraData");
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_74780_a("x", this.pos.field_72450_a);
        data.func_74780_a("y", this.pos.field_72448_b);
        data.func_74780_a("z", this.pos.field_72449_c);
        data.func_74776_a("speed", this.getSpeed());
        NBTTagCompound itemStackTag = new NBTTagCompound();
        this.getItemStack().func_77955_b(itemStackTag);
        data.func_74782_a("Item", (NBTBase)itemStackTag);
        data.func_74757_a("toCenter", this.toCenter);
        data.func_74782_a("input", NBTUtils.writeEnum(this.input));
        data.func_74782_a("output", NBTUtils.writeEnum(this.output));
        data.func_74774_a("color", this.color != null ? (byte)this.color.func_176765_a() : (byte)-1);
        if (this.extraData != null) {
            data.func_74782_a("extraData", (NBTBase)this.extraData);
        }
    }

    public EntityItem toEntityItem() {
        if (this.container != null && !this.container.func_145831_w().field_72995_K) {
            if (this.getItemStack().field_77994_a <= 0) {
                return null;
            }
            Vec3 motion = Utils.convert(this.output, 0.1 + (double)this.getSpeed() * 2.0);
            EntityItem entity = new EntityItem(this.container.func_145831_w(), this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c, this.getItemStack());
            entity.lifespan = BuildCraftCore.itemLifespan * 20;
            entity.func_174869_p();
            float f3 = 0.0f + this.container.func_145831_w().field_73012_v.nextFloat() * 0.04f - 0.02f;
            entity.field_70159_w = (double)((float)this.container.func_145831_w().field_73012_v.nextGaussian() * f3) + motion.field_72450_a;
            entity.field_70181_x = (double)((float)this.container.func_145831_w().field_73012_v.nextGaussian() * f3) + motion.field_72448_b;
            entity.field_70179_y = (double)((float)this.container.func_145831_w().field_73012_v.nextGaussian() * f3) + motion.field_72449_c;
            return entity;
        }
        return null;
    }

    public float getEntityBrightness(float f) {
        double d = 0.6666666666666666;
        return this.container.func_145831_w().func_175724_o(Utils.convertFloor(this.pos.func_72441_c(0.0, d, 0.0)));
    }

    public boolean isCorrupted() {
        return this.itemStack == null || this.itemStack.field_77994_a <= 0 || this.itemStack.func_77973_b() == null;
    }

    public boolean canBeGroupedWith(TravelingItem otherItem) {
        if (otherItem == this) {
            return false;
        }
        if (this.toCenter != otherItem.toCenter) {
            return false;
        }
        if (this.output != otherItem.output) {
            return false;
        }
        if (this.color != otherItem.color) {
            return false;
        }
        if (this.hasExtraData() || otherItem.hasExtraData()) {
            return false;
        }
        if (this.insertionHandler != DEFAULT_INSERTION_HANDLER) {
            return false;
        }
        if (!this.blacklist.equals(otherItem.blacklist)) {
            return false;
        }
        if (otherItem.isCorrupted()) {
            return false;
        }
        return StackHelper.canStacksMerge(this.itemStack, otherItem.itemStack);
    }

    public boolean tryMergeInto(TravelingItem otherItem) {
        if (!this.canBeGroupedWith(otherItem)) {
            return false;
        }
        if (StackHelper.mergeStacks(this.itemStack, otherItem.itemStack, false) == this.itemStack.field_77994_a) {
            StackHelper.mergeStacks(this.itemStack, otherItem.itemStack, true);
            this.itemStack.field_77994_a = 0;
            return true;
        }
        return false;
    }

    public boolean ignoreWeight() {
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TravelingItem other = (TravelingItem)obj;
        return this.id == other.id;
    }

    public void cleanup() {
        if (this.hasDisplayList) {
            TransportProxy.proxy.clearDisplayList(this.displayList);
            this.hasDisplayList = false;
        }
    }

    public String toString() {
        return "TravelingItem: " + this.id;
    }

    public static class TravelingItemCache {
        private final Map<Integer, TravelingItem> itemCache = new MapMaker().weakValues().makeMap();

        public void cache(TravelingItem item) {
            this.itemCache.put(item.id, item);
        }

        public TravelingItem get(int id) {
            return this.itemCache.get(id);
        }
    }

    public static class InsertionHandler {
        public boolean canInsertItem(TravelingItem item, IInventory inv) {
            return true;
        }
    }
}

