/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.transport.PipeWire;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;

public class WireIconProvider {
    private static final Map<PipeWire, Type> darkMap = Maps.newEnumMap(PipeWire.class);
    private static final Map<PipeWire, Type> litMap = Maps.newEnumMap(PipeWire.class);
    private static Map<Type, TextureAtlasSprite> icons = Maps.newEnumMap(Type.class);

    public TextureAtlasSprite getIcon(PipeWire wire, boolean lit) {
        return icons.get((Object)(lit ? litMap : darkMap).get((Object)wire));
    }

    public static void registerIcons(TextureMap iconRegister) {
        for (Type type : Type.values()) {
            icons.put(type, iconRegister.func_174942_a(type.location));
        }
    }

    public static enum Type {
        RED_DARK(PipeWire.RED, false),
        RED_LIT(PipeWire.RED, true),
        BLUE_DARK(PipeWire.BLUE, false),
        BLUE_LIT(PipeWire.BLUE, true),
        GREEN_DARK(PipeWire.GREEN, false),
        GREEN_LIT(PipeWire.GREEN, true),
        YELLOW_DARK(PipeWire.YELLOW, false),
        YELLOW_LIT(PipeWire.YELLOW, true);

        private final ResourceLocation location;

        private Type(PipeWire type, boolean lit) {
            if (lit) {
                litMap.put(type, this);
            } else {
                darkMap.put(type, this);
            }
            this.location = new ResourceLocation("buildcraftcore:blocks/misc/texture_" + this.name().toLowerCase(Locale.ENGLISH));
        }
    }
}

