/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gates;

import buildcraft.core.lib.sprite.SpriteBuilder;
import buildcraft.core.lib.utils.BCStringUtils;
import java.util.Locale;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class GateDefinition {
    private GateDefinition() {
    }

    public static String getLocalizedName(GateMaterial material, GateLogic logic) {
        if (material == GateMaterial.REDSTONE) {
            return BCStringUtils.localize("gate.name.basic");
        }
        return String.format(BCStringUtils.localize("gate.name"), BCStringUtils.localize("gate.material." + material.getTag()), BCStringUtils.localize("gate.logic." + logic.getTag()));
    }

    public static enum GateLogic {
        AND,
        OR;

        public static final GateLogic[] VALUES;
        @SideOnly(value=Side.CLIENT)
        private TextureAtlasSprite iconLit;
        @SideOnly(value=Side.CLIENT)
        private TextureAtlasSprite iconDark;
        @SideOnly(value=Side.CLIENT)
        private TextureAtlasSprite iconItem;
        @SideOnly(value=Side.CLIENT)
        private TextureAtlasSprite iconGate;

        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite getIconLit() {
            return this.iconLit;
        }

        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite getIconDark() {
            return this.iconDark;
        }

        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite getGateIcon() {
            return this.iconGate;
        }

        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite getIconItem() {
            return this.iconItem;
        }

        public String getTag() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        @SideOnly(value=Side.CLIENT)
        public void registerBlockIcon(TextureMap iconRegister) {
            String lit = "buildcrafttransport:gates/gate_" + this.getTag() + "_lit";
            String dark = "buildcrafttransport:gates/gate_" + this.getTag() + "_dark";
            String base = "buildcrafttransport:gates/gate_" + this.getTag();
            this.iconLit = new SpriteBuilder(lit + "_generated").addSprite(base, 254).addSprite(lit, 254).build();
            this.iconDark = new SpriteBuilder(dark + "_generated").addSprite(base, 254).addSprite(dark, 254).build();
            iconRegister.setTextureEntry(lit + "_generated", this.iconLit);
            iconRegister.setTextureEntry(dark + "_generated", this.iconDark);
            this.iconGate = iconRegister.func_174942_a(new ResourceLocation("buildcrafttransport:gates/gate_" + this.getTag()));
        }

        @SideOnly(value=Side.CLIENT)
        public void registerItemIcon(TextureMap iconRegister) {
            this.iconItem = iconRegister.func_174942_a(new ResourceLocation("buildcrafttransport:gates/gate_logic_" + this.getTag()));
        }

        public static GateLogic fromOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal >= VALUES.length) {
                return AND;
            }
            return VALUES[ordinal];
        }

        static {
            VALUES = GateLogic.values();
        }
    }

    public static enum GateMaterial {
        REDSTONE("gate_interface_1.png", 146, 1, 0, 0, 1),
        IRON("gate_interface_2.png", 164, 2, 0, 0, 2),
        GOLD("gate_interface_3.png", 200, 4, 1, 0, 3),
        DIAMOND("gate_interface_4.png", 200, 8, 1, 0, 4),
        EMERALD("gate_interface_5.png", 200, 4, 3, 3, 4),
        QUARTZ("gate_interface_6.png", 164, 2, 1, 1, 3);

        public static final GateMaterial[] VALUES;
        public final ResourceLocation guiFile;
        public final int guiHeight;
        public final int numSlots;
        public final int numTriggerParameters;
        public final int numActionParameters;
        public final int maxWireColor;
        @SideOnly(value=Side.CLIENT)
        private TextureAtlasSprite iconBlock;
        @SideOnly(value=Side.CLIENT)
        private TextureAtlasSprite iconItem;

        private GateMaterial(String guiFile, int guiHeight, int numSlots, int triggerParameterSlots, int actionParameterSlots, int maxWireColor) {
            this.guiFile = new ResourceLocation("buildcrafttransport:textures/gui/" + guiFile);
            this.guiHeight = guiHeight;
            this.numSlots = numSlots;
            this.numTriggerParameters = triggerParameterSlots;
            this.numActionParameters = actionParameterSlots;
            this.maxWireColor = maxWireColor;
        }

        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite getIconBlock() {
            return this.iconBlock;
        }

        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite getIconItem() {
            return this.iconItem;
        }

        public String getTag() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        @SideOnly(value=Side.CLIENT)
        public void registerBlockIcon(TextureMap iconRegister) {
            if (this != REDSTONE) {
                this.iconBlock = iconRegister.func_174942_a(new ResourceLocation("buildcrafttransport:gates/gate_material_" + this.getTag()));
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void registerItemIcon(TextureMap iconRegister) {
            if (this != REDSTONE) {
                this.iconItem = iconRegister.func_174942_a(new ResourceLocation("buildcrafttransport:gates/gate_material_" + this.getTag()));
            }
        }

        public static GateMaterial fromOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal >= VALUES.length) {
                return REDSTONE;
            }
            return VALUES[ordinal];
        }

        static {
            VALUES = GateMaterial.values();
        }
    }
}

