/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gates;

import buildcraft.api.gates.IGateExpansion;
import buildcraft.core.lib.render.BakedModelHolder;
import buildcraft.core.lib.utils.BCStringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GateExpansionBuildcraft
implements IGateExpansion {
    private final String tag;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite sprite;
    @SideOnly(value=Side.CLIENT)
    private IGateExpansion.IGateStaticRenderState renderState;

    public GateExpansionBuildcraft(String tag) {
        this.tag = tag;
    }

    @Override
    public String getUniqueIdentifier() {
        return "buildcraft:" + this.tag;
    }

    @Override
    public String getDisplayName() {
        return BCStringUtils.localize("gate.expansion." + this.tag);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void textureStitch(TextureMap map) {
        this.sprite = map.func_174942_a(new ResourceLocation("buildcrafttransport:gates/gate_expansion_" + this.tag));
        if (this.renderState != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)this.renderState);
            this.renderState = null;
        }
    }

    @Override
    public IGateExpansion.IGateStaticRenderState getRenderState() {
        if (this.renderState == null) {
            this.renderState = new RenderState();
        }
        return this.renderState;
    }

    public float getPixelExtrusion() {
        return 0.03f;
    }

    @SideOnly(value=Side.CLIENT)
    private class RenderState
    extends BakedModelHolder
    implements IGateExpansion.IGateStaticRenderState {
        private final ResourceLocation identifier = new ResourceLocation("buildcrafttransport:gate/expansion/identifier");
        private List<BakedQuad> transformedQuads;

        private RenderState() {
        }

        @Override
        public List<BakedQuad> bake(VertexFormat format) {
            if (this.transformedQuads == null) {
                IBakedModel baked = this.getModelItemLayer(this.identifier, GateExpansionBuildcraft.this.sprite);
                List quads = baked.func_177550_a();
                ArrayList transformedQuads = Lists.newArrayList();
                Matrix4f translation = new Matrix4f();
                translation.setIdentity();
                translation.setTranslation(new Vector3f((2.0f - GateExpansionBuildcraft.this.getPixelExtrusion()) / 16.0f, 0.0f, 0.0f));
                for (BakedQuad quad : quads) {
                    quad = RenderState.transform(quad, translation);
                    quad = RenderState.replaceTint(quad, 0xFFFFFF);
                    transformedQuads.add(quad);
                }
                this.transformedQuads = transformedQuads;
            }
            return this.transformedQuads;
        }
    }
}

