/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.core.lib.network.PacketCoordinates;
import buildcraft.core.lib.utils.BitSetUtils;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.utils.FluidRenderData;
import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PacketFluidUpdate
extends PacketCoordinates {
    public FluidRenderData renderCache = new FluidRenderData();
    public BitSet delta;
    private short fluidID = 0;
    private int color = 0;
    private int[] amount = new int[7];
    public byte[] flow = new byte[6];

    public PacketFluidUpdate(TileGenericPipe tileG) {
        super(tileG);
    }

    public PacketFluidUpdate(TileGenericPipe tileGP, boolean chunkPacket) {
        super(tileGP);
        this.isChunkDataPacket = chunkPacket;
    }

    public PacketFluidUpdate() {
    }

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        byte[] dBytes = new byte[1];
        data.readBytes(dBytes);
        this.delta = BitSetUtils.fromByteArray(dBytes);
        if (this.delta.get(0)) {
            this.fluidID = data.readShort();
            if (this.fluidID != 0) {
                this.color = data.readInt();
                byte by = data.readByte();
            }
        }
        for (int dir = 0; dir < 7; ++dir) {
            if (this.delta.get(dir + 1)) {
                this.amount[dir] = data.readShort();
            }
            if (dir >= 6) continue;
            this.flow[dir] = data.readByte();
        }
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        byte[] dBytes = BitSetUtils.toByteArray(this.delta, 1);
        data.writeBytes(dBytes);
        if (this.delta.get(0)) {
            data.writeShort(this.renderCache.fluidID);
            if (this.renderCache.fluidID != 0) {
                data.writeInt(this.renderCache.color);
                data.writeByte(this.renderCache.flags);
            }
        }
        for (int dir = 0; dir < 7; ++dir) {
            if (this.delta.get(dir + 1)) {
                data.writeShort(this.renderCache.amount[dir]);
            }
            if (dir >= 6) continue;
            data.writeByte((int)this.flow[dir]);
        }
    }

    @Override
    public void applyData(World world, EntityPlayer player) {
        if (world.func_175623_d(this.pos)) {
            return;
        }
        TileEntity entity = world.func_175625_s(this.pos);
        if (!(entity instanceof TileGenericPipe)) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)entity;
        if (pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeTransportFluids)) {
            return;
        }
        PipeTransportFluids trans = (PipeTransportFluids)pipe.pipe.transport;
        this.renderCache = trans.renderCache;
        this.renderCache.flow = this.flow;
        if (this.delta.get(0)) {
            this.renderCache.fluidID = this.fluidID;
            Fluid fluid = FluidRegistry.getFluid((int)this.fluidID);
            trans.fluidType = fluid == null ? null : new FluidStack(fluid, 1);
            this.renderCache.color = this.color;
        }
        for (int dir = 0; dir < 7; ++dir) {
            if (this.delta.get(dir + 1)) {
                this.renderCache.amount[dir] = this.amount[dir];
            }
            if (dir >= 6) continue;
            trans.clientDisplayFlowConnection[dir] = this.flow[dir];
        }
    }
}

