/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.BuildCraftTransport;
import buildcraft.core.lib.network.base.Packet;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.network.PacketPipeTransportItemStack;
import buildcraft.transport.network.PacketPipeTransportTraveler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class PacketPipeTransportItemStackRequest
extends Packet {
    public int travelerID;
    TravelingItem item;

    public PacketPipeTransportItemStackRequest() {
    }

    public PacketPipeTransportItemStackRequest(TileGenericPipe tile, PacketPipeTransportTraveler packet) {
        this.tempWorld = tile.func_145831_w();
        this.travelerID = packet.getTravelingEntityId();
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        data.writeShort(this.travelerID);
    }

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        this.travelerID = data.readShort();
        TravelingItem.TravelingItemCache cache = TravelingItem.serverCache;
        this.item = cache.get(this.travelerID);
    }

    public void sendDataToPlayer(EntityPlayer player) {
        if (this.item != null) {
            PacketPipeTransportItemStack packet = new PacketPipeTransportItemStack(player.field_70170_p, this.travelerID, this.item.getItemStack());
            BuildCraftTransport.instance.sendToPlayer(player, packet);
        }
    }

    @Override
    public void applyData(World world, EntityPlayer player) {
        this.sendDataToPlayer(player);
    }
}

