/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.ISerializable;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.utils.FluidUtils;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.pipes.PipeFluidsWood;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeFluidsEmerald
extends PipeFluidsWood
implements ISerializable {
    private SimpleInventory filters = new SimpleInventory(1, "Filters", 1);

    public PipeFluidsEmerald(Item item) {
        super(item);
        this.standardIconIndex = PipeIconProvider.TYPE.PipeFluidsEmerald_Standard.ordinal();
        this.solidIconIndex = PipeIconProvider.TYPE.PipeFluidsEmerald_Solid.ordinal();
        ((PipeTransportFluids)this.transport).initFromPipe(this.getClass());
    }

    public IInventory getFilters() {
        return this.filters;
    }

    @Override
    public int extractFluid(IFluidHandler fluidHandler, EnumFacing side) {
        FluidStack targetFluidStack = FluidUtils.getFluidStackFromItemStack(this.filters.func_70301_a(0));
        if (targetFluidStack == null) {
            return super.extractFluid(fluidHandler, side);
        }
        int flowRate = ((PipeTransportFluids)this.transport).getFlowRate();
        FluidStack toExtract = new FluidStack(targetFluidStack, this.fluidToExtract > flowRate ? flowRate : this.fluidToExtract);
        FluidStack extracted = fluidHandler.drain(side.func_176734_d(), toExtract, false);
        if (extracted != null) {
            toExtract.amount = ((PipeTransportFluids)this.transport).fill(side, extracted, true);
            if (toExtract.amount > 0) {
                fluidHandler.drain(side.func_176734_d(), toExtract, true);
            }
        }
        return toExtract.amount;
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer, EnumFacing side) {
        if (entityplayer.func_71045_bC() != null && Block.func_149634_a((Item)entityplayer.func_71045_bC().func_77973_b()) instanceof BlockGenericPipe) {
            return false;
        }
        if (super.blockActivated(entityplayer, side)) {
            return true;
        }
        if (!this.container.func_145831_w().field_72995_K) {
            entityplayer.openGui((Object)BuildCraftTransport.instance, 54, this.container.func_145831_w(), this.container.func_174877_v().func_177958_n(), this.container.func_174877_v().func_177956_o(), this.container.func_174877_v().func_177952_p());
        }
        return true;
    }

    @Override
    public void writeData(ByteBuf data) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.filters.writeToNBT(nbt);
        NetworkUtils.writeNBT(data, nbt);
    }

    @Override
    public void readData(ByteBuf data) {
        NBTTagCompound nbt = NetworkUtils.readNBT(data);
        this.filters.readFromNBT(nbt);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.filters.readFromNBT(nbt);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.filters.writeToNBT(nbt);
    }
}

