/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.ISerializable;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.transport.IPipeTile;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.pipes.PipeLogicWood;
import cofh.api.energy.IEnergyHandler;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PipeFluidsWood
extends Pipe<PipeTransportFluids>
implements IEnergyHandler,
ISerializable,
IDebuggable {
    private static final int ENERGY_MULTIPLIER = 50;
    public int fluidToExtract;
    protected int standardIconIndex = PipeIconProvider.TYPE.PipeFluidsWood_Standard.ordinal();
    protected int solidIconIndex = PipeIconProvider.TYPE.PipeFluidsWood_Solid.ordinal();
    private PipeLogicWood logic = new PipeLogicWood(this){

        @Override
        protected boolean isValidConnectingTile(TileEntity tile) {
            if (tile instanceof IPipeTile) {
                return false;
            }
            return tile instanceof IFluidHandler;
        }
    };

    public PipeFluidsWood(Item item) {
        super(new PipeTransportFluids(), item);
        ((PipeTransportFluids)this.transport).initFromPipe(this.getClass());
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer, EnumFacing side) {
        return this.logic.blockActivated(entityplayer, EnumPipePart.fromFacing(side));
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        this.logic.onNeighborBlockChange();
        super.onNeighborBlockChange(blockId);
    }

    @Override
    public void initialize() {
        this.logic.initialize();
        super.initialize();
    }

    private TileEntity getConnectingTile() {
        int meta = this.container.func_145832_p();
        return meta >= 6 ? null : this.container.getTile(EnumFacing.func_82600_a((int)meta));
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.fluidToExtract <= 0) {
            return;
        }
        TileEntity tile = this.getConnectingTile();
        if (tile == null || !(tile instanceof IFluidHandler)) {
            this.fluidToExtract = 0;
        } else {
            this.extractFluid((IFluidHandler)tile, EnumFacing.func_82600_a((int)this.container.func_145832_p()));
            this.fluidToExtract -= ((PipeTransportFluids)this.transport).getFlowRate();
            if (this.fluidToExtract < 0) {
                this.fluidToExtract = 0;
            }
        }
    }

    public int extractFluid(IFluidHandler fluidHandler, EnumFacing side) {
        int amount = this.fluidToExtract > ((PipeTransportFluids)this.transport).getFlowRate() ? ((PipeTransportFluids)this.transport).getFlowRate() : this.fluidToExtract;
        FluidTankInfo tankInfo = ((PipeTransportFluids)this.transport).getTankInfo(side)[0];
        FluidStack extracted = tankInfo.fluid != null ? fluidHandler.drain(side.func_176734_d(), new FluidStack(tankInfo.fluid, amount), false) : fluidHandler.drain(side.func_176734_d(), amount, false);
        int inserted = 0;
        if (extracted != null && (inserted = ((PipeTransportFluids)this.transport).fill(side, extracted, true)) > 0) {
            extracted.amount = inserted;
            fluidHandler.drain(side.func_176734_d(), extracted, true);
        }
        return inserted;
    }

    protected int getEnergyMultiplier() {
        return 5 * BuildCraftTransport.pipeFluidsBaseFlowRate;
    }

    protected int getMaxExtractionFluid() {
        return 100 * BuildCraftTransport.pipeFluidsBaseFlowRate;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(EnumFacing direction) {
        if (direction == null) {
            return this.standardIconIndex;
        }
        int metadata = this.container.func_145832_p();
        if (metadata == direction.ordinal()) {
            return this.solidIconIndex;
        }
        return this.standardIconIndex;
    }

    @Override
    public boolean outputOpen(EnumFacing to) {
        int meta = this.container.func_145832_p();
        return super.outputOpen(to) && meta != to.ordinal();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        TileEntity tile = this.getConnectingTile();
        if (tile == null || !(tile instanceof IFluidHandler)) {
            return 0;
        }
        int maxToReceive = (this.getMaxExtractionFluid() - this.fluidToExtract) / this.getEnergyMultiplier();
        int received = Math.min(maxReceive, maxToReceive);
        if (!simulate) {
            this.fluidToExtract += this.getEnergyMultiplier() * received;
        }
        return received;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return 1000 / this.getEnergyMultiplier();
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeShort(this.fluidToExtract);
    }

    @Override
    public void readData(ByteBuf data) {
        this.fluidToExtract = data.readShort();
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("");
        left.add("PipeFluidsWood");
        left.add(" Fluid Extraction Potential = " + this.fluidToExtract + "mB");
    }
}

