/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.transport.IPipeTile;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.pipes.events.PipeEventPriority;
import java.util.LinkedList;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PipeItemsClay
extends Pipe<PipeTransportItems> {
    public PipeItemsClay(Item item) {
        super(new PipeTransportItems(), item);
        ((PipeTransportItems)this.transport).allowBouncing = true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(EnumFacing direction) {
        return PipeIconProvider.TYPE.PipeItemsClay.ordinal();
    }

    @PipeEventPriority(priority=-200)
    public void eventHandler(PipeEventItem.FindDest event) {
        LinkedList<EnumFacing> nonPipesList = new LinkedList<EnumFacing>();
        LinkedList<EnumFacing> pipesList = new LinkedList<EnumFacing>();
        for (EnumFacing o : event.destinations) {
            if (event.item.blacklist.contains(o) || !this.container.pipe.outputOpen(o) || !this.container.isPipeConnected(o)) continue;
            TileEntity entity = this.container.getTile(o);
            if (entity instanceof IPipeTile) {
                pipesList.add(o);
                continue;
            }
            nonPipesList.add(o);
        }
        event.destinations.clear();
        if (nonPipesList.isEmpty()) {
            event.destinations.addAll(pipesList);
        } else {
            event.destinations.addAll(nonPipesList);
        }
    }
}

