/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IDiamondPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.pipes.events.PipeEventPriority;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PipeItemsDiamond
extends Pipe<PipeTransportItems>
implements IDiamondPipe {
    private SimpleFilterInventory filters = new SimpleFilterInventory(54, "Filters", 1);
    private long usedFilters;

    public PipeItemsDiamond(Item item) {
        super(new PipeTransportItems(), item);
    }

    @Override
    public IInventory getFilters() {
        return this.filters;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(EnumFacing direction) {
        return PipeIconProvider.diamondPipeItems.get(direction).ordinal();
    }

    @Override
    public int getIconIndexForItem() {
        return PipeIconProvider.TYPE.PipeItemsDiamond_Item.ordinal();
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer, EnumFacing direction) {
        if (entityplayer.func_71045_bC() != null && Block.func_149634_a((Item)entityplayer.func_71045_bC().func_77973_b()) instanceof BlockGenericPipe) {
            return false;
        }
        if (!this.container.func_145831_w().field_72995_K) {
            entityplayer.openGui((Object)BuildCraftTransport.instance, 50, this.container.func_145831_w(), this.container.func_174877_v().func_177958_n(), this.container.func_174877_v().func_177956_o(), this.container.func_174877_v().func_177952_p());
        }
        return true;
    }

    private boolean findDest(PipeEventItem.FindDest event) {
        for (EnumFacing dir : event.destinations) {
            if (this.filters.filterCounts[dir.ordinal()] <= 0) continue;
            for (int slot = 0; slot < 9; ++slot) {
                ItemStack filter;
                int v = dir.ordinal() * 9 + slot;
                if ((this.usedFilters & (long)(1 << v)) != 0L || !StackHelper.isMatchingItemOrList(filter = this.getFilters().func_70301_a(v), event.item.getItemStack())) continue;
                this.usedFilters |= (long)(1 << v);
                event.destinations.clear();
                event.destinations.add(dir);
                event.shuffle = false;
                return true;
            }
        }
        return false;
    }

    private void clearDest(PipeEventItem.FindDest event) {
        for (EnumFacing dir : event.destinations) {
            if (this.filters.filterCounts[dir.ordinal()] <= 0) continue;
            for (int slot = 0; slot < 9; ++slot) {
                ItemStack filter;
                int v = dir.ordinal() * 9 + slot;
                if ((this.usedFilters & (long)(1 << v)) == 0L || !StackHelper.isMatchingItemOrList(filter = this.getFilters().func_70301_a(v), event.item.getItemStack())) continue;
                this.usedFilters ^= (long)(1 << v);
            }
        }
    }

    @PipeEventPriority(priority=-4194304)
    public void eventHandler(PipeEventItem.FindDest event) {
        if (this.findDest(event)) {
            return;
        }
        if (this.usedFilters != 0L) {
            this.clearDest(event);
            if (this.findDest(event)) {
                return;
            }
        }
        Iterator<EnumFacing> i = event.destinations.iterator();
        while (i.hasNext()) {
            if (this.filters.filterCounts[i.next().ordinal()] <= 0) continue;
            i.remove();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.filters.readFromNBT(nbt);
        if (nbt.func_74764_b("usedFilters")) {
            this.usedFilters = nbt.func_74763_f("usedFilters");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.filters.writeToNBT(nbt);
        nbt.func_74772_a("usedFilters", this.usedFilters);
    }

    @Override
    public void writeData(ByteBuf data) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.filters.writeToNBT(nbt);
        nbt.func_74772_a("usedFilters", this.usedFilters);
        NetworkUtils.writeNBT(data, nbt);
    }

    @Override
    public void readData(ByteBuf data) {
        NBTTagCompound nbt = NetworkUtils.readNBT(data);
        this.filters.readFromNBT(nbt);
        if (nbt.func_74764_b("usedFilters")) {
            this.usedFilters = nbt.func_74763_f("usedFilters");
        }
    }

    private class SimpleFilterInventory
    extends SimpleInventory {
        protected int[] filterCounts;

        public SimpleFilterInventory(int size, String invName, int invStackLimit) {
            super(size, invName, invStackLimit);
            this.filterCounts = new int[6];
        }

        @Override
        public void func_70296_d() {
            super.func_70296_d();
            for (int i = 0; i < 6; ++i) {
                this.filterCounts[i] = 0;
                for (int j = 0; j < 9; ++j) {
                    if (this.func_70301_a(j + i * 9) == null) continue;
                    int n = i;
                    this.filterCounts[n] = this.filterCounts[n] + 1;
                }
            }
        }
    }
}

