/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.inventory.InventoryWrapper;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.PipeLogicWood;
import cofh.api.energy.IEnergyHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PipeItemsWood
extends Pipe<PipeTransportItems>
implements IEnergyHandler {
    protected RFBattery battery = new RFBattery(2560, 80, 0);
    protected int standardIconIndex = PipeIconProvider.TYPE.PipeItemsWood_Standard.ordinal();
    protected int solidIconIndex = PipeIconProvider.TYPE.PipeItemsWood_Solid.ordinal();
    protected float speedMultiplier = 1.0f;
    private int ticksSincePull = 0;
    private PipeLogicWood logic = new PipeLogicWood(this){

        @Override
        protected boolean isValidConnectingTile(TileEntity tile) {
            if (tile instanceof IPipeTile) {
                return false;
            }
            return tile instanceof IInventory;
        }
    };

    public PipeItemsWood(Item item) {
        super(new PipeTransportItems(), item);
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer, EnumFacing side) {
        return this.logic.blockActivated(entityplayer, EnumPipePart.fromFacing(side));
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        this.logic.onNeighborBlockChange();
        super.onNeighborBlockChange(blockId);
    }

    @Override
    public void initialize() {
        this.logic.initialize();
        super.initialize();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(EnumFacing direction) {
        if (direction == null) {
            return this.standardIconIndex;
        }
        int metadata = this.container.func_145832_p();
        if (metadata == direction.ordinal()) {
            return this.solidIconIndex;
        }
        return this.standardIconIndex;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        ++this.ticksSincePull;
        if (this.shouldTick()) {
            if (((PipeTransportItems)this.transport).getNumberOfStacks() < 64) {
                this.extractItems();
            }
            this.battery.setEnergy(0);
            this.ticksSincePull = 0;
            this.speedMultiplier = 1.0f;
            this.onPostTick();
        }
    }

    public void onPostTick() {
    }

    private boolean shouldTick() {
        EnumFacing side;
        TileEntity tile;
        int meta;
        if (this.ticksSincePull < 8) {
            return false;
        }
        if (this.ticksSincePull < 16 && (meta = this.container.func_145832_p()) <= 5 && (tile = this.container.getTile(side = EnumFacing.func_82600_a((int)meta))) instanceof IInventory) {
            int stackSize = 0;
            IInventory inventory = (IInventory)tile;
            ItemStack[] extracted = this.checkExtract(inventory, false, side.func_176734_d());
            if (extracted != null) {
                for (ItemStack s : extracted) {
                    stackSize += s.field_77994_a;
                }
            }
            if (this.battery.getEnergyStored() >= stackSize * 10) {
                return true;
            }
        }
        return this.ticksSincePull >= 16 && this.battery.getEnergyStored() >= 10;
    }

    private void extractItems() {
        int meta = this.container.func_145832_p();
        if (meta > 5) {
            return;
        }
        EnumFacing side = EnumFacing.func_82600_a((int)meta);
        TileEntity tile = this.container.getTile(side);
        if (tile instanceof IInventory) {
            IInventory inventory = (IInventory)tile;
            ItemStack[] extracted = this.checkExtract(inventory, true, side.func_176734_d());
            if (extracted == null) {
                return;
            }
            tile.func_70296_d();
            for (ItemStack stack : extracted) {
                if (stack == null || stack.field_77994_a == 0) continue;
                Vec3 entPos = Utils.convertMiddle((Vec3i)tile.func_174877_v()).func_178787_e(Utils.convert(side, -0.6));
                TravelingItem entity = this.makeItem(entPos, stack);
                entity.setSpeed(0.01f);
                ((PipeTransportItems)this.transport).injectItem(entity, side.func_176734_d());
            }
        }
    }

    protected TravelingItem makeItem(Vec3 pos, ItemStack stack) {
        return TravelingItem.make(pos, stack);
    }

    public ItemStack[] checkExtract(IInventory inventory, boolean doRemove, EnumFacing from) {
        IInventory inv = InvUtils.getInventory(inventory);
        ItemStack result = this.checkExtractGeneric(inv, doRemove, from);
        if (result != null) {
            return new ItemStack[]{result};
        }
        return null;
    }

    public ItemStack checkExtractGeneric(IInventory inventory, boolean doRemove, EnumFacing from) {
        return this.checkExtractGeneric(InventoryWrapper.getWrappedInventory(inventory), doRemove, from);
    }

    public ItemStack checkExtractGeneric(ISidedInventory inventory, boolean doRemove, EnumFacing from) {
        if (inventory == null) {
            return null;
        }
        for (int k : inventory.func_180463_a(from)) {
            ItemStack slot = inventory.func_70301_a(k);
            if (slot == null || slot.field_77994_a <= 0 || !inventory.func_180461_b(k, slot, from)) continue;
            if (doRemove) {
                int maxStackSize = slot.field_77994_a;
                int stackSize = Math.min(maxStackSize, this.battery.getEnergyStored() / 10);
                int energyUsed = (int)((float)(stackSize * 10) * this.speedMultiplier);
                this.battery.useEnergy(energyUsed, energyUsed, false);
                return inventory.func_70298_a(k, stackSize);
            }
            return slot;
        }
        return null;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.battery.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.battery.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.battery.getMaxEnergyStored();
    }
}

