/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.power.IRedstoneEngine;
import buildcraft.api.power.IRedstoneEngineReceiver;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.RFBattery;
import buildcraft.transport.IPipeTransportPowerHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportPower;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PipePowerWood
extends Pipe<PipeTransportPower>
implements IPipeTransportPowerHook,
IEnergyHandler,
IRedstoneEngineReceiver,
IDebuggable {
    public final boolean[] powerSources = new boolean[6];
    protected int standardIconIndex = PipeIconProvider.TYPE.PipePowerWood_Standard.ordinal();
    protected int solidIconIndex = PipeIconProvider.TYPE.PipePowerWood_Solid.ordinal();
    protected RFBattery battery = new RFBattery(40960, 40960, 0);
    private int requestedEnergy;
    private int lastRequestedEnergy;
    private int sources;
    private boolean allowExtraction = false;

    public PipePowerWood(Item item) {
        super(new PipeTransportPower(), item);
        ((PipeTransportPower)this.transport).initFromPipe(this.getClass());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(EnumFacing direction) {
        if (direction != null && this.powerSources[direction.ordinal()]) {
            return this.solidIconIndex;
        }
        return this.standardIconIndex;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        this.sources = 0;
        for (EnumFacing o : EnumFacing.field_82609_l) {
            boolean oldPowerSource = this.powerSources[o.ordinal()];
            if (!this.container.isPipeConnected(o)) {
                this.powerSources[o.ordinal()] = false;
            } else {
                TileEntity tile = this.container.getTile(o);
                this.powerSources[o.ordinal()] = ((PipeTransportPower)this.transport).isPowerSource(tile, o);
                if (this.powerSources[o.ordinal()]) {
                    ++this.sources;
                }
            }
            if (oldPowerSource == this.powerSources[o.ordinal()]) continue;
            this.container.scheduleRenderUpdate();
        }
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        if (this.sources <= 0) {
            this.battery.useEnergy(0, 50, false);
            this.requestedEnergy = 0;
            return;
        }
        if (this.allowExtraction) {
            this.allowExtraction = false;
            int energyMaxExtract = Math.min(((PipeTransportPower)this.transport).maxPower, this.battery.getMaxEnergyStored() - this.battery.getEnergyStored());
            energyMaxExtract /= this.sources;
            for (EnumFacing o : EnumFacing.field_82609_l) {
                int energyExtracted;
                if (!this.powerSources[o.ordinal()]) continue;
                TileEntity source = this.container.getNeighborTile(o);
                if (source instanceof IEnergyProvider) {
                    energyExtracted = this.battery.addEnergy(0, ((IEnergyProvider)source).extractEnergy(o.func_176734_d(), energyMaxExtract, true), false);
                    ((IEnergyProvider)source).extractEnergy(o.func_176734_d(), energyExtracted, true);
                    continue;
                }
                if (!(source instanceof IEnergyHandler)) continue;
                energyExtracted = this.battery.addEnergy(0, ((IEnergyHandler)source).extractEnergy(o.func_176734_d(), energyMaxExtract, true), false);
                ((IEnergyHandler)source).extractEnergy(o.func_176734_d(), energyExtracted, true);
            }
        }
        int energyToRemove = Math.min(this.battery.getEnergyStored(), this.requestedEnergy);
        energyToRemove /= this.sources;
        if (this.battery.getEnergyStored() > 0) {
            for (EnumFacing o : EnumFacing.field_82609_l) {
                if (!this.powerSources[o.ordinal()]) continue;
                this.battery.setEnergy(this.battery.getEnergyStored() - (int)((PipeTransportPower)this.transport).receiveEnergy(o, energyToRemove));
            }
        }
        this.lastRequestedEnergy = this.requestedEnergy;
        this.requestedEnergy = 0;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        NBTTagCompound batteryNBT = new NBTTagCompound();
        this.battery.writeToNBT(batteryNBT);
        data.func_74782_a("battery", (NBTBase)batteryNBT);
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            data.func_74757_a("powerSources[" + i + "]", this.powerSources[i]);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.battery.readFromNBT(data.func_74775_l("battery"));
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            this.powerSources[i] = data.func_74767_n("powerSources[" + i + "]");
        }
    }

    @Override
    public int receiveEnergy(EnumFacing from, int val) {
        return -1;
    }

    @Override
    public int requestEnergy(EnumFacing from, int amount) {
        if (this.container.getTile(from) instanceof IPipeTile) {
            this.requestedEnergy += amount;
            return amount;
        }
        return 0;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (from.ordinal() < 6 && this.container.getNeighborTile(from) instanceof IRedstoneEngine) {
            this.allowExtraction = true;
            return maxReceive;
        }
        if (from.ordinal() < 6 && this.powerSources[from.ordinal()]) {
            return this.battery.receiveEnergy(simulate ? Math.min(maxReceive, this.lastRequestedEnergy) : Math.min(maxReceive, this.battery.getMaxEnergyStored() - this.battery.getEnergyStored()), simulate);
        }
        return 0;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.battery.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.battery.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectRedstoneEngine(EnumFacing side) {
        return true;
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing face) {
        left.add("");
        left.add("Power Acceptor");
        left.add("- requestedEnergy: " + this.requestedEnergy);
        left.add("- lastRequestedEnergy: " + this.lastRequestedEnergy);
        left.add("- stored: " + this.battery.getEnergyStored() + "/" + this.battery.getMaxEnergyStored() + " RF");
    }
}

