/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes.bc8;

import buildcraft.api.transport.pipe_bc8.IPipePropertyProvider;
import buildcraft.api.transport.pipe_bc8.IPipe_BC8;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PipePropertyProviderEditable
implements IPipePropertyProvider.IPipePropertyProviderEditable {
    private final Map<IPipePropertyProvider.IPipePropertyValue<?>, Object> values = Maps.newHashMap();
    private final Set valueSet = Collections.unmodifiableSet(this.values.keySet());
    private final IPipe_BC8 pipe;

    public PipePropertyProviderEditable() {
        this(null);
    }

    public PipePropertyProviderEditable(IPipe_BC8 pipe) {
        this.pipe = pipe;
    }

    @Override
    public <T> T getValue(IPipePropertyProvider.IPipeProperty<T> property) {
        if (property instanceof IPipePropertyProvider.IPipePropertyImplicit) {
            if (this.pipe != null) {
                return ((IPipePropertyProvider.IPipePropertyImplicit)property).getValue(this.pipe);
            }
            return property.getDefault();
        }
        if (this.values.containsKey(property)) {
            return (T)this.values.get(property);
        }
        return property.getDefault();
    }

    @Override
    public boolean hasProperty(IPipePropertyProvider.IPipeProperty<?> property) {
        if (property instanceof IPipePropertyProvider.IPipePropertyImplicit) {
            return this.pipe != null;
        }
        return this.values.containsKey(property);
    }

    @Override
    public Set<IPipePropertyProvider.IPipeProperty<?>> getPropertySet() {
        return this.valueSet;
    }

    @Override
    public <T> void addProperty(IPipePropertyProvider.IPipePropertyValue<T> property) {
        this.values.put(property, property.getDefault());
    }

    @Override
    public <T> void removeProperty(IPipePropertyProvider.IPipePropertyValue<T> property) {
        this.values.remove(property);
    }

    @Override
    public IPipePropertyProvider asReadOnly() {
        return this;
    }

    @Override
    public IPipePropertyProvider.IPipePropertyProviderEditable readFromNBT(NBTBase nbt) {
        return this;
    }

    @Override
    public NBTBase writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Map.Entry<IPipePropertyProvider.IPipePropertyValue<?>, Object> entry : this.values.entrySet()) {
            IPipePropertyProvider.IPipePropertyValue<?> property = entry.getKey();
            String name = entry.getKey().getName();
            nbt.func_74782_a(name, property.writeToNBT());
        }
        return nbt;
    }

    @Override
    public IPipePropertyProvider.IPipePropertyProviderEditable readFromByteBuf(ByteBuf buf) {
        return this;
    }

    @Override
    public void writeToByteBuf(ByteBuf buf) {
    }
}

