/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes.bc8.behaviour;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.transport.pipe_bc8.BCPipeEventHandler;
import buildcraft.api.transport.pipe_bc8.IConnection_BC8;
import buildcraft.api.transport.pipe_bc8.IExtractionManager;
import buildcraft.api.transport.pipe_bc8.IInsertionManager;
import buildcraft.api.transport.pipe_bc8.IPipeContentsEditable;
import buildcraft.api.transport.pipe_bc8.IPipe_BC8;
import buildcraft.api.transport.pipe_bc8.PipeAPI_BC8;
import buildcraft.api.transport.pipe_bc8.PipeBehaviour_BC8;
import buildcraft.api.transport.pipe_bc8.PipeDefinition_BC8;
import buildcraft.api.transport.pipe_bc8.event_bc8.IPipeEventConnection_BC8;
import buildcraft.api.transport.pipe_bc8.event_bc8.IPipeEventInteract_BC8;
import buildcraft.api.transport.pipe_bc8.event_bc8.IPipeEvent_BC8;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.NetworkUtils;
import cofh.api.energy.IEnergyReceiver;
import com.google.common.eventbus.Subscribe;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;

public class BehaviourWood
extends PipeBehaviour_BC8
implements IEnergyReceiver {
    private static final int ENERGY_EXTRACT_SINGLE = 20;
    private static final int MAX_ENERGY = 1280;
    protected static final int POWER_MULTIPLIER = 100;
    protected static final int FLUID_MULTIPLIER = 40;
    private EnumPipePart extractionFace = EnumPipePart.CENTER;
    protected final RFBattery battery = new RFBattery(1280, 1280, 1280);

    public BehaviourWood(PipeDefinition_BC8 definition, IPipe_BC8 pipe) {
        super(definition, pipe);
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("extractionFace", NBTUtils.writeEnum(this.extractionFace));
        NBTTagCompound battNBT = new NBTTagCompound();
        this.battery.writeToNBT(battNBT);
        nbt.func_74782_a("battery", (NBTBase)battNBT);
        return nbt;
    }

    @Override
    public BehaviourWood readFromNBT(NBTBase base) {
        NBTTagCompound nbt = (NBTTagCompound)base;
        this.extractionFace = NBTUtils.readEnum(nbt.func_74781_a("extractionFace"), EnumPipePart.class);
        this.battery.readFromNBT(nbt.func_74775_l("battery"));
        return this;
    }

    @Override
    public void writeToByteBuf(ByteBuf buf) {
        NetworkUtils.writeEnum(buf, this.extractionFace);
        buf.writeInt(this.battery.getEnergyStored());
    }

    @Override
    public BehaviourWood readFromByteBuf(ByteBuf buf) {
        this.extractionFace = NetworkUtils.readEnum(buf, EnumPipePart.class);
        this.battery.setEnergy(buf.readInt());
        return this;
    }

    @Override
    public int getIconIndex(EnumFacing side) {
        return side == this.extractionFace.face ? 1 : 0;
    }

    @BCPipeEventHandler
    public void onPipeAttemptConnect(IPipeEventConnection_BC8.AttemptCreate event) {
        IPipeEventConnection_BC8.AttemptCreate.Pipe pipeEvent;
        PipeBehaviour_BC8 other;
        if (event instanceof IPipeEventConnection_BC8.AttemptCreate.Pipe && (other = (pipeEvent = (IPipeEventConnection_BC8.AttemptCreate.Pipe)event).with().getBehaviour()) instanceof BehaviourWood) {
            event.disallow();
        }
    }

    @BCPipeEventHandler
    public void onTick(IPipeEvent_BC8.Tick tick) {
        if (this.battery.getEnergyStored() > 20) {
            int energyRequired = this.extract(this.battery.getEnergyStored());
            this.battery.extractEnergy(energyRequired, false);
        }
    }

    private int extract(int availableEnergy) {
        IConnection_BC8 connection = this.pipe.getConnections().get(this.extractionFace.face);
        if (connection == null) {
            return 0;
        }
        IExtractionManager.IExtractable_BC8 extractable = this.pipe.getConnections().get(this.extractionFace).getExtractor();
        IInsertionManager.IInsertable_BC8 insertable = PipeAPI_BC8.INSERTION_MANAGER.getInsertableFor(this.pipe);
        IPipeContentsEditable contents = this.extractType(availableEnergy, insertable, extractable);
        if (contents == null) {
            return 0;
        }
        int energyRequired = this.getEnergyCost(contents);
        boolean inserted = insertable.tryInsert(contents, this.pipe, this.extractionFace.face.func_176734_d(), false);
        if (!inserted) {
            throw new IllegalStateException("Cannot NOT insert!");
        }
        return energyRequired;
    }

    protected IPipeContentsEditable extractType(int availableEnergy, IInsertionManager.IInsertable_BC8 pipeInsertable, IExtractionManager.IExtractable_BC8 extractable) {
        return null;
    }

    protected int getEnergyCost(IPipeContentsEditable contents) {
        if (contents instanceof IPipeContentsEditable.IPipeContentsEditableItem) {
            ItemStack stack = ((IPipeContentsEditable.IPipeContentsEditableItem)contents).cloneItemStack();
            return 20 * stack.field_77994_a;
        }
        if (contents instanceof IPipeContentsEditable.IPipeContentsEditableFluid) {
            FluidStack stack = ((IPipeContentsEditable.IPipeContentsEditableFluid)contents).cloneFluidStack();
            return 20 * stack.amount / 40;
        }
        throw new IllegalStateException("Was not an expected type! (" + contents.getClass() + ")");
    }

    @Subscribe
    public void disconnectBlock(IPipeEventConnection_BC8.Destroy disconnect) {
        if (disconnect.getFace() == this.extractionFace.face) {
            this.extractionFace = EnumPipePart.CENTER;
            this.selectNewDirection();
        }
    }

    @Subscribe
    public void connectBlock(IPipeEventConnection_BC8.Create connect) {
        if (this.extractionFace == null) {
            this.selectNewDirection();
        }
    }

    @Subscribe
    public void onWrench(IPipeEventInteract_BC8.UseWrench wrench) {
        this.selectNewDirection();
    }

    private void selectNewDirection() {
        if (this.pipe.getWorld().field_72995_K) {
            return;
        }
        EnumPipePart part = this.extractionFace;
        if (part == EnumPipePart.CENTER) {
            part = part.next();
        }
        for (int left = 6; left > 0; --left) {
            part = part.next();
            IConnection_BC8 connection = this.pipe.getConnections().get(part.face);
            if (!this.isValidExtraction(connection)) continue;
            this.extractionFace = part;
            this.pipe.sendClientUpdate(this);
            this.pipe.sendRenderUpdate();
            return;
        }
        this.extractionFace = EnumPipePart.CENTER;
        this.pipe.sendClientUpdate(this);
        this.pipe.sendRenderUpdate();
    }

    protected boolean isValidExtraction(IConnection_BC8 connection) {
        if (connection == null) {
            return false;
        }
        IExtractionManager.IExtractable_BC8 extractable = connection.getExtractor();
        return this.definition.type == PipeAPI_BC8.PIPE_TYPE_ITEM ? extractable.givesItems() : extractable.givesFluids();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return this.pipe.getConnections().get(from) == null;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.battery.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.battery.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.battery.getMaxEnergyStored();
    }
}

