/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pluggable;

import buildcraft.BuildCraftTransport;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.IPipePluggableStaticRenderer;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.utils.MatrixTranformations;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.pluggable.LensPluggableModel;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;

public class LensPluggable
extends PipePluggable {
    @Deprecated
    public int color;
    public boolean isFilter;
    protected IPipeTile container;
    private EnumFacing side;

    public LensPluggable() {
    }

    public LensPluggable(ItemStack stack) {
        this.color = stack.func_77952_i() & 0xF;
        boolean bl = this.isFilter = stack.func_77952_i() >= 16;
        if (stack.func_77952_i() >= 32) {
            this.isFilter = stack.func_77952_i() == 33;
            this.color = -1;
        }
    }

    @Override
    public void validate(IPipeTile pipe, EnumFacing direction) {
        this.container = pipe;
        this.side = direction;
    }

    @Override
    public void invalidate() {
        this.container = null;
        this.side = null;
    }

    @Override
    public ItemStack[] getDropItems(IPipeTile pipe) {
        int meta = this.color | (this.isFilter ? 16 : 0);
        if (this.color == -1) {
            meta = this.isFilter ? 33 : 32;
        }
        return new ItemStack[]{new ItemStack(BuildCraftTransport.lensItem, 1, meta)};
    }

    @Override
    public boolean isBlocking(IPipeTile pipe, EnumFacing direction) {
        return false;
    }

    @Override
    public AxisAlignedBB getBoundingBox(EnumFacing side) {
        float[][] bounds = new float[3][2];
        bounds[0][0] = 0.1875f;
        bounds[0][1] = 0.8125f;
        bounds[1][0] = 0.0f;
        bounds[1][1] = 0.125f;
        bounds[2][0] = 0.1875f;
        bounds[2][1] = 0.8125f;
        MatrixTranformations.transform(bounds, side);
        return new AxisAlignedBB((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    @Override
    public IPipePluggableStaticRenderer getRenderer() {
        return LensPluggableModel.INSTANCE;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.color = tag.func_74771_c("c");
        this.isFilter = tag.func_74767_n("f");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74774_a("c", (byte)this.color);
        tag.func_74757_a("f", this.isFilter);
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeByte(this.color + 1 & 0x1F | (this.isFilter ? 32 : 0));
    }

    @Override
    public void readData(ByteBuf data) {
        short flags = data.readUnsignedByte();
        this.color = (flags & 0x1F) - 1;
        this.isFilter = (flags & 0x20) > 0;
    }

    @Override
    public boolean requiresRenderUpdate(PipePluggable o) {
        LensPluggable other = (LensPluggable)o;
        return other.color != this.color || other.isFilter != this.isFilter;
    }

    private void color(TravelingItem item) {
        if (item.toCenter && item.input.func_176734_d() == this.side || !item.toCenter && item.output == this.side) {
            item.color = this.color == -1 ? null : EnumDyeColor.func_176766_a((int)this.color);
        }
    }

    public void eventHandler(PipeEventItem.ReachedEnd event) {
        if (!this.isFilter) {
            this.color(event.item);
        }
    }

    public void eventHandler(PipeEventItem.Entered event) {
        if (!this.isFilter) {
            this.color(event.item);
        }
    }

    public EnumDyeColor getColour() {
        return EnumDyeColor.func_176766_a((int)this.color);
    }
}

