/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pluggable;

import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.pluggable.IPipePluggableState;
import buildcraft.api.transport.pluggable.IPipePluggableStaticRenderer;
import buildcraft.api.transport.pluggable.IPipeRenderState;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.render.BakedModelHolder;
import buildcraft.core.lib.utils.ColorUtils;
import buildcraft.core.lib.utils.MatrixUtils;
import buildcraft.transport.pluggable.LensPluggable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class LensPluggableModel
extends BakedModelHolder
implements IPipePluggableStaticRenderer.Translucent {
    public static final LensPluggableModel INSTANCE = new LensPluggableModel();
    private static final ResourceLocation cutoutLoc = new ResourceLocation("buildcrafttransport:models/blocks/pluggables/lens_cutout.obj");
    private static final ResourceLocation translucentLoc = new ResourceLocation("buildcrafttransport:models/blocks/pluggables/lens_translucent.obj");
    private static final ResourceLocation cutoutSpriteLoc = new ResourceLocation("buildcrafttransport:pipes/lens");
    private static final ResourceLocation translucentSpriteLoc = new ResourceLocation("buildcrafttransport:pipes/overlay_lens");
    private static TextureAtlasSprite spriteCutout;
    private static TextureAtlasSprite spriteTranslucent;

    private LensPluggableModel() {
    }

    public IModel modelCutout() {
        return this.getModelOBJ(cutoutLoc);
    }

    public IModel modelTranslucent() {
        return this.getModelOBJ(translucentLoc);
    }

    @SubscribeEvent
    public void textureStitch(TextureStitchEvent.Pre event) {
        spriteCutout = null;
        spriteCutout = event.map.getTextureExtry(cutoutSpriteLoc.toString());
        if (spriteCutout == null) {
            spriteCutout = event.map.func_174942_a(cutoutSpriteLoc);
        }
        spriteTranslucent = null;
        spriteTranslucent = event.map.getTextureExtry(translucentSpriteLoc.toString());
        if (spriteTranslucent == null) {
            spriteCutout = event.map.func_174942_a(translucentSpriteLoc);
        }
    }

    @Override
    public List<BakedQuad> bakeCutout(IPipeRenderState render, IPipePluggableState pluggableState, IPipe pipe, PipePluggable pluggable, EnumFacing face) {
        LensPluggable lens = (LensPluggable)pluggable;
        EnumDyeColor colour = lens.getColour();
        int shade = ColorUtils.getLightHex(colour);
        ArrayList quads = Lists.newArrayList();
        List<BakedQuad> bakedQuads = this.renderLens(this.modelCutout(), spriteCutout, DefaultVertexFormats.field_176600_a);
        Matrix4f matrix = MatrixUtils.rotateTowardsFace(face);
        for (BakedQuad quad : bakedQuads) {
            quad = LensPluggableModel.transform(quad, matrix);
            quad = LensPluggableModel.replaceShade(quad, shade);
            quad = LensPluggableModel.applyDiffuse(quad);
            quads.add(quad);
        }
        return quads;
    }

    public List<BakedQuad> renderLens(IModel model, TextureAtlasSprite sprite, VertexFormat format) {
        ArrayList quads = Lists.newArrayList();
        IFlexibleBakedModel baked = model.bake((IModelState)ModelRotation.X0_Y0, format, LensPluggableModel.singleTextureFunction(sprite));
        for (BakedQuad quad : baked.func_177550_a()) {
            quad = LensPluggableModel.replaceShade(quad, 0xFFFFFF);
            quads.add(quad);
        }
        return quads;
    }

    @Override
    public List<BakedQuad> bakeTranslucent(IPipeRenderState render, IPipePluggableState pluggableState, IPipe pipe, PipePluggable pluggable, EnumFacing face) {
        return Collections.emptyList();
    }
}

