/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.recipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.JavaTools;
import buildcraft.api.facades.FacadeType;
import buildcraft.api.facades.IFacadeItem;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.recipes.IntegrationRecipeBC;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.ItemPipeWire;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class AdvancedFacadeRecipe
extends IntegrationRecipeBC {
    public AdvancedFacadeRecipe() {
        super(25000, 2);
    }

    @Override
    public List<ItemStack> generateExampleInput() {
        return ItemFacade.allFacades;
    }

    @Override
    public List<ItemStack> generateExampleOutput() {
        return ItemFacade.allFacades;
    }

    @Override
    public List<List<ItemStack>> generateExampleExpansions() {
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
        list.add(ItemFacade.allFacades);
        ArrayList<ItemStack> pipeWires = new ArrayList<ItemStack>();
        for (PipeWire wire : PipeWire.values()) {
            pipeWires.add(wire.getStack());
        }
        list.add(pipeWires);
        return list;
    }

    @Override
    public boolean isValidInput(ItemStack input) {
        return input.func_77973_b() instanceof ItemFacade;
    }

    @Override
    public boolean isValidExpansion(ItemStack input, ItemStack expansion) {
        return expansion.func_77973_b() instanceof ItemFacade && ((IFacadeItem)expansion.func_77973_b()).getFacadeType(expansion) == FacadeType.Basic || expansion.func_77973_b() == BuildCraftTransport.plugItem || expansion.func_77973_b() == BuildCraftTransport.pipeWire;
    }

    @Override
    public ItemStack craft(ItemStack input, List<ItemStack> expansions, boolean preview) {
        PipeWire wire = null;
        ItemStack facade = null;
        for (ItemStack stack : expansions) {
            if (wire == null && stack.func_77973_b() instanceof ItemPipeWire) {
                wire = PipeWire.fromOrdinal(stack.func_77952_i());
                if (preview) continue;
                --stack.field_77994_a;
                continue;
            }
            if (facade != null || !(stack.func_77973_b() instanceof ItemFacade) && stack.func_77973_b() != BuildCraftTransport.pipeWire) continue;
            facade = stack;
            if (preview) continue;
            --stack.field_77994_a;
        }
        if (wire != null && facade != null) {
            ItemFacade.FacadeState additionalState;
            ItemFacade.FacadeState[] states = ItemFacade.getFacadeStates(input);
            if (facade.func_77973_b() == BuildCraftTransport.plugItem) {
                additionalState = ItemFacade.FacadeState.createTransparent(wire);
            } else {
                additionalState = ItemFacade.getFacadeStates(facade)[0];
                additionalState = ItemFacade.FacadeState.create(additionalState.state, wire);
            }
            for (int i = 0; i < states.length; ++i) {
                if (states[i].wire != wire) continue;
                states[i] = additionalState;
                return ItemFacade.getFacade(states);
            }
            return ItemFacade.getFacade(JavaTools.concat(states, new ItemFacade.FacadeState[]{additionalState}));
        }
        return null;
    }
}

