/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.core.lib.render.BakedModelHolder;
import buildcraft.core.lib.utils.MatrixUtils;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.render.FacadePluggableRenderer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ISmartItemModel;

public class FacadeItemModel
extends BakedModelHolder
implements ISmartItemModel {
    private static Map<ItemFacade.FacadeState, FacadeItemModel> map = Maps.newHashMap();

    public FacadeItemModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format) {
        super(quads, particle, format, FacadeItemModel.getBlockTransforms());
    }

    public FacadeItemModel() {
    }

    @Override
    public boolean func_177556_c() {
        return true;
    }

    public FacadeItemModel handleItemState(ItemStack stack) {
        ItemFacade.FacadeState[] states = ItemFacade.getFacadeStates(stack);
        if (states.length == 0) {
            return this;
        }
        if (states.length == 1) {
            if (!map.containsKey(states[0])) {
                map.put(states[0], this.createFacadeItemModel(states[0]));
            }
            return map.get(states[0]);
        }
        int length = states.length;
        long millis = System.currentTimeMillis() / 2500L;
        int index = (int)(millis % (long)length);
        ItemFacade.FacadeState state = states[index];
        if (!map.containsKey(state)) {
            map.put(state, this.createFacadeItemModel(state));
        }
        return map.get(state);
    }

    private FacadeItemModel createFacadeItemModel(ItemFacade.FacadeState state) {
        ArrayList quads = Lists.newArrayList();
        IModel model = state.hollow ? FacadePluggableRenderer.INSTANCE.modelHollow() : FacadePluggableRenderer.INSTANCE.modelFilled();
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state.state);
        List bakedQuads = model.bake((IModelState)ModelRotation.X0_Y0, DefaultVertexFormats.field_176599_b, FacadeItemModel.singleTextureFunction(sprite)).func_177550_a();
        Matrix4f rotation = MatrixUtils.rotateTowardsFace(EnumFacing.EAST);
        Matrix4f translateToItem = new Matrix4f();
        translateToItem.setIdentity();
        translateToItem.setTranslation(new Vector3f(0.4f, 0.0f, 0.0f));
        Matrix4f totalMatrix = new Matrix4f();
        totalMatrix.setIdentity();
        totalMatrix.mul(rotation);
        totalMatrix.mul(translateToItem);
        for (BakedQuad quad : bakedQuads) {
            quad = FacadeItemModel.transform(quad, totalMatrix);
            quad = FacadeItemModel.replaceShade(quad, -1);
            quads.add(quad);
        }
        return new FacadeItemModel((ImmutableList<BakedQuad>)ImmutableList.copyOf((Collection)quads), sprite, DefaultVertexFormats.field_176599_b);
    }
}

