/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.pluggable.IFacadePluggable;
import buildcraft.api.transport.pluggable.IPipePluggableState;
import buildcraft.api.transport.pluggable.IPipePluggableStaticRenderer;
import buildcraft.api.transport.pluggable.IPipeRenderState;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.render.BakedModelHolder;
import buildcraft.core.lib.utils.MatrixUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;

public final class FacadePluggableRenderer
extends BakedModelHolder
implements IPipePluggableStaticRenderer {
    private static final ResourceLocation hollowLoc = new ResourceLocation("buildcrafttransport:models/blocks/pluggables/facade_hollow.obj");
    private static final ResourceLocation filledLoc = new ResourceLocation("buildcrafttransport:models/blocks/pluggables/facade_filled.obj");
    public static final FacadePluggableRenderer INSTANCE = new FacadePluggableRenderer();

    private FacadePluggableRenderer() {
    }

    public IModel modelHollow() {
        return this.getModelOBJ(hollowLoc);
    }

    public IModel modelFilled() {
        return this.getModelOBJ(filledLoc);
    }

    @Override
    public List<BakedQuad> bakeCutout(IPipeRenderState render, IPipePluggableState pluggableState, IPipe pipe, PipePluggable pluggable, EnumFacing face) {
        ArrayList quads = Lists.newArrayList();
        IFacadePluggable facade = (IFacadePluggable)((Object)pluggable);
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(facade.getCurrentState());
        IModel model = facade.isHollow() ? this.modelHollow() : this.modelFilled();
        if (model != null) {
            IFlexibleBakedModel baked = model.bake((IModelState)ModelRotation.X0_Y0, DefaultVertexFormats.field_176600_a, FacadePluggableRenderer.singleTextureFunction(sprite));
            Matrix4f matrix = MatrixUtils.rotateTowardsFace(face);
            for (BakedQuad quad : baked.func_177550_a()) {
                quad = FacadePluggableRenderer.transform(quad, matrix);
                quad = FacadePluggableRenderer.replaceShade(quad, -1);
                quad = FacadePluggableRenderer.applyDiffuse(quad);
                quads.add(quad);
            }
        }
        return quads;
    }
}

