/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.api.gates.IGateExpansion;
import buildcraft.core.lib.render.BakedModelHolder;
import buildcraft.core.lib.utils.MatrixUtils;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.ItemGate;
import buildcraft.transport.render.GatePluggableRenderer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.ISmartItemModel;

public class GateItemModel
extends BakedModelHolder
implements ISmartItemModel {
    private static Map<GatePluggableRenderer.GateState, GateItemModel> map = Maps.newHashMap();

    public GateItemModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format) {
        super(quads, particle, format, GateItemModel.getPluggableTransforms());
    }

    public GateItemModel() {
    }

    public GateItemModel handleItemState(ItemStack stack) {
        GatePluggableRenderer.GateState state = this.getState(stack);
        if (!map.containsKey(state)) {
            ArrayList quads = Lists.newArrayList();
            List<BakedQuad> bakedQuads = GatePluggableRenderer.INSTANCE.renderGate(state, DefaultVertexFormats.field_176600_a);
            Matrix4f rotation = MatrixUtils.rotateTowardsFace(EnumFacing.SOUTH);
            Matrix4f matScale = new Matrix4f();
            matScale.setIdentity();
            matScale.setScale(2.0f);
            matScale.setTranslation(new Vector3f(-0.5f, -0.5f, -0.5f));
            Matrix4f translateToItem = new Matrix4f();
            translateToItem.setIdentity();
            translateToItem.setTranslation(new Vector3f(0.0f, 0.0f, -0.4f));
            Matrix4f totalMatrix = new Matrix4f();
            totalMatrix.setIdentity();
            totalMatrix.mul(translateToItem);
            totalMatrix.mul(matScale);
            totalMatrix.mul(rotation);
            for (BakedQuad quad : bakedQuads) {
                quad = GateItemModel.transform(quad, totalMatrix);
                quad = GateItemModel.replaceShade(quad, -1);
                quads.add(quad);
            }
            map.put(state, new GateItemModel((ImmutableList<BakedQuad>)ImmutableList.copyOf((Collection)quads), null, DefaultVertexFormats.field_176600_a));
        }
        return map.get(state);
    }

    private GatePluggableRenderer.GateState getState(ItemStack stack) {
        GateDefinition.GateMaterial material = ItemGate.getMaterial(stack);
        GateDefinition.GateLogic logic = ItemGate.getLogic(stack);
        Set<IGateExpansion> expansions = ItemGate.getInstalledExpansions(stack);
        HashSet states = Sets.newHashSet();
        for (IGateExpansion exp : expansions) {
            states.add(exp.getRenderState());
        }
        return new GatePluggableRenderer.GateState(material, logic, false, states);
    }
}

