/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.pluggable.IPipePluggableDynamicRenderer;
import buildcraft.api.transport.pluggable.IPipePluggableState;
import buildcraft.api.transport.pluggable.IPipePluggableStaticRenderer;
import buildcraft.api.transport.pluggable.IPipeRenderState;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.render.BakedModelHolder;
import buildcraft.core.lib.utils.MatrixUtils;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.GatePluggable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class GatePluggableRenderer
extends BakedModelHolder
implements IPipePluggableStaticRenderer,
IPipePluggableDynamicRenderer {
    private static final ResourceLocation mainLoc = new ResourceLocation("buildcrafttransport:models/blocks/pluggables/gate_main.obj");
    private static final ResourceLocation materialLoc = new ResourceLocation("buildcrafttransport:models/blocks/pluggables/gate_material.obj");
    public static final GatePluggableRenderer INSTANCE = new GatePluggableRenderer();

    private GatePluggableRenderer() {
    }

    public IModel modelMain() {
        return this.getModelOBJ(mainLoc);
    }

    public IModel modelMaterial() {
        return this.getModelOBJ(materialLoc);
    }

    @Override
    public void renderDynamicPluggable(IPipe pipe, EnumFacing side, PipePluggable pipePluggable, double x, double y, double z) {
    }

    @Override
    public List<BakedQuad> bakeCutout(IPipeRenderState render, IPipePluggableState pluggableState, IPipe pipe, PipePluggable pluggable, EnumFacing face) {
        GatePluggable gate = (GatePluggable)pluggable;
        GateState state = new GateState(gate.getMaterial(), gate.getLogic(), gate.isLit, this.getExtensions(gate));
        ArrayList quads = Lists.newArrayList();
        List<BakedQuad> bakedQuads = this.renderGate(state, DefaultVertexFormats.field_176600_a);
        Matrix4f matrix = MatrixUtils.rotateTowardsFace(face);
        for (BakedQuad quad : bakedQuads) {
            quad = GatePluggableRenderer.transform(quad, matrix);
            quad = GatePluggableRenderer.replaceShade(quad, -1);
            quad = GatePluggableRenderer.applyDiffuse(quad);
            quads.add(quad);
        }
        return quads;
    }

    private Collection<IGateExpansion.IGateStaticRenderState> getExtensions(GatePluggable pluggable) {
        IGateExpansion[] expansions = pluggable.expansions;
        HashSet states = Sets.newHashSet();
        for (IGateExpansion exp : expansions) {
            states.add(exp.getRenderState());
        }
        return states;
    }

    public List<BakedQuad> renderGate(GateState gate, VertexFormat format) {
        TextureAtlasSprite logicSprite = gate.on ? gate.logic.getIconLit() : gate.logic.getIconDark();
        TextureAtlasSprite materialSprite = gate.material.getIconBlock();
        IModel main = this.modelMain();
        IModel material = this.modelMaterial();
        ArrayList quads = Lists.newArrayList();
        IFlexibleBakedModel baked = main.bake((IModelState)ModelRotation.X0_Y0, format, GatePluggableRenderer.singleTextureFunction(logicSprite));
        for (BakedQuad quad : baked.func_177550_a()) {
            quad = GatePluggableRenderer.replaceShade(quad, -1);
            quads.add(quad);
        }
        if (materialSprite != null) {
            baked = material.bake((IModelState)ModelRotation.X0_Y0, format, GatePluggableRenderer.singleTextureFunction(materialSprite));
            for (BakedQuad quad : baked.func_177550_a()) {
                quad = GatePluggableRenderer.replaceShade(quad, -1);
                quads.add(quad);
            }
        }
        for (IGateExpansion.IGateStaticRenderState ext : gate.extensionStates) {
            quads.addAll(ext.bake(format));
        }
        return quads;
    }

    public static class GateState {
        public final GateDefinition.GateMaterial material;
        public final GateDefinition.GateLogic logic;
        public final boolean on;
        public final ImmutableSet<IGateExpansion.IGateStaticRenderState> extensionStates;

        public GateState(GateDefinition.GateMaterial material, GateDefinition.GateLogic logic, boolean on, Collection<IGateExpansion.IGateStaticRenderState> extensionStates) {
            this.material = material;
            this.logic = logic;
            this.on = on;
            this.extensionStates = ImmutableSet.copyOf(extensionStates);
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.material).append((Object)this.logic).append(this.on).append(this.extensionStates).build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GateState other = (GateState)obj;
            return new EqualsBuilder().append((Object)this.material, (Object)other.material).append((Object)this.logic, (Object)other.logic).append(this.on, other.on).append(this.extensionStates, other.extensionStates).build();
        }
    }
}

