/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.api.transport.pluggable.IPipePluggableStaticRenderer;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.EntityResizableCuboid;
import buildcraft.core.lib.render.BuildCraftBakedModel;
import buildcraft.core.lib.render.RenderResizableCuboid;
import buildcraft.core.lib.utils.ColorUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipePluggableState;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.render.tile.PipeRendererWires;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.common.property.IExtendedBlockState;

public class PipeBlockModel
extends BuildCraftBakedModel
implements ISmartBlockModel {
    public PipeBlockModel() {
        super((ImmutableList<BakedQuad>)ImmutableList.of(), null, null);
    }

    protected PipeBlockModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format) {
        super(quads, particle, format);
    }

    public ISmartBlockModel handleBlockState(IBlockState state) {
        try {
            return PipeBlockModel.handle((IExtendedBlockState)state);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return PipeBlockModel.defaultModel();
        }
    }

    private static ISmartBlockModel defaultModel() {
        return new PipeBlockModel();
    }

    public static ISmartBlockModel handle(IExtendedBlockState state) {
        TileGenericPipe.CoreState core = BlockGenericPipe.PIPE_CORE_STATE.getUnlistedValue(state);
        PipeRenderState render = BlockGenericPipe.PIPE_RENDER_STATE.getUnlistedValue(state);
        PipePluggableState pluggable = BlockGenericPipe.PIPE_PLUGGABLE_STATE.getUnlistedValue(state);
        Pipe<?> pipe = BlockGenericPipe.PIPE_PIPE.getUnlistedValue(state);
        if (core == null || render == null || pluggable == null || pipe == null) {
            return PipeBlockModel.defaultModel();
        }
        ArrayList quads = Lists.newArrayList();
        EnumWorldBlockLayer layer = MinecraftForgeClient.getRenderLayer();
        if (layer == EnumWorldBlockLayer.CUTOUT) {
            PipeBlockModel.renderCutoutPass(render, pluggable, pipe, quads);
        } else if (layer == EnumWorldBlockLayer.TRANSLUCENT) {
            PipeBlockModel.renderTranslucentPass(render, pluggable, pipe, quads);
        }
        TextureAtlasSprite particle = pipe.getIconProvider().getIcon(pipe.getIconIndex(null));
        return new PipeBlockModel((ImmutableList<BakedQuad>)ImmutableList.copyOf((Collection)quads), particle, DefaultVertexFormats.field_176600_a);
    }

    private static void renderPipe(PipeRenderState render, List<BakedQuad> quads, Map<EnumFacing, TextureAtlasSprite> spriteMap, boolean smaller) {
        float min = 0.25f;
        float max = 0.75f;
        float minUV = min * 16.0f;
        float maxUV = max * 16.0f;
        TextureAtlasSprite sprite = spriteMap.get(null);
        float[] uvs = new float[]{sprite.func_94214_a((double)minUV), sprite.func_94214_a((double)maxUV), sprite.func_94207_b((double)minUV), sprite.func_94207_b((double)maxUV)};
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (render.pipeConnectionMatrix.isConnected(face) && render.pipeConnectionBanned.isConnected(face)) continue;
            Vec3 radius = Utils.vec3(0.25);
            if (smaller) {
                double smallerValue = Utils.getValue(radius, face.func_176740_k()) - (double)0.01f;
                radius = Utils.withValue(radius, face.func_176740_k(), smallerValue);
            }
            PipeBlockModel.bakeDoubleFace(quads, face, Utils.vec3f(0.5f), Utils.convertFloat(radius), uvs);
        }
        for (EnumFacing connect : EnumFacing.field_82609_l) {
            if (!render.pipeConnectionMatrix.isConnected(connect) || !render.pipeConnectionBanned.isConnected(connect)) continue;
            float extension = render.customConnections[connect.ordinal()];
            TextureAtlasSprite sprite2 = spriteMap.get(connect);
            Vec3 actualCenter = Utils.convert(connect, 0.375f + extension / 2.0f).func_178787_e(Utils.VEC_HALF);
            Vec3 smallerFace = null;
            smallerFace = connect.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? Utils.convert(connect, 0.25 - (double)extension) : Utils.convert(connect.func_176734_d(), 0.25 - (double)extension);
            Vec3 actualSize = Utils.VEC_HALF.func_178788_d(smallerFace);
            if (smaller) {
                Vec3 allSmaller = actualSize.func_178788_d(Utils.vec3(0.02));
                actualSize = allSmaller.func_178787_e(Utils.convert(Utils.convertPositive(connect), 0.02));
            }
            Vec3 pos = actualCenter.func_178788_d(Utils.multiply(actualSize, 0.5));
            EntityResizableCuboid cuboid = new EntityResizableCuboid(null);
            cuboid.texture = sprite2;
            cuboid.makeClient();
            double start = connect.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 12.0 : 0.0;
            cuboid.textureStartX = connect.func_176740_k() == EnumFacing.Axis.X ? start : 4.0;
            cuboid.textureStartY = connect.func_176740_k() == EnumFacing.Axis.Y ? start : 4.0;
            cuboid.textureStartZ = connect.func_176740_k() == EnumFacing.Axis.Z ? start : 4.0;
            cuboid.textureSizeX = connect.func_176740_k() == EnumFacing.Axis.X ? 4.0 : 8.0;
            cuboid.textureSizeY = connect.func_176740_k() == EnumFacing.Axis.Y ? 4.0 : 8.0;
            cuboid.textureSizeZ = connect.func_176740_k() == EnumFacing.Axis.Z ? 4.0 : 8.0;
            cuboid.textures[connect.ordinal()] = null;
            cuboid.textures[connect.func_176734_d().ordinal()] = null;
            cuboid.setSize(actualSize);
            cuboid.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            RenderResizableCuboid.INSTANCE.renderCubeStatic(quads, cuboid);
        }
    }

    private static void renderCutoutPass(PipeRenderState render, PipePluggableState pluggable, Pipe<?> pipe, List<BakedQuad> quads) {
        HashMap spriteMap = Maps.newHashMap();
        for (EnumFacing face : EnumFacing.values()) {
            spriteMap.put(face, pipe.getIconProvider().getIcon(render.textureMatrix.getTextureIndex(face)));
        }
        spriteMap.put(null, pipe.getIconProvider().getIcon(render.textureMatrix.getTextureIndex(null)));
        PipeBlockModel.renderPipe(render, quads, spriteMap, false);
        PipeRendererWires.renderPipeWires(quads, render);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            List<BakedQuad> list;
            IPipePluggableStaticRenderer plugRender;
            PipePluggable plug = pluggable.getPluggables()[face.ordinal()];
            if (plug == null || (plugRender = plug.getRenderer()) == null || (list = plugRender.bakeCutout(render, pluggable, pipe, plug, face)) == null) continue;
            quads.addAll(list);
        }
    }

    private static void renderTranslucentPass(PipeRenderState render, PipePluggableState pluggable, Pipe<?> pipe, List<BakedQuad> quads) {
        if (render.getGlassColor() >= 0 && render.getGlassColor() < 16) {
            HashMap spriteMap = Maps.newHashMap();
            TextureAtlasSprite sprite = PipeIconProvider.TYPE.PipeStainedOverlay.getIcon();
            for (EnumFacing face : EnumFacing.values()) {
                spriteMap.put(face, sprite);
            }
            spriteMap.put(null, sprite);
            int startIndex = quads.size();
            PipeBlockModel.renderPipe(render, quads, spriteMap, true);
            int colour = ColorUtils.getRGBColor(render.getGlassColor());
            for (int i = startIndex; i < quads.size(); ++i) {
                quads.get(i).func_178211_c();
                BakedQuad shapeQuad = quads.get(i);
                BakedQuad colouredQuad = new BakedQuad(shapeQuad.func_178209_a(), colour, shapeQuad.func_178210_d());
                quads.set(i, colouredQuad);
            }
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            IPipePluggableStaticRenderer.Translucent baker;
            List<BakedQuad> list;
            IPipePluggableStaticRenderer plugRender;
            PipePluggable plug = pluggable.getPluggables()[face.ordinal()];
            if (plug == null || !((plugRender = plug.getRenderer()) instanceof IPipePluggableStaticRenderer.Translucent) || (list = (baker = (IPipePluggableStaticRenderer.Translucent)plugRender).bakeTranslucent(render, pluggable, pipe, plug, face)) == null) continue;
            quads.addAll(list);
        }
    }
}

