/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.core.lib.EntityResizableCuboid;
import buildcraft.core.lib.render.BuildCraftBakedModel;
import buildcraft.core.lib.render.RenderResizableCuboid;
import buildcraft.core.lib.utils.ColorUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.PipeIconProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Vec3;

public class PipeItemModel
extends BuildCraftBakedModel {
    protected PipeItemModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle) {
        super(quads, particle, DefaultVertexFormats.field_176600_a, PipeItemModel.getBlockTransforms());
    }

    public static PipeItemModel create(ItemPipe item, int colorIndex) {
        TextureAtlasSprite sprite = item.getSprite();
        if (sprite == null) {
            sprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        Vec3 center = Utils.VEC_HALF;
        Vec3 radius = new Vec3(0.25, 0.5, 0.25);
        EntityResizableCuboid cuboid = new EntityResizableCuboid(null);
        cuboid.texture = sprite;
        cuboid.setTextureOffset(new Vec3(4.0, 0.0, 4.0));
        cuboid.setPosition(center.func_178788_d(radius));
        cuboid.setSize(Utils.multiply(radius, 2.0));
        ArrayList unprocessed = Lists.newArrayList();
        ArrayList quads = Lists.newArrayList();
        RenderResizableCuboid.INSTANCE.renderCubeStatic(unprocessed, cuboid);
        for (BakedQuad quad : unprocessed) {
            quad = PipeItemModel.replaceShade(quad, 0xFFFFFF);
            quad = PipeItemModel.replaceTint(quad, 0xFFFFFF);
            quads.add(quad);
        }
        unprocessed.clear();
        if (colorIndex != 0) {
            radius = new Vec3(0.249, 0.499, 0.249);
            cuboid = new EntityResizableCuboid(null);
            cuboid.setTextureOffset(new Vec3(4.0, 0.0, 4.0));
            cuboid.texture = PipeIconProvider.TYPE.PipeStainedOverlay.getIcon();
            cuboid.setPosition(center.func_178788_d(radius));
            cuboid.setSize(Utils.multiply(radius, 2.0));
            RenderResizableCuboid.INSTANCE.renderCubeStatic(unprocessed, cuboid);
            int quadColor = ColorUtils.getRGBColor(colorIndex - 1);
            for (BakedQuad quad : unprocessed) {
                quad = PipeItemModel.replaceShade(quad, 0xFFFFFF);
                quad = PipeItemModel.replaceTint(quad, quadColor);
                quads.add(quad);
            }
            unprocessed.clear();
        }
        return new PipeItemModel((ImmutableList<BakedQuad>)ImmutableList.copyOf((Collection)quads), sprite);
    }
}

