/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render.shader;

import buildcraft.core.lib.render.FluidRenderer;
import buildcraft.core.lib.render.RenderUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.render.shader.FluidPositionInfo;
import buildcraft.transport.render.shader.FluidPositionInfoBuilder;
import buildcraft.transport.render.shader.FluidShaderData;
import buildcraft.transport.render.shader.FluidShaderDataBuilder;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class FluidShaderRenderer {
    private static final EnumFacing[] allFaces = new EnumFacing[]{null, EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH};
    public final World world;
    private final Map<BlockPos, PipeTransportFluids> pipeMap = Maps.newHashMap();
    private final Multimap<BlockPos, FluidShaderData> shaderPosMap = HashMultimap.create();
    private final Map<BlockPos, PipeFluidHistory> pipeHistoryMap = Maps.newHashMap();
    private final List<FluidShaderData> shaderList = Lists.newArrayList();
    private final Set<BlockPos> dirtyPipes = Sets.newHashSet();

    public FluidShaderRenderer(World world) {
        this.world = world;
    }

    public void destroy() {
    }

    public void addFluidTransport(PipeTransportFluids trans) {
        BlockPos pos = trans.container.func_174877_v();
        this.pipeMap.put(pos, trans);
        this.dirtyPipes.add(pos);
    }

    public void removeFluidTransport(PipeTransportFluids trans) {
        BlockPos pos = trans.container.func_174877_v();
        this.pipeMap.remove(pos);
        this.dirtyPipes.add(pos);
    }

    public void clientTick() {
        long tick = this.world.func_82737_E();
        for (int i = 0; i < this.shaderList.size(); ++i) {
            FluidShaderData data = this.shaderList.get(i);
            if (data.isValid(tick)) continue;
            this.shaderList.remove(i);
            --i;
        }
        for (Map.Entry<BlockPos, PipeTransportFluids> pair : this.pipeMap.entrySet()) {
            this.computePipeShaderData(tick, pair);
        }
    }

    private void computePipeShaderData(long tick, Map.Entry<BlockPos, PipeTransportFluids> pair) {
        BlockPos pos = pair.getKey();
        PipeTransportFluids trans = pair.getValue();
        PipeFluidHistory hist = this.pipeHistoryMap.get(pos);
        if (hist == null) {
            hist = new PipeFluidHistory(trans, tick);
            this.pipeHistoryMap.put(pos, hist);
        }
        hist.tick(tick);
        FluidStack fluid = trans.fluidType;
        TextureAtlasSprite sprite = FluidRenderer.getFluidTexture(fluid, FluidRenderer.FluidType.STILL);
        for (EnumFacing face : EnumFacing.values()) {
            this.computeConnectionShaderData(tick, pos, trans, hist, sprite, face);
        }
    }

    private void computeConnectionShaderData(long tick, BlockPos pos, PipeTransportFluids trans, PipeFluidHistory hist, TextureAtlasSprite sprite, EnumFacing face) {
        PipeFluidPart part = hist.map.get(face);
        if (part.amount == 0 || part.lastAmount == 0) {
            return;
        }
        PipeFluidPart centre = hist.map.get(null);
        PipeFluidHistory otherHist = this.pipeHistoryMap.get(pos.func_177972_a(face));
        PipeFluidPart other = otherHist == null ? null : otherHist.map.get(face.func_176734_d());
        int ordinal = face.ordinal();
        Vec3 pipeEnd = Utils.convertMiddle((Vec3i)pos).func_178787_e(Utils.convert(face, (double)trans.container.renderState.customConnections[ordinal] + 0.5));
        if (centre.amount == 0 && other == null) {
            FluidShaderData toUse = null;
            for (FluidShaderData data : this.shaderList) {
                if (Utils.convertFloor(data.positionA.point) == pos && data.positionA.point.func_72438_d(pipeEnd) < 0.5) {
                    toUse = data;
                    break;
                }
                if (Utils.convertFloor(data.positionB.point) != pos || !(data.positionB.point.func_72438_d(pipeEnd) < 0.5)) continue;
                toUse = data;
                break;
            }
            if (toUse == null) {
                FluidShaderDataBuilder builder = new FluidShaderDataBuilder();
                builder.setSprite(sprite);
                builder.setExpires(tick + 110L);
                Vec3 axisBasedOffset = new Vec3(0.0, face.func_176740_k() == EnumFacing.Axis.Y ? 0.0 : 0.125, 0.0);
                FluidPositionInfoBuilder posBuilder = new FluidPositionInfoBuilder();
                posBuilder.setMin(pipeEnd.func_178788_d(Utils.convertExcept(face, 0.25)));
                posBuilder.setMax(pipeEnd.func_178787_e(Utils.convertExcept(face, 0.25)));
                posBuilder.setPoint(pipeEnd.func_178788_d(axisBasedOffset));
                posBuilder.setDirection(Utils.convert(face.func_176734_d()));
                posBuilder.setTextureIndex(0.2f);
                posBuilder.setMoves(false);
                builder.setPositionA(posBuilder.build());
                Vec3 pipeMiddle = Utils.convertMiddle((Vec3i)pos).func_178787_e(Utils.convert(face, 0.25));
                posBuilder.setMin(pipeMiddle.func_178788_d(Utils.convertExcept(face, 0.25)));
                posBuilder.setMax(pipeMiddle.func_178787_e(Utils.convertExcept(face, 0.25)));
                posBuilder.setPoint(Utils.convertMiddle((Vec3i)pos).func_178787_e(Utils.convert(face, 0.125)).func_178788_d(axisBasedOffset));
                posBuilder.setDirection(Utils.convert(face.func_176734_d()));
                posBuilder.setTextureIndex(0.8f);
                posBuilder.setMoves(true);
                posBuilder.setStartMoving(tick);
                posBuilder.setEndMoving(tick + 90L);
                builder.setPositionB(posBuilder.build());
                FluidShaderData fsd = new FluidShaderData(builder);
                this.shaderList.add(fsd);
            }
        } else if (other == null || centre.amount == 0) {
            // empty if block
        }
    }

    public void renderAll(float partialTicks) {
        long tick = Minecraft.func_71410_x().field_71441_e.func_82737_E();
        EntityPlayerSP clientPlayer = Minecraft.func_71410_x().field_71439_g;
        Vec3 pos = Utils.getInterpolatedVec((Entity)clientPlayer, partialTicks);
        GL11.glPushMatrix();
        RenderUtils.translate(Utils.multiply(pos, -1.0));
        GL11.glPointSize((float)8.0f);
        GL11.glLineWidth((float)4.0f);
        for (FluidShaderData fluidShaderData : this.shaderList) {
            this.renderShader(tick, partialTicks, fluidShaderData);
        }
        GL11.glPopMatrix();
    }

    private void renderShader(long tick, float partialTicks, FluidShaderData data) {
        FluidPositionInfo a = data.interpolateA(tick, partialTicks);
        FluidPositionInfo b = data.interpolateB(tick, partialTicks);
        for (FluidPositionInfo fpi : new FluidPositionInfo[]{a, b}) {
            GL11.glTexCoord2f((float)data.sprite.func_94214_a((double)(fpi.textureIndex * 16.0f)), (float)data.sprite.func_94206_g());
            GL11.glBegin((int)0);
            RenderUtils.vertex3f(fpi.min);
            RenderUtils.vertex3f(fpi.max);
            RenderUtils.vertex3f(fpi.point);
            GL11.glEnd();
            GL11.glBegin((int)1);
            RenderUtils.vertex3f(fpi.point);
            RenderUtils.vertex3f(fpi.point.func_178787_e(Utils.multiply(fpi.direction.func_72432_b(), 0.3)));
            GL11.glEnd();
        }
    }

    public static class PipeFluidPart {
        int amount;
        int lastAmount;
        long tick;
        long lastTick;
    }

    public static class PipeFluidHistory {
        final Map<EnumFacing, PipeFluidPart> map = Maps.newHashMap();
        final PipeTransportFluids trans;

        public PipeFluidHistory(PipeTransportFluids fluids, long thisTick) {
            this.trans = fluids;
            for (EnumFacing face : allFaces) {
                int ordinal = face == null ? 6 : face.ordinal();
                PipeFluidPart part = new PipeFluidPart();
                part.lastTick = part.tick = thisTick;
                part.lastAmount = part.amount = fluids.renderCache.amount[ordinal];
                this.map.put(face, part);
            }
        }

        public void tick(long thisTick) {
            for (EnumFacing face : allFaces) {
                int ordinal = face == null ? 6 : face.ordinal();
                PipeFluidPart part = this.map.get(face);
                int newAmount = this.trans.renderCache.amount[ordinal];
                if (newAmount == part.amount) continue;
                part.lastTick = part.tick;
                part.tick = thisTick;
                part.lastAmount = part.amount;
                part.amount = newAmount;
            }
        }
    }
}

