/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render.tile;

import buildcraft.api.core.BCLog;
import buildcraft.core.lib.EntityResizableCuboid;
import buildcraft.core.lib.render.FluidRenderer;
import buildcraft.core.lib.render.RenderResizableCuboid;
import buildcraft.core.lib.render.RenderUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.utils.FluidRenderData;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class PipeRendererFluids {
    public static final int DISPLAY_STAGES = 100;
    public static final double FLOW_MULTIPLIER = 0.016;
    private static Map<Integer, DisplayFluidList> fluidLists = Maps.newHashMap();

    static void renderFluidPipe(Pipe<PipeTransportFluids> pipe, double x, double y, double z) {
        PipeTransportFluids trans = (PipeTransportFluids)pipe.transport;
        boolean needsRender = false;
        FluidRenderData renderData = trans.renderCache;
        for (int i = 0; i < 7; ++i) {
            if (renderData.amount[i] <= 0) continue;
            needsRender = true;
            break;
        }
        if (!needsRender) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GlStateManager.func_179089_o();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        DisplayFluidList dfl = PipeRendererFluids.getDisplayFluidList(renderData.fluidID);
        if (dfl != null) {
            int stage;
            float amount;
            long ms = System.currentTimeMillis();
            long diff = ms - trans.clientLastDisplayTime;
            if (trans.clientLastDisplayTime == 0L || diff <= 0L) {
                diff = 1L;
            }
            trans.clientLastDisplayTime = ms;
            TextureAtlasSprite sprite = FluidRenderer.getFluidTexture(FluidRegistry.getFluid((int)renderData.fluidID), FluidRenderer.FluidType.STILL);
            RenderUtils.setGLColorFromInt(renderData.color);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            boolean above = renderData.amount[EnumFacing.UP.ordinal()] > 0;
            boolean sides = false;
            for (EnumFacing connection : EnumFacing.field_82609_l) {
                float amount2 = (float)renderData.amount[connection.ordinal()] / (float)trans.getCapacity();
                if (!(amount2 > 0.0f)) continue;
                int stage2 = (int)(amount2 * 99.0f);
                if (stage2 >= 100) {
                    stage2 = 99;
                }
                sides = true;
                GL11.glPushMatrix();
                GL11.glCallList((int)dfl.sideFaces[stage2][connection.ordinal()]);
                GL11.glPopMatrix();
            }
            if (above && (amount = (float)renderData.amount[6] / (float)trans.getCapacity()) > 0.0f) {
                stage = (int)(amount * 99.0f);
                if (stage >= 100) {
                    stage = 99;
                }
                GL11.glPushMatrix();
                GL11.glCallList((int)dfl.centerFacesVertical[stage]);
                GL11.glPopMatrix();
            }
            if (sides && (amount = (float)renderData.amount[6] / (float)trans.getCapacity()) > 0.0f) {
                stage = (int)(amount * 99.0f);
                if (stage >= 100) {
                    stage = 99;
                }
                GL11.glPushMatrix();
                GL11.glCallList((int)dfl.centerFaces[stage]);
                GL11.glPopMatrix();
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179129_p();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private static void renderConnection(TextureAtlasSprite sprite, float amount, double sideFlow, EnumFacing connect) {
        boolean vert = connect.func_176740_k() == EnumFacing.Axis.Y;
        double diff = (double)amount * 0.5;
        double width = vert ? diff : 0.5;
        double height = vert ? 0.5 : diff;
        EnumFacing positive = Utils.convertPositive(connect);
        Vec3 size = new Vec3(width, 0.5, width).func_178788_d(Utils.convert(positive, 0.25));
        Vec3 position = new Vec3(0.5, 0.5, 0.5).func_178787_e(Utils.convert(connect, 0.375));
        position = position.func_178788_d(Utils.multiply(size, 0.5));
        GL11.glPushMatrix();
        GL11.glTranslated((double)position.field_72450_a, (double)position.field_72448_b, (double)position.field_72449_c);
        GL11.glTranslated((double)(size.field_72450_a / 2.0), (double)(size.field_72448_b / 2.0), (double)(size.field_72449_c / 2.0));
        GL11.glScalef((float)0.99f, (float)0.99f, (float)0.99f);
        GL11.glTranslated((double)(-size.field_72450_a / 2.0), (double)(-size.field_72448_b / 2.0), (double)(-size.field_72449_c / 2.0));
        EntityResizableCuboid cuboid = new EntityResizableCuboid(null);
        cuboid.xSize = size.field_72450_a;
        cuboid.ySize = height;
        cuboid.zSize = size.field_72449_c;
        cuboid.texture = sprite;
        double flow = sideFlow;
        cuboid.textureOffsetX = connect.func_176740_k() == EnumFacing.Axis.X ? flow : 0.0;
        cuboid.textureOffsetY = connect.func_176740_k() == EnumFacing.Axis.Y ? flow : 0.0;
        cuboid.textureOffsetZ = connect.func_176740_k() == EnumFacing.Axis.Z ? flow : 0.0;
        RenderResizableCuboid.INSTANCE.renderCube(cuboid);
        GL11.glPopMatrix();
    }

    private static DisplayFluidList getDisplayFluidList(int fluidID) {
        if (fluidLists.containsKey(fluidID)) {
            return fluidLists.get(fluidID);
        }
        long start = System.nanoTime();
        Fluid fluid = FluidRegistry.getFluid((int)fluidID);
        if (fluid == null) {
            fluidLists.put(fluidID, null);
            return null;
        }
        TextureAtlasSprite sprite = FluidRenderer.getFluidTexture(fluid, FluidRenderer.FluidType.STILL);
        int[] center = new int[100];
        for (int i = 0; i < 100; ++i) {
            center[i] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)center[i], (int)4864);
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
            GL11.glScalef((float)0.99f, (float)0.99f, (float)0.99f);
            GL11.glTranslated((double)-0.25, (double)-0.25, (double)-0.25);
            EntityResizableCuboid cuboid = new EntityResizableCuboid(null);
            cuboid.xSize = 0.5;
            cuboid.ySize = 0.5 * (double)((float)(i + 1) / 100.0f);
            cuboid.zSize = 0.5;
            cuboid.texture = sprite;
            RenderResizableCuboid.INSTANCE.renderCube(cuboid);
            GL11.glPopMatrix();
            GL11.glEndList();
        }
        int[] vertical = new int[100];
        for (int i = 0; i < 100; ++i) {
            vertical[i] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)vertical[i], (int)4864);
            double width = (float)(i + 1) / 100.0f;
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
            GL11.glScalef((float)0.99f, (float)0.99f, (float)0.99f);
            GL11.glTranslated((double)(-0.25 * width), (double)-0.25, (double)(-0.25 * width));
            EntityResizableCuboid cuboid = new EntityResizableCuboid(null);
            cuboid.xSize = 0.5 * width;
            cuboid.ySize = 0.5;
            cuboid.zSize = 0.5 * width;
            cuboid.texture = sprite;
            RenderResizableCuboid.INSTANCE.renderCube(cuboid);
            GL11.glPopMatrix();
            GL11.glEndList();
        }
        int[][] connections = new int[100][];
        for (int i = 0; i < 100; ++i) {
            connections[i] = new int[6];
            for (EnumFacing connect : EnumFacing.values()) {
                int connectOrdinal = connect.ordinal();
                boolean vert = connect.func_176740_k() == EnumFacing.Axis.Y;
                double diff = (double)((float)(i + 1) / 100.0f) * 0.5;
                double width = vert ? diff : 0.5;
                double height = vert ? 0.5 : diff;
                EnumFacing pos = connect.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? connect : connect.func_176734_d();
                Vec3 size = new Vec3(width, 0.5, width).func_178788_d(Utils.convert(pos, 0.25));
                Vec3 position = new Vec3(0.5, 0.5, 0.5).func_178787_e(Utils.convert(connect, 0.375));
                position = position.func_178788_d(Utils.multiply(size, 0.5));
                connections[i][connectOrdinal] = GLAllocation.func_74526_a((int)1);
                GL11.glNewList((int)connections[i][connectOrdinal], (int)4864);
                GL11.glTranslated((double)position.field_72450_a, (double)position.field_72448_b, (double)position.field_72449_c);
                GL11.glTranslated((double)(size.field_72450_a / 2.0), (double)(size.field_72448_b / 2.0), (double)(size.field_72449_c / 2.0));
                GL11.glScalef((float)0.99f, (float)0.99f, (float)0.99f);
                GL11.glTranslated((double)(-size.field_72450_a / 2.0), (double)(-size.field_72448_b / 2.0), (double)(-size.field_72449_c / 2.0));
                EntityResizableCuboid cuboid = new EntityResizableCuboid(null);
                cuboid.xSize = size.field_72450_a;
                cuboid.ySize = height;
                cuboid.zSize = size.field_72449_c;
                cuboid.texture = sprite;
                RenderResizableCuboid.INSTANCE.renderCube(cuboid);
                GL11.glEndList();
            }
        }
        DisplayFluidList dfl = new DisplayFluidList(center, vertical, connections);
        fluidLists.put(fluidID, dfl);
        long diff = System.nanoTime() - start;
        BCLog.logger.info("DisplayFluidList generation took " + diff / 1000000L + "ms, " + diff % 1000000L + "ns for " + new FluidStack(fluid, 1).getLocalizedName() + "#" + fluidID);
        return dfl;
    }

    static class DisplayFluidList {
        final int[] centerFaces;
        final int[] centerFacesVertical;
        final int[][] sideFaces;

        DisplayFluidList(int[] centerFaces, int[] centerFacesVertical, int[][] sideFaces) {
            this.centerFaces = centerFaces;
            this.centerFacesVertical = centerFacesVertical;
            this.sideFaces = sideFaces;
        }
    }
}

