/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render.tile;

import buildcraft.BuildCraftTransport;
import buildcraft.api.items.IItemCustomPipeRender;
import buildcraft.core.lib.EntityResizableCuboid;
import buildcraft.core.lib.render.RenderResizableCuboid;
import buildcraft.core.lib.render.RenderUtils;
import buildcraft.core.lib.utils.ColorUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderEntityItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class PipeRendererItems {
    private static final int MAX_ITEMS_TO_RENDER = 10;
    private static final EntityItem dummyEntityItem = new EntityItem(null);
    private static final RenderEntityItem customRenderItem = new RenderEntityItem(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_175599_af()){

        public boolean shouldBob() {
            return false;
        }

        public boolean shouldSpreadItems() {
            return false;
        }
    };

    static void renderItemPipe(Pipe<PipeTransportItems> pipe, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        float light = pipe.container.func_145831_w().func_175724_o(pipe.container.func_174877_v());
        int count = 0;
        Iterator<TravelingItem> iterator = ((PipeTransportItems)pipe.transport).items.iterator();
        while (iterator.hasNext()) {
            TravelingItem item = iterator.next();
            if (count >= 10) break;
            if (item == null || item.pos == null) continue;
            EnumFacing face = item.toCenter ? item.input : item.output;
            Vec3 motion = Utils.convert(face, item.getSpeed() * f);
            PipeRendererItems.doRenderItem(item, x + item.pos.field_72450_a - (double)pipe.container.func_174877_v().func_177958_n() + motion.field_72450_a, y + item.pos.field_72448_b - (double)pipe.container.func_174877_v().func_177956_o() + motion.field_72448_b, z + item.pos.field_72449_c - (double)pipe.container.func_174877_v().func_177952_p() + motion.field_72449_c, light, item.color);
            ++count;
        }
        GL11.glPopMatrix();
    }

    public static void doRenderItem(TravelingItem travellingItem, double x, double y, double z, float light, EnumDyeColor color) {
        if (travellingItem == null || travellingItem.getItemStack() == null) {
            return;
        }
        float renderScale = 0.7f;
        ItemStack itemstack = travellingItem.getItemStack();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y + 0.05f), (float)((float)z));
        GL11.glPushMatrix();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!travellingItem.hasDisplayList) {
            travellingItem.displayList = GLAllocation.func_74526_a((int)1);
            travellingItem.hasDisplayList = true;
            GL11.glNewList((int)travellingItem.displayList, (int)4864);
            if (itemstack.func_77973_b() instanceof IItemCustomPipeRender) {
                IItemCustomPipeRender render = (IItemCustomPipeRender)itemstack.func_77973_b();
                float itemScale = render.getPipeRenderScale(itemstack);
                GL11.glScalef((float)(renderScale * itemScale), (float)(renderScale * itemScale), (float)(renderScale * itemScale));
                itemScale = 1.0f / itemScale;
                if (!render.renderItemInPipe(itemstack, x, y, z)) {
                    dummyEntityItem.func_92058_a(itemstack);
                    customRenderItem.func_76986_a(dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                }
                GL11.glScalef((float)itemScale, (float)itemScale, (float)itemScale);
            } else {
                GL11.glScalef((float)renderScale, (float)renderScale, (float)renderScale);
                dummyEntityItem.func_92058_a(itemstack);
                customRenderItem.func_76986_a(dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            }
            GL11.glEndList();
        }
        GL11.glCallList((int)travellingItem.displayList);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        if (color != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            EntityResizableCuboid erc = new EntityResizableCuboid(null);
            erc.texture = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.ItemBox.ordinal());
            erc.xSize = 1.0;
            erc.ySize = 1.0;
            erc.zSize = 1.0;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.2f, (float)0.0f);
            GL11.glScalef((float)(renderScale /= 2.0f), (float)renderScale, (float)renderScale);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            RenderUtils.setGLColorFromInt(ColorUtils.getLightHex(color));
            RenderResizableCuboid.INSTANCE.renderCube(erc);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }
}

