/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render.tile;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.BCLog;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.render.tile.PipeRendererFluids;
import buildcraft.transport.render.tile.PipeRendererItems;
import buildcraft.transport.render.tile.PipeRendererPower;
import com.google.common.base.Throwables;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;

public class PipeRendererTESR
extends TileEntitySpecialRenderer<TileGenericPipe> {
    public void renderTileEntityAt(TileGenericPipe pipe, double x, double y, double z, float f, int argumentthatisalwaysminusone) {
        if (BuildCraftCore.render == BuildCraftCore.RenderMode.NoDynamic) {
            return;
        }
        if (pipe.pipe == null) {
            return;
        }
        if (pipe.pipe.container == null) {
            return;
        }
        this.renderPluggables(pipe, x, y, z);
        IPipeTile.PipeType pipeType = pipe.getPipeType();
        try {
            if (pipeType == IPipeTile.PipeType.ITEM) {
                PipeRendererItems.renderItemPipe(pipe.pipe, x, y, z, f);
            } else if (pipeType == IPipeTile.PipeType.FLUID) {
                PipeRendererFluids.renderFluidPipe(pipe.pipe, x, y, z);
            } else if (pipeType == IPipeTile.PipeType.POWER) {
                PipeRendererPower.renderPowerPipe(pipe.pipe, x, y, z);
            }
        }
        catch (Throwable t) {
            BCLog.logger.warn("A crash! Oh no!", t);
            throw Throwables.propagate((Throwable)t);
        }
    }

    private void renderPluggables(TileGenericPipe pipe, double x, double y, double z) {
        TileEntityRendererDispatcher.field_147556_a.field_147553_e.func_110577_a(TextureMap.field_110575_b);
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            PipePluggable pluggable = pipe.getPipePluggable(direction);
            if (pluggable == null || pluggable.getDynamicRenderer() == null) continue;
            pluggable.getDynamicRenderer().renderDynamicPluggable(pipe.getPipe(), direction, pluggable, x, y, z);
        }
    }

    public boolean isOpenOrientation(PipeRenderState state, EnumFacing direction) {
        int connections = 0;
        EnumFacing targetOrientation = null;
        for (EnumFacing o : EnumFacing.field_82609_l) {
            if (!state.pipeConnectionMatrix.isConnected(o) || ++connections != 1) continue;
            targetOrientation = o;
        }
        if (connections > 1 || connections == 0) {
            return false;
        }
        return targetOrientation.func_176734_d() == direction;
    }
}

