/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render.tile;

import buildcraft.BuildCraftTransport;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.lib.render.BuildCraftBakedModel;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.PipeRenderState;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.List;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;

public class PipeRendererWires {
    private static EnumMap<PipeWire, Vec3> wirePosMap = Maps.newEnumMap(PipeWire.class);
    private static EnumMap<PipeWire, EnumFacing.AxisDirection[]> wireDirectionMap = Maps.newEnumMap(PipeWire.class);
    private static final double WIRE_WIDTH = 0.05;
    private static final double WIRE_OFFSET = 0.001;

    private static Vec3 getOffset(PipeWire wire) {
        double min = 0.2;
        double max = 0.75;
        int multiple = wire.ordinal() + 1;
        double offset = 0.001 * (double)multiple;
        double inset = -offset;
        EnumFacing.AxisDirection[] axis = wireDirectionMap.get((Object)wire);
        boolean[] axisPos = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            axisPos[i] = axis[i] == EnumFacing.AxisDirection.POSITIVE;
        }
        Vec3 base = new Vec3(axisPos[0] ? max : min, axisPos[1] ? max : min, axisPos[2] ? max : min);
        return base.func_72441_c(axisPos[0] ? inset : offset, axisPos[1] ? inset : offset, axisPos[2] ? inset : offset);
    }

    public static void renderPipeWires(List<BakedQuad> quads, PipeRenderState renderState) {
        for (PipeWire wire : PipeWire.values()) {
            if (!renderState.wireMatrix.hasWire(wire)) continue;
            PipeRendererWires.renderPipeWire(quads, renderState, wire);
        }
    }

    private static void renderPipeWire(List<BakedQuad> quads, PipeRenderState renderState, PipeWire wire) {
        Vec3 pos = wirePosMap.get((Object)wire);
        TextureAtlasSprite sprite = BuildCraftTransport.instance.wireIconProvider.getIcon(wire, renderState.wireMatrix.isWireLit(wire));
        Vec3 center = pos;
        Vec3 centerSize = new Vec3(0.05, 0.05, 0.05);
        EnumFacing.AxisDirection[] directions = wireDirectionMap.get((Object)wire);
        int numFaces = 0;
        for (EnumFacing face : EnumFacing.values()) {
            boolean positive = face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
            EnumFacing.Axis axis = face.func_176740_k();
            EnumFacing.AxisDirection wireCenter = directions[axis.ordinal()];
            if (renderState.wireMatrix.isWireConnected(wire, face)) {
                if (wireCenter == face.func_176743_c()) {
                    ++numFaces;
                }
                ++numFaces;
                Vec3 start = pos;
                Vec3 end = pos.func_178787_e(centerSize);
                if (positive) {
                    start = Utils.withValue(start, axis, Utils.getValue(start, axis) + 0.05);
                    end = Utils.withValue(end, axis, 1.0);
                } else {
                    start = Utils.withValue(start, axis, 0.0);
                    end = Utils.withValue(end, axis, Utils.getValue(end, axis) - 0.05);
                }
                PipeRendererWires.renderCuboid(quads, start, end.func_178788_d(start), sprite);
                continue;
            }
            boolean anyOther = false;
            for (Vec3 face2 : EnumFacing.values()) {
                if (face2.func_176734_d() == face) continue;
                anyOther |= renderState.wireMatrix.isWireConnected(wire, (EnumFacing)face2);
            }
            if (anyOther) continue;
            Vec3 start = pos;
            Vec3 end = pos.func_178787_e(centerSize);
            if (positive) {
                start = Utils.withValue(start, axis, Utils.getValue(start, axis) + 0.05);
                end = Utils.withValue(end, axis, 0.75);
            } else {
                start = Utils.withValue(start, axis, 0.25);
                end = Utils.withValue(end, axis, Utils.getValue(end, axis) - 0.05);
            }
            Vec3 size = end.func_178788_d(start);
            if (!(size.func_72433_c() > 0.1)) continue;
            PipeRendererWires.renderCuboid(quads, start, size, sprite);
        }
        if (numFaces != 1) {
            PipeRendererWires.renderCuboid(quads, center, centerSize, sprite);
        }
    }

    private static void renderCuboid(List<BakedQuad> quads, Vec3 min, Vec3 size, TextureAtlasSprite sprite) {
        Vec3 radius = Utils.multiply(size, 0.5);
        Vector3f radiusF = Utils.convertFloat(radius);
        Vector3f center = Utils.convertFloat(min.func_178787_e(radius));
        for (EnumFacing face : EnumFacing.values()) {
            float[] uvs = new float[4];
            int neg = (face.ordinal() - 2) % 6;
            if (neg < 0) {
                neg += 6;
            }
            EnumFacing uFace = EnumFacing.field_82609_l[neg];
            EnumFacing vFace = EnumFacing.field_82609_l[(face.ordinal() + 2) % 6];
            if (face.func_176740_k() == EnumFacing.Axis.Z) {
                EnumFacing holder = uFace;
                uFace = vFace;
                vFace = holder;
            }
            uvs[0] = sprite.func_94209_e();
            uvs[1] = sprite.func_94214_a(Utils.getValue(size, uFace.func_176740_k()) * 16.0);
            uvs[2] = sprite.func_94206_g();
            uvs[3] = sprite.func_94207_b(Utils.getValue(size, vFace.func_176740_k()) * 16.0);
            BuildCraftBakedModel.bakeDoubleFace(quads, face, center, radiusF, uvs);
        }
    }

    static {
        EnumFacing.AxisDirection neg = EnumFacing.AxisDirection.NEGATIVE;
        EnumFacing.AxisDirection pos = EnumFacing.AxisDirection.POSITIVE;
        wireDirectionMap.put(PipeWire.RED, new EnumFacing.AxisDirection[]{neg, pos, neg});
        wireDirectionMap.put(PipeWire.BLUE, new EnumFacing.AxisDirection[]{pos, pos, pos});
        wireDirectionMap.put(PipeWire.GREEN, new EnumFacing.AxisDirection[]{pos, neg, neg});
        wireDirectionMap.put(PipeWire.YELLOW, new EnumFacing.AxisDirection[]{neg, neg, pos});
        wirePosMap.put(PipeWire.RED, PipeRendererWires.getOffset(PipeWire.RED));
        wirePosMap.put(PipeWire.BLUE, PipeRendererWires.getOffset(PipeWire.BLUE));
        wirePosMap.put(PipeWire.GREEN, PipeRendererWires.getOffset(PipeWire.GREEN));
        wirePosMap.put(PipeWire.YELLOW, PipeRendererWires.getOffset(PipeWire.YELLOW));
    }
}

