/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.schematics;

import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.Schematic;
import buildcraft.api.blueprints.SchematicTile;
import buildcraft.api.core.BCLog;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementManager;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Gate;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.schematics.BptPipeExtension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;

public class SchematicPipe
extends SchematicTile {
    private BuildingPermission permission = BuildingPermission.ALL;

    @Override
    public boolean isAlreadyBuilt(IBuilderContext context, BlockPos pos) {
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)context.world(), pos);
        if (BlockGenericPipe.isValid(pipe)) {
            if (this.tileNBT.func_150297_b("pipeId", 3)) {
                return pipe.item == Item.func_150899_d((int)this.tileNBT.func_74762_e("pipeId"));
            }
            return pipe.item == Item.func_111206_d((String)this.tileNBT.func_74779_i("pipeId"));
        }
        return false;
    }

    @Override
    public void rotateLeft(IBuilderContext context) {
        TileGenericPipe.SideProperties props = new TileGenericPipe.SideProperties();
        props.readFromNBT(this.tileNBT);
        props.rotateLeft();
        props.writeToNBT(this.tileNBT);
        Item pipeItem = this.tileNBT.func_150297_b("pipeId", 3) ? Item.func_150899_d((int)this.tileNBT.func_74762_e("pipeId")) : Item.func_111206_d((String)this.tileNBT.func_74779_i("pipeId"));
        if (BptPipeExtension.contains(pipeItem)) {
            BptPipeExtension.get(pipeItem).rotateLeft(this, context);
        }
        if (this.tileNBT.func_74764_b("Gate")) {
            NBTTagCompound gateNBT = this.tileNBT.func_74775_l("Gate");
            this.rotateGateLeft(gateNBT);
        } else {
            int i;
            NBTTagCompound[] gatesNBT = new NBTTagCompound[6];
            for (i = 0; i < 6; ++i) {
                if (!this.tileNBT.func_74764_b("Gate[" + i + "]")) continue;
                gatesNBT[i] = this.tileNBT.func_74775_l("Gate[" + i + "]");
            }
            for (i = 0; i < 6; ++i) {
                EnumFacing face = EnumFacing.field_82609_l[i];
                if (face.func_176740_k() != EnumFacing.Axis.Y) {
                    face = face.func_176746_e();
                }
                int newI = face.ordinal();
                if (gatesNBT[i] != null) {
                    this.rotateGateLeft(gatesNBT[i]);
                    this.tileNBT.func_74782_a("Gate[" + newI + "]", (NBTBase)gatesNBT[i]);
                    continue;
                }
                this.tileNBT.func_82580_o("Gate[" + newI + "]");
            }
        }
    }

    private void rotateGateLeft(NBTTagCompound gateNBT) {
        for (int i = 0; i < Gate.MAX_STATEMENTS; ++i) {
            if (gateNBT.func_74764_b("trigger[" + i + "]")) {
                IStatement t = StatementManager.statements.get(gateNBT.func_74779_i("trigger[" + i + "]"));
                t = t.rotateLeft();
                gateNBT.func_74778_a("trigger[" + i + "]", t.getUniqueTag());
            }
            if (gateNBT.func_74764_b("action[" + i + "]")) {
                IStatement a = StatementManager.statements.get(gateNBT.func_74779_i("action[" + i + "]"));
                a = a.rotateLeft();
                gateNBT.func_74778_a("action[" + i + "]", a.getUniqueTag());
            }
            for (int j = 0; j < Gate.MAX_PARAMETERS; ++j) {
                IStatementParameter parameter;
                NBTTagCompound cpt;
                if (gateNBT.func_74764_b("triggerParameters[" + i + "][" + j + "]")) {
                    cpt = gateNBT.func_74775_l("triggerParameters[" + i + "][" + j + "]");
                    parameter = StatementManager.createParameter(cpt.func_74779_i("kind"));
                    parameter.readFromNBT(cpt);
                    parameter = parameter.rotateLeft();
                    parameter.writeToNBT(cpt);
                    gateNBT.func_74782_a("triggerParameters[" + i + "][" + j + "]", (NBTBase)cpt);
                }
                if (!gateNBT.func_74764_b("actionParameters[" + i + "][" + j + "]")) continue;
                cpt = gateNBT.func_74775_l("actionParameters[" + i + "][" + j + "]");
                parameter = StatementManager.createParameter(cpt.func_74779_i("kind"));
                parameter.readFromNBT(cpt);
                parameter = parameter.rotateLeft();
                parameter.writeToNBT(cpt);
                gateNBT.func_74782_a("actionParameters[" + i + "][" + j + "]", (NBTBase)cpt);
            }
        }
        if (gateNBT.func_74764_b("direction")) {
            EnumFacing face = EnumFacing.field_82609_l[gateNBT.func_74762_e("direction")];
            if (face.func_176740_k() != EnumFacing.Axis.Y) {
                face = face.func_176746_e();
            }
            gateNBT.func_74768_a("direction", face.ordinal());
        }
    }

    @Override
    public void placeInWorld(IBuilderContext context, BlockPos pos, List<ItemStack> stacks) {
        this.tileNBT.func_74768_a("x", pos.func_177958_n());
        this.tileNBT.func_74768_a("y", pos.func_177956_o());
        this.tileNBT.func_74768_a("z", pos.func_177952_p());
        context.world().func_180501_a(pos, this.state, 3);
        TileEntity tile = context.world().func_175625_s(pos);
        tile.func_145834_a(context.world());
        tile.func_145839_a(this.tileNBT);
    }

    @Override
    public void initializeFromObjectAt(IBuilderContext context, BlockPos pos) {
        TileEntity tile = context.world().func_175625_s(pos);
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)context.world(), pos);
        if (BlockGenericPipe.isValid(pipe)) {
            tile.func_145841_b(this.tileNBT);
            this.tileNBT.func_82580_o("travelingEntities");
            for (EnumFacing direction : EnumFacing.values()) {
                this.tileNBT.func_82580_o("tank[" + direction.ordinal() + "]");
                this.tileNBT.func_82580_o("transferState[" + direction.ordinal() + "]");
            }
            for (int i = 0; i < 6; ++i) {
                this.tileNBT.func_82580_o("powerQuery[" + i + "]");
                this.tileNBT.func_82580_o("nextPowerQuery[" + i + "]");
                this.tileNBT.func_82580_o("internalPower[" + i + "]");
                this.tileNBT.func_82580_o("internalNextPower[" + i + "]");
            }
        }
    }

    @Override
    public void storeRequirements(IBuilderContext context, BlockPos pos) {
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)context.world(), pos);
        if (BlockGenericPipe.isValid(pipe)) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(pipe.computeItemDrop());
            items.add(new ItemStack(pipe.item, 1, pipe.container.getItemMetadata()));
            this.storedRequirements = items.toArray(new ItemStack[items.size()]);
            BCLog.logger.info("Stored the requirements" + Arrays.toString(this.storedRequirements).replace(",", ",\n") + "@" + pos);
        } else {
            BCLog.logger.info("Tried and failed to find a pipe at " + pos);
        }
    }

    @Override
    public void postProcessing(IBuilderContext context, BlockPos pos) {
        Item pipeItem = Item.func_150899_d((int)this.tileNBT.func_74762_e("pipeId"));
        if (BptPipeExtension.contains(pipeItem)) {
            BptPipeExtension.get(pipeItem).postProcessing(this, context);
        }
    }

    @Override
    public Schematic.BuildingStage getBuildStage() {
        return Schematic.BuildingStage.STANDALONE;
    }

    @Override
    public void idsToBlueprint(MappingRegistry registry) {
        super.idsToBlueprint(registry);
        if (this.tileNBT.func_150297_b("pipeId", 3)) {
            Item item = Item.func_150899_d((int)this.tileNBT.func_74762_e("pipeId"));
            this.tileNBT.func_74768_a("pipeId", registry.getIdForItem(item));
        } else if (this.tileNBT.func_74764_b("pipeId")) {
            Item item = Item.func_111206_d((String)this.tileNBT.func_74779_i("pipeId"));
            this.tileNBT.func_74768_a("pipeId", registry.getIdForItem(item));
        }
    }

    @Override
    public void idsToWorld(MappingRegistry registry) {
        super.idsToWorld(registry);
        if (this.tileNBT.func_74764_b("pipeId")) {
            try {
                Item item = registry.getItemForId(this.tileNBT.func_74762_e("pipeId"));
                this.tileNBT.func_74778_a("pipeId", ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item)).toString());
            }
            catch (MappingNotFoundException e) {
                this.tileNBT.func_82580_o("pipeId");
            }
        }
    }

    @Override
    public void writeSchematicToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.writeSchematicToNBT(nbt, registry);
        nbt.func_74768_a("version", 2);
    }

    @Override
    public void readSchematicFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.readSchematicFromNBT(nbt, registry);
        if (!nbt.func_74764_b("version") || nbt.func_74762_e("version") < 2) {
            this.tileNBT.func_82580_o("items");
            if (this.tileNBT.func_74764_b("Gate")) {
                NBTTagCompound gateNBT = this.tileNBT.func_74775_l("Gate");
                for (int i = 0; i < 8; ++i) {
                    NBTTagCompound parameterNBT;
                    if (!gateNBT.func_74764_b("triggerParameters[" + i + "]") || !(parameterNBT = gateNBT.func_74775_l("triggerParameters[" + i + "]")).func_74764_b("stack")) continue;
                    parameterNBT.func_82580_o("stack");
                }
            }
        }
    }

    @Override
    public BuildingPermission getBuildingPermission() {
        return this.permission;
    }
}

