/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.statements.BCStatement;
import buildcraft.transport.Gate;
import buildcraft.transport.statements.ActionParameterSignal;
import java.util.Locale;

public class ActionSignalOutput
extends BCStatement
implements IActionInternal {
    public final PipeWire color;

    public ActionSignalOutput(PipeWire color) {
        super("buildcraft:pipe.wire.output." + color.name().toLowerCase(Locale.ENGLISH), "buildcraft.pipe.wire.output." + color.name().toLowerCase(Locale.ENGLISH));
        this.setBuildCraftLocation("transport", "triggers/trigger_pipesignal_" + color.name().toLowerCase() + "_active");
        this.color = color;
    }

    @Override
    public String getDescription() {
        return String.format(BCStringUtils.localize("gate.action.pipe.wire"), BCStringUtils.localize("color." + this.color.name().toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public int maxParameters() {
        return 3;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new ActionParameterSignal();
    }

    @Override
    public void actionActivate(IStatementContainer container, IStatementParameter[] parameters) {
        Gate gate = (Gate)container;
        gate.broadcastSignal(this.color);
        for (IStatementParameter param : parameters) {
            if (param == null || !(param instanceof ActionParameterSignal)) continue;
            ActionParameterSignal signal = (ActionParameterSignal)param;
            if (signal.color == null) continue;
            gate.broadcastSignal(signal.color);
        }
    }
}

