/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.gates.IGate;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.statements.StatementParameterRedstoneGateSideOnly;
import buildcraft.transport.TileGenericPipe;

public class TriggerRedstoneFaderInput
extends BCStatement
implements ITriggerInternal {
    public final int level;

    public TriggerRedstoneFaderInput(int level) {
        super(String.format("buildcraft:redtone.input.%02d", level));
        this.setBuildCraftLocation("transport", String.format("triggers/redstone_%02d", level));
        this.level = level;
    }

    @Override
    public String getDescription() {
        return String.format(BCStringUtils.localize("gate.trigger.redstone.input.level"), this.level);
    }

    @Override
    public boolean isTriggerActive(IStatementContainer container, IStatementParameter[] parameters) {
        if (!(container instanceof IGate)) {
            return false;
        }
        IGate gate = (IGate)container;
        TileGenericPipe tile = (TileGenericPipe)gate.getPipe().getTile();
        int inputLevel = tile.redstoneInput;
        if (parameters.length > 0 && parameters[0] instanceof StatementParameterRedstoneGateSideOnly && ((StatementParameterRedstoneGateSideOnly)parameters[0]).isOn) {
            inputLevel = tile.redstoneInputSide[gate.getSide().ordinal()];
        }
        return inputLevel == this.level;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        StatementParameterRedstoneGateSideOnly param = null;
        if (index == 0) {
            param = new StatementParameterRedstoneGateSideOnly();
        }
        return param;
    }

    @Override
    public int maxParameters() {
        return 1;
    }
}

