/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.stripes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.transport.IStripesActivator;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.utils.TransportUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PipeExtensionListener {
    private final Map<World, HashSet<PipeExtensionRequest>> requests = new HashMap<World, HashSet<PipeExtensionRequest>>();

    public void requestPipeExtension(ItemStack stack, World world, BlockPos pos, EnumFacing o, IStripesActivator h) {
        if (world.field_72995_K) {
            return;
        }
        if (!this.requests.containsKey(world)) {
            this.requests.put(world, new HashSet());
        }
        PipeExtensionRequest r = new PipeExtensionRequest();
        r.stack = stack;
        r.pos = pos;
        r.o = o;
        r.h = h;
        this.requests.get(world).add(r);
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.requests.containsKey(event.world)) {
            HashSet<PipeExtensionRequest> rSet = this.requests.get(event.world);
            World w = event.world;
            for (PipeExtensionRequest r : rSet) {
                Vec3 target = Utils.convert((Vec3i)r.pos);
                boolean retract = r.stack.func_77973_b() == BuildCraftTransport.pipeItemsVoid;
                List removedPipeStacks = null;
                if (retract) {
                    target = target.func_178787_e(Utils.convert(r.o, -1.0));
                } else if (!w.func_175623_d(Utils.convertFloor(target = target.func_178787_e(Utils.convert(r.o, 1.0))))) {
                    r.h.sendItem(r.stack, r.o.func_176734_d());
                    continue;
                }
                IBlockState oldState = w.func_180495_p(r.pos);
                NBTTagCompound nbt = new NBTTagCompound();
                w.func_175625_s(r.pos).func_145841_b(nbt);
                w.func_175698_g(r.pos);
                boolean failedPlacement = false;
                BlockPos targetPos = Utils.convertFloor(target);
                if (retract) {
                    removedPipeStacks = w.func_180495_p(targetPos).func_177230_c().getDrops((IBlockAccess)w, targetPos, w.func_180495_p(targetPos), 0);
                    w.func_175698_g(targetPos);
                } else {
                    r.stack.func_77973_b().func_180614_a(r.stack, (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)w, r.pos).get(), w, r.pos, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
                }
                nbt.func_74768_a("x", MathHelper.func_76128_c((double)target.field_72450_a));
                nbt.func_74768_a("y", MathHelper.func_76128_c((double)target.field_72448_b));
                nbt.func_74768_a("z", MathHelper.func_76128_c((double)target.field_72449_c));
                TileGenericPipe pipeTile = (TileGenericPipe)TileEntity.func_145827_c((NBTTagCompound)nbt);
                w.func_180501_a(targetPos, oldState, 3);
                w.func_175690_a(targetPos, (TileEntity)pipeTile);
                pipeTile.func_145834_a(w);
                pipeTile.func_145829_t();
                pipeTile.func_73660_a();
                PipeTransportItems items = (PipeTransportItems)((Pipe)pipeTile.getPipe()).transport;
                if (!retract && !failedPlacement) {
                    --r.stack.field_77994_a;
                }
                if (r.stack.field_77994_a > 0) {
                    this.sendItem(items, r.stack, r.o.func_176734_d());
                }
                if (removedPipeStacks != null) {
                    for (ItemStack s : removedPipeStacks) {
                        this.sendItem(items, s, r.o.func_176734_d());
                    }
                }
                if (retract || failedPlacement) continue;
                TileGenericPipe newPipeTile = (TileGenericPipe)w.func_175625_s(targetPos);
                newPipeTile.func_73660_a();
                pipeTile.scheduleNeighborChange();
                if (pipeTile.getPipe() == null) continue;
                ((Pipe)pipeTile.getPipe()).scheduleWireUpdate();
            }
            rSet.clear();
        }
    }

    private void sendItem(PipeTransportItems transport, ItemStack itemStack, EnumFacing direction) {
        Vec3 pos = Utils.convert((Vec3i)transport.container.func_174877_v());
        pos = pos.func_72441_c(0.5, (double)TransportUtils.getPipeFloorOf(itemStack), 0.5);
        TravelingItem newItem = TravelingItem.make(pos, itemStack);
        transport.injectItem(newItem, direction);
    }

    private class PipeExtensionRequest {
        public ItemStack stack;
        public BlockPos pos;
        public EnumFacing o;
        public IStripesActivator h;

        private PipeExtensionRequest() {
        }
    }
}

