/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.stripes;

import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IStripesHandler;
import buildcraft.core.lib.utils.Utils;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;

public class StripesHandlerDispenser
implements IStripesHandler {
    public static final List<Object> items = Lists.newArrayList();

    @Override
    public IStripesHandler.StripesHandlerType getType() {
        return IStripesHandler.StripesHandlerType.ITEM_USE;
    }

    @Override
    public boolean shouldHandle(ItemStack stack) {
        if (items.contains(stack.func_77973_b())) {
            return true;
        }
        for (Class<?> c = stack.func_77973_b().getClass(); c != Item.class; c = c.getSuperclass()) {
            if (!items.contains(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handle(World world, BlockPos pos, EnumFacing direction, ItemStack stack, EntityPlayer player, IStripesActivator activator) {
        Vec3 origin = Utils.convert((Vec3i)pos).func_178787_e(Utils.convert(direction, -1.0));
        Source source = new Source(world, Utils.convertFloor(origin), direction);
        IBehaviorDispenseItem behaviour = (IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a((Object)stack.func_77973_b());
        if (behaviour != null) {
            ItemStack output = behaviour.func_82482_a((IBlockSource)source, stack.func_77946_l());
            if (output.field_77994_a > 0) {
                activator.sendItem(output, direction.func_176734_d());
            }
            return true;
        }
        return false;
    }

    public class Source
    implements IBlockSource {
        private final World world;
        private final BlockPos pos;
        private final EnumFacing side;

        public Source(World world, BlockPos pos, EnumFacing side) {
            this.world = world;
            this.pos = pos;
            this.side = side;
        }

        public double func_82615_a() {
            return (double)this.pos.func_177958_n() + 0.5;
        }

        public double func_82617_b() {
            return (double)this.pos.func_177956_o() + 0.5;
        }

        public double func_82616_c() {
            return (double)this.pos.func_177952_p() + 0.5;
        }

        public BlockPos func_180699_d() {
            return this.pos;
        }

        public int func_82620_h() {
            return this.side.ordinal();
        }

        public TileEntity func_150835_j() {
            return this.world.func_175625_s(this.pos);
        }

        public World func_82618_k() {
            return this.world;
        }
    }
}

