/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.utils;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.EnumFacing;

public class TextureMatrix {
    private final int[] iconIndexes = new int[7];
    private boolean dirty = false;

    public int getTextureIndex(EnumFacing direction) {
        return this.iconIndexes[direction == null ? 6 : direction.ordinal()];
    }

    public void setIconIndex(EnumFacing direction, int value) {
        if (this.iconIndexes[direction == null ? 6 : direction.ordinal()] != value) {
            this.iconIndexes[direction == null ? 6 : direction.ordinal()] = value;
            this.dirty = true;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void writeData(ByteBuf data) {
        for (int iconIndex : this.iconIndexes) {
            data.writeByte(iconIndex);
        }
    }

    public void readData(ByteBuf data) {
        for (int i = 0; i < this.iconIndexes.length; ++i) {
            short icon = data.readUnsignedByte();
            if (this.iconIndexes[i] == icon) continue;
            this.iconIndexes[i] = icon;
            this.dirty = true;
        }
    }
}

