/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.subtile.SubTileEntity;

@SideOnly(value=Side.CLIENT)
public final class BotaniaAPIClient {
    public static final Map<String, ModelResourceLocation> queuedBlockModels = Maps.newHashMap();
    public static final Map<String, ModelResourceLocation> queuedItemModels = Maps.newHashMap();

    public static void registerSubtileModel(String subTileName, ModelResourceLocation model, ModelResourceLocation itemModel) {
        queuedBlockModels.put(subTileName, model);
        queuedItemModels.put(subTileName, itemModel);
    }

    public static void registerSubtileModel(String subTileName, ModelResourceLocation model) {
        BotaniaAPIClient.registerSubtileModel(subTileName, model, new ModelResourceLocation(model.func_110624_b() + ":" + model.func_110623_a(), "inventory"));
    }

    public static void registerSubtileModel(Class<? extends SubTileEntity> clazz, ModelResourceLocation model) {
        BotaniaAPIClient.registerSubtileModel(BotaniaAPI.getSubTileStringMapping(clazz), model);
    }

    public static void registerSubtileModel(Class<? extends SubTileEntity> clazz, ModelResourceLocation model, ModelResourceLocation itemModel) {
        BotaniaAPIClient.registerSubtileModel(BotaniaAPI.getSubTileStringMapping(clazz), model, itemModel);
    }

    private BotaniaAPIClient() {
    }
}

