/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.subtile;

import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;

public class RadiusDescriptor {
    final BlockPos subtileCoords;

    public RadiusDescriptor(BlockPos subtileCoords) {
        this.subtileCoords = subtileCoords;
    }

    public BlockPos getSubtileCoords() {
        return this.subtileCoords;
    }

    public boolean isCircle() {
        return false;
    }

    public double getCircleRadius() {
        return 0.0;
    }

    public AxisAlignedBB getAABB() {
        return null;
    }

    public static class Square
    extends Rectangle {
        public Square(BlockPos subtileCoords, int expand) {
            super(subtileCoords, new AxisAlignedBB(subtileCoords.func_177982_a(-expand, 0, -expand), subtileCoords.func_177982_a(expand + 1, 0, expand + 1)));
        }
    }

    public static class Rectangle
    extends RadiusDescriptor {
        final AxisAlignedBB aabb;

        public Rectangle(BlockPos subtileCoords, AxisAlignedBB aabb) {
            super(subtileCoords);
            this.aabb = aabb;
        }

        @Override
        public AxisAlignedBB getAABB() {
            return this.aabb;
        }
    }

    public static class Circle
    extends RadiusDescriptor {
        final double radius;

        public Circle(BlockPos subtileCoords, double radius) {
            super(subtileCoords);
            this.radius = radius;
        }

        @Override
        public boolean isCircle() {
            return true;
        }

        @Override
        public double getCircleRadius() {
            return this.radius;
        }
    }
}

