/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.awt.Color;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IExtendedWireframeCoordinateListProvider;
import vazkii.botania.api.item.IWireframeCoordinateListProvider;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.api.wand.IWireframeAABBProvider;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.lib.LibObfuscation;

public final class BoundTileRenderer {
    @SubscribeEvent
    public void onWorldRenderLast(RenderWorldLastEvent event) {
        int invSize;
        BlockPos coords;
        GlStateManager.func_179094_E();
        GL11.glPushAttrib((int)2896);
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_71045_bC();
        int color = Color.HSBtoRGB((float)(ClientTickHandler.ticksInGame % 200) / 200.0f, 0.6f, 1.0f);
        if (stack != null && stack.func_77973_b() instanceof ICoordBoundItem && (coords = ((ICoordBoundItem)stack.func_77973_b()).getBinding(stack)) != null) {
            this.renderBlockOutlineAt(coords, color);
        }
        InventoryPlayer mainInv = player.field_71071_by;
        IInventory baublesInv = BotaniaAPI.internalHandler.getBaublesInventory((EntityPlayer)player);
        int size = invSize = mainInv.func_70302_i_();
        if (baublesInv != null) {
            size += baublesInv.func_70302_i_();
        }
        for (int i = 0; i < size; ++i) {
            BlockPos coords2;
            boolean useBaubles = i >= invSize;
            Object inv = useBaubles ? baublesInv : mainInv;
            ItemStack stackInSlot = inv.func_70301_a(i - (useBaubles ? invSize : 0));
            if (stackInSlot == null || !(stackInSlot.func_77973_b() instanceof IWireframeCoordinateListProvider)) continue;
            IWireframeCoordinateListProvider provider = (IWireframeCoordinateListProvider)stackInSlot.func_77973_b();
            List<BlockPos> coordsList = provider.getWireframesToDraw((EntityPlayer)player, stackInSlot);
            if (coordsList != null) {
                for (BlockPos coords3 : coordsList) {
                    this.renderBlockOutlineAt(coords3, color);
                }
            }
            if (!(stackInSlot.func_77973_b() instanceof IExtendedWireframeCoordinateListProvider) || (coords2 = ((IExtendedWireframeCoordinateListProvider)stackInSlot.func_77973_b()).getSourceWireframe((EntityPlayer)player, stackInSlot)) == null || coords2.func_177956_o() <= -1) continue;
            this.renderBlockOutlineAt(coords2, color, 5.0f);
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GL11.glPopAttrib();
        GlStateManager.func_179121_F();
    }

    private void renderBlockOutlineAt(BlockPos pos, int color) {
        this.renderBlockOutlineAt(pos, color, 1.0f);
    }

    private double getRenderPosX() {
        return (Double)ObfuscationReflectionHelper.getPrivateValue(RenderManager.class, (Object)Minecraft.func_71410_x().func_175598_ae(), (String[])LibObfuscation.RENDERPOSX);
    }

    private double getRenderPosY() {
        return (Double)ObfuscationReflectionHelper.getPrivateValue(RenderManager.class, (Object)Minecraft.func_71410_x().func_175598_ae(), (String[])LibObfuscation.RENDERPOSY);
    }

    private double getRenderPosZ() {
        return (Double)ObfuscationReflectionHelper.getPrivateValue(RenderManager.class, (Object)Minecraft.func_71410_x().func_175598_ae(), (String[])LibObfuscation.RENDERPOSZ);
    }

    private void renderBlockOutlineAt(BlockPos pos, int color, float thickness) {
        AxisAlignedBB axis;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)pos.func_177958_n() - this.getRenderPosX()), (double)((double)pos.func_177956_o() - this.getRenderPosY()), (double)((double)pos.func_177952_p() - this.getRenderPosZ() + 1.0));
        Color colorRGB = new Color(color);
        GL11.glColor4ub((byte)((byte)colorRGB.getRed()), (byte)((byte)colorRGB.getGreen()), (byte)((byte)colorRGB.getBlue()), (byte)-1);
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block != null && (axis = block instanceof IWireframeAABBProvider ? ((IWireframeAABBProvider)block).getWireframeAABB((World)world, pos) : block.func_180646_a((World)world, pos)) != null) {
            axis = axis.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-(pos.func_177952_p() + 1)));
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glLineWidth((float)thickness);
            this.renderBlockOutline(axis);
            GL11.glLineWidth((float)(thickness + 3.0f));
            GL11.glColor3ub((byte)((byte)colorRGB.getRed()), (byte)((byte)colorRGB.getGreen()), (byte)((byte)colorRGB.getBlue()));
            this.renderBlockOutline(axis);
        }
        GlStateManager.func_179121_F();
    }

    private void renderBlockOutline(AxisAlignedBB aabb) {
        Tessellator tessellator = Tessellator.func_178181_a();
        double ix = aabb.field_72340_a;
        double iy = aabb.field_72338_b;
        double iz = aabb.field_72339_c;
        double ax = aabb.field_72336_d;
        double ay = aabb.field_72337_e;
        double az = aabb.field_72334_f;
        tessellator.func_178180_c().func_181668_a(1, DefaultVertexFormats.field_181705_e);
        tessellator.func_178180_c().func_181662_b(ix, iy, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, az).func_181675_d();
        tessellator.func_78381_a();
    }
}

