/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IBaubleRender;
import vazkii.botania.api.subtile.signature.SubTileSignature;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.RenderEventHandler;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.version.VersionChecker;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public final class ContributorFancinessHandler
implements LayerRenderer<EntityPlayer> {
    public static volatile Map<String, ItemStack> flowerMap = null;
    private static volatile boolean startedLoading = false;
    private static boolean phi = true;

    public void doRenderLayer(EntityPlayer player, float p_177141_2_, float p_177141_3_, float partialTicks, float p_177141_5_, float p_177141_6_, float p_177141_7_, float scale) {
        String name = player.func_145748_c_().func_150260_c();
        if (name.equals("Vazkii") || name.equals("_phi")) {
            if (phi) {
                ContributorFancinessHandler.renderPhiFlower(player);
            } else {
                ContributorFancinessHandler.renderTwintails(player, partialTicks);
            }
        } else if (name.equals("haighyorkie")) {
            ContributorFancinessHandler.renderGoldfish(player);
        }
        ContributorFancinessHandler.firstStart();
        name = name.toLowerCase();
        if (player.func_175148_a(EnumPlayerModelParts.CAPE) && flowerMap != null && flowerMap.containsKey(name)) {
            ContributorFancinessHandler.renderFlower(player, flowerMap.get(name));
        }
    }

    public boolean func_177142_b() {
        return false;
    }

    public static void firstStart() {
        if (!startedLoading) {
            new ThreadContributorListLoader();
            startedLoading = true;
        }
    }

    public static void load(Properties props) {
        flowerMap = new HashMap<String, ItemStack>();
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            try {
                int i = Integer.parseInt(value);
                if (i < 0 || i >= 16) {
                    throw new NumberFormatException();
                }
                flowerMap.put(key, new ItemStack(ModBlocks.flower, 1, i));
            }
            catch (NumberFormatException e) {
                SubTileSignature sig = BotaniaAPI.getSignatureForName(value);
                if (sig == null) continue;
                flowerMap.put(key, ItemBlockSpecialFlower.ofType(value));
            }
        }
    }

    private static void renderTwintails(EntityPlayer player, float partialTicks) {
        GlStateManager.func_179094_E();
        TextureAtlasSprite icon = RenderEventHandler.INSTANCE.tailIcon;
        float f = icon.func_94209_e();
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94210_h();
        IBaubleRender.Helper.translateToHeadLevel(player);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)0.0, (double)1.62, (double)0.0);
        float t = 0.13f;
        GlStateManager.func_179109_b((float)t, (float)-0.5f, (float)-0.1f);
        if (player.field_70181_x < 0.0) {
            GlStateManager.func_179114_b((float)((float)player.field_70181_x * 20.0f), (float)-1.0f, (float)0.0f, (float)0.0f);
        }
        float r = -18.0f + (float)Math.sin(((float)ClientTickHandler.ticksInGame + partialTicks) * 0.05f) * 2.0f;
        GlStateManager.func_179114_b((float)r, (float)0.0f, (float)0.0f, (float)1.0f);
        float s = 0.9f;
        GlStateManager.func_179152_a((float)s, (float)s, (float)s);
        IconHelper.renderIconIn3D(Tessellator.func_178181_a(), f1, f2, f, f3, icon.func_94211_a(), icon.func_94216_b(), 0.0625f);
        GlStateManager.func_179114_b((float)(-r), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(-t), (float)-0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)t, (float)-0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)r, (float)0.0f, (float)0.0f, (float)1.0f);
        IconHelper.renderIconIn3D(Tessellator.func_178181_a(), f1, f2, f, f3, icon.func_94211_a(), icon.func_94216_b(), 0.0625f);
        GlStateManager.func_179121_F();
    }

    private static void renderPhiFlower(EntityPlayer player) {
        GlStateManager.func_179094_E();
        TextureAtlasSprite icon = RenderEventHandler.INSTANCE.phiFlowerIcon;
        float f = icon.func_94209_e();
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94210_h();
        IBaubleRender.Helper.translateToHeadLevel(player);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.4f, (float)0.1f, (float)-0.25f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179152_a((float)0.4f, (float)0.4f, (float)0.4f);
        GlStateManager.func_179109_b((float)0.7f, (float)-3.5f, (float)0.125f);
        IconHelper.renderIconIn3D(Tessellator.func_178181_a(), f1, f2, f, f3, icon.func_94211_a(), icon.func_94216_b(), 0.0625f);
        GlStateManager.func_179121_F();
    }

    private static void renderGoldfish(EntityPlayer player) {
        GlStateManager.func_179094_E();
        TextureAtlasSprite icon = RenderEventHandler.INSTANCE.goldfishIcon;
        float f = icon.func_94209_e();
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94210_h();
        IBaubleRender.Helper.rotateIfSneaking(player);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)-0.75f, (float)0.5f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.4f, (float)0.4f, (float)0.4f);
        GlStateManager.func_179109_b((float)1.2f, (float)0.5f, (float)0.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        IconHelper.renderIconIn3D(Tessellator.func_178181_a(), f1, f2, f, f3, icon.func_94211_a(), icon.func_94216_b(), 0.0625f);
        GlStateManager.func_179121_F();
    }

    private static void renderFlower(EntityPlayer player, ItemStack flower) {
        GlStateManager.func_179094_E();
        IBaubleRender.Helper.translateToHeadLevel(player);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)1.22);
        ShaderHelper.useShader(ShaderHelper.gold);
        Minecraft.func_71410_x().func_175599_af().func_175049_a(flower, (EntityLivingBase)player, ItemCameraTransforms.TransformType.THIRD_PERSON);
        ShaderHelper.releaseShader();
        GlStateManager.func_179121_F();
    }

    public static class ThreadContributorListLoader
    extends Thread {
        public ThreadContributorListLoader() {
            this.setName("Botania Contributor Fanciness Thread");
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try {
                URL url = new URL("https://raw.githubusercontent.com/Vazkii/Botania/master/contributors.properties");
                Properties props = new Properties();
                props.load(new InputStreamReader(url.openStream()));
                ContributorFancinessHandler.load(props);
            }
            catch (Exception e) {
                FMLLog.info((String)"[Botania] Could not load contributors list. Either you're offline or github is down. Nothing to worry about, carry on~", (Object[])new Object[0]);
                e.printStackTrace();
            }
            VersionChecker.doneChecking = true;
        }
    }
}

