/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.google.common.collect.ImmutableList;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockWall;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.fml.common.registry.GameData;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AltGrassVariant;
import vazkii.botania.api.state.enums.AltarVariant;
import vazkii.botania.api.state.enums.BiomeBrickVariant;
import vazkii.botania.api.state.enums.BiomeStoneVariant;
import vazkii.botania.api.state.enums.CrateVariant;
import vazkii.botania.api.state.enums.CustomBrickVariant;
import vazkii.botania.api.state.enums.DrumVariant;
import vazkii.botania.api.state.enums.EndBrickVariant;
import vazkii.botania.api.state.enums.FutureStoneVariant;
import vazkii.botania.api.state.enums.LivingRockVariant;
import vazkii.botania.api.state.enums.LivingWoodVariant;
import vazkii.botania.api.state.enums.LuminizerVariant;
import vazkii.botania.api.state.enums.PoolVariant;
import vazkii.botania.api.state.enums.PrismarineVariant;
import vazkii.botania.api.state.enums.PylonVariant;
import vazkii.botania.api.state.enums.StorageVariant;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.model.FloatingFlowerModel;
import vazkii.botania.client.render.SpecialFlowerModel;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.decor.slabs.BlockModSlab;
import vazkii.botania.common.block.subtile.SubTileDecor;
import vazkii.botania.common.block.subtile.SubTileManastar;
import vazkii.botania.common.block.subtile.SubTilePureDaisy;
import vazkii.botania.common.block.subtile.functional.SubTileAgricarnation;
import vazkii.botania.common.block.subtile.functional.SubTileBellethorn;
import vazkii.botania.common.block.subtile.functional.SubTileBubbell;
import vazkii.botania.common.block.subtile.functional.SubTileClayconia;
import vazkii.botania.common.block.subtile.functional.SubTileDaffomill;
import vazkii.botania.common.block.subtile.functional.SubTileDreadthorn;
import vazkii.botania.common.block.subtile.functional.SubTileExoflame;
import vazkii.botania.common.block.subtile.functional.SubTileFallenKanade;
import vazkii.botania.common.block.subtile.functional.SubTileHeiseiDream;
import vazkii.botania.common.block.subtile.functional.SubTileHopperhock;
import vazkii.botania.common.block.subtile.functional.SubTileHyacidus;
import vazkii.botania.common.block.subtile.functional.SubTileJadedAmaranthus;
import vazkii.botania.common.block.subtile.functional.SubTileJiyuulia;
import vazkii.botania.common.block.subtile.functional.SubTileLoonuim;
import vazkii.botania.common.block.subtile.functional.SubTileMarimorphosis;
import vazkii.botania.common.block.subtile.functional.SubTileMedumone;
import vazkii.botania.common.block.subtile.functional.SubTileOrechid;
import vazkii.botania.common.block.subtile.functional.SubTileOrechidIgnem;
import vazkii.botania.common.block.subtile.functional.SubTilePollidisiac;
import vazkii.botania.common.block.subtile.functional.SubTileRannuncarpus;
import vazkii.botania.common.block.subtile.functional.SubTileSolegnolia;
import vazkii.botania.common.block.subtile.functional.SubTileSpectranthemum;
import vazkii.botania.common.block.subtile.functional.SubTileTangleberrie;
import vazkii.botania.common.block.subtile.functional.SubTileTigerseye;
import vazkii.botania.common.block.subtile.functional.SubTileVinculotus;
import vazkii.botania.common.block.subtile.generating.SubTileArcaneRose;
import vazkii.botania.common.block.subtile.generating.SubTileDandelifeon;
import vazkii.botania.common.block.subtile.generating.SubTileDaybloom;
import vazkii.botania.common.block.subtile.generating.SubTileEndoflame;
import vazkii.botania.common.block.subtile.generating.SubTileEntropinnyum;
import vazkii.botania.common.block.subtile.generating.SubTileGourmaryllis;
import vazkii.botania.common.block.subtile.generating.SubTileHydroangeas;
import vazkii.botania.common.block.subtile.generating.SubTileKekimurus;
import vazkii.botania.common.block.subtile.generating.SubTileMunchdew;
import vazkii.botania.common.block.subtile.generating.SubTileNarslimmus;
import vazkii.botania.common.block.subtile.generating.SubTileNightshade;
import vazkii.botania.common.block.subtile.generating.SubTileRafflowsia;
import vazkii.botania.common.block.subtile.generating.SubTileSpectrolus;
import vazkii.botania.common.block.subtile.generating.SubTileThermalily;
import vazkii.botania.common.block.tile.corporea.TileCorporeaCrystalCube;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;
import vazkii.botania.common.item.ItemManaGun;
import vazkii.botania.common.item.ItemSpawnerMover;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.brew.ItemBrewBase;
import vazkii.botania.common.item.equipment.bauble.ItemMagnetRing;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;
import vazkii.botania.common.item.relic.ItemInfiniteFruit;
import vazkii.botania.common.lib.LibItemNames;

public final class ModelHandler {
    public static void registerModels() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)SpecialFlowerModel.Loader.INSTANCE);
        OBJLoader.instance.addDomain("Botania".toLowerCase(Locale.ROOT));
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)FloatingFlowerModel.INSTANCE);
        ModelHandler.registerSubtiles();
        ModelHandler.registerStateMappers();
        ModelHandler.registerStandardBlocks();
        ModelHandler.registerMushrooms();
        ModelHandler.registerFlowers();
        ModelHandler.registerPavement();
        ModelHandler.registerStairs();
        ModelHandler.registerSlabs();
        ModelHandler.registerWalls();
        ModelHandler.registerPanes();
        ModelHandler.registerAltars();
        ModelHandler.registerQuartzBlocks();
        ModelHandler.registerLuminizers();
        ModelHandler.registerStandardItems();
        ModelHandler.registerTESRItems();
        ModelHandler.registerManaResources();
        ModelHandler.registerRunes();
        ModelHandler.registerBows();
        ModelHandler.registerLens();
        ModelHandler.registerBrews();
        ModelLoader.registerItemVariants((Item)ModItems.manaGun, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:manaGun", "inventory"), new ModelResourceLocation("botania:manaGunClip", "inventory"), new ModelResourceLocation("botania:desuGun", "inventory"), new ModelResourceLocation("botania:desuGunClip", "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.manaGun, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                String name = ((ItemManaGun)ModItems.manaGun).isSugoiKawaiiDesuNe(stack) ? (ItemManaGun.hasClip(stack) ? "botania:desuGunClip" : "botania:desuGun") : (ItemManaGun.hasClip(stack) ? "botania:manaGunClip" : "botania:manaGun");
                return new ModelResourceLocation(name, "inventory");
            }
        });
        ModelLoader.registerItemVariants((Item)ModItems.spawnerMover, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:spawnerMover", "inventory"), new ModelResourceLocation("botania:spawnerMoverFull", "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.spawnerMover, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                if (ItemSpawnerMover.hasData(stack)) {
                    return new ModelResourceLocation("botania:spawnerMover", "inventory");
                }
                return new ModelResourceLocation("botania:spawnerMoverFull", "inventory");
            }
        });
        ModelLoader.registerItemVariants((Item)ModItems.terraPick, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:terraPick", "inventory"), new ModelResourceLocation("botania:terraPickEnabled", "inventory"), new ModelResourceLocation("botania:terraPickTipped", "inventory"), new ModelResourceLocation("botania:terraPickTippedEnabled", "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.terraPick, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                String name = "botania:terraPick";
                if (ItemTerraPick.isTipped(stack)) {
                    name = name + "Tipped";
                }
                if (ItemTerraPick.isEnabled(stack)) {
                    name = name + "Enabled";
                }
                return new ModelResourceLocation(name, "inventory");
            }
        });
        ModelLoader.registerItemVariants((Item)ModItems.infiniteFruit, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:infiniteFruit", "inventory"), new ModelResourceLocation("botania:infiniteFruitBoot", "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.infiniteFruit, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return ItemInfiniteFruit.isBoot(stack) ? new ModelResourceLocation("botania:infiniteFruitBoot", "inventory") : new ModelResourceLocation("botania:infiniteFruit", "inventory");
            }
        });
        ModelLoader.registerItemVariants((Item)ModItems.manasteelSword, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:manasteelSword", "inventory"), new ModelResourceLocation("botania:elucidator", "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.manasteelSword, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return "the elucidator".equals(stack.func_82833_r().toLowerCase().trim()) ? new ModelResourceLocation("botania:elucidator", "inventory") : new ModelResourceLocation("botania:manasteelSword", "inventory");
            }
        });
        ModelLoader.registerItemVariants((Item)ModItems.magnetRing, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:magnetRingOn", "inventory"), new ModelResourceLocation("botania:magnetRingOff", "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.magnetRing, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return ItemMagnetRing.getCooldown(stack) <= 0 ? new ModelResourceLocation("botania:magnetRingOn", "inventory") : new ModelResourceLocation("botania:magnetRingOff", "inventory");
            }
        });
        ModelLoader.registerItemVariants((Item)ModItems.magnetRingGreater, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:magnetRingGreaterOn", "inventory"), new ModelResourceLocation("botania:magnetRingGreaterOff", "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.magnetRingGreater, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return ItemMagnetRing.getCooldown(stack) <= 0 ? new ModelResourceLocation("botania:magnetRingGreaterOn", "inventory") : new ModelResourceLocation("botania:magnetRingGreaterOff", "inventory");
            }
        });
        ModelLoader.registerItemVariants((Item)ModItems.manaweaveBoots, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:manaweaveBoots", "inventory"), new ModelResourceLocation("botania:manaweaveBootsHoliday", "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.manaweaveBoots, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return ClientProxy.jingleTheBells ? new ModelResourceLocation("botania:manaweaveBootsHoliday", "inventory") : new ModelResourceLocation("botania:manaweaveBoots", "inventory");
            }
        });
        ModelLoader.registerItemVariants((Item)ModItems.manaweaveChest, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:manaweaveChest", "inventory"), new ModelResourceLocation("botania:manaweaveChestHoliday", "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.manaweaveChest, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return ClientProxy.jingleTheBells ? new ModelResourceLocation("botania:manaweaveChestHoliday", "inventory") : new ModelResourceLocation("botania:manaweaveChest", "inventory");
            }
        });
        ModelLoader.registerItemVariants((Item)ModItems.manaweaveHelm, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:manaweaveHelm", "inventory"), new ModelResourceLocation("botania:manaweaveHelmHoliday", "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.manaweaveHelm, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return ClientProxy.jingleTheBells ? new ModelResourceLocation("botania:manaweaveHelmHoliday", "inventory") : new ModelResourceLocation("botania:manaweaveHelm", "inventory");
            }
        });
        ModelLoader.registerItemVariants((Item)ModItems.manaweaveLegs, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:manaweaveLegs", "inventory"), new ModelResourceLocation("botania:manaweaveLegsHoliday", "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.manaweaveLegs, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return ClientProxy.jingleTheBells ? new ModelResourceLocation("botania:manaweaveLegsHoliday", "inventory") : new ModelResourceLocation("botania:manaweaveLegs", "inventory");
            }
        });
    }

    private static void registerSubtiles() {
        BotaniaAPIClient.registerSubtileModel(SubTileManastar.class, new ModelResourceLocation("botania:manastar"));
        BotaniaAPIClient.registerSubtileModel(SubTilePureDaisy.class, new ModelResourceLocation("botania:puredaisy"));
        BotaniaAPIClient.registerSubtileModel(SubTileDaybloom.class, new ModelResourceLocation("botania:daybloom"));
        BotaniaAPIClient.registerSubtileModel(SubTileDecor.Daybloom.class, new ModelResourceLocation("botania:daybloomDecor"));
        BotaniaAPIClient.registerSubtileModel(SubTileDaybloom.Prime.class, new ModelResourceLocation("botania:daybloomPrime"));
        BotaniaAPIClient.registerSubtileModel(SubTileEndoflame.class, new ModelResourceLocation("botania:endoflame"));
        BotaniaAPIClient.registerSubtileModel(SubTileHydroangeas.class, new ModelResourceLocation("botania:hydroangeas"));
        BotaniaAPIClient.registerSubtileModel(SubTileDecor.Hydroangeas.class, new ModelResourceLocation("botania:hydroangeasDecor"));
        BotaniaAPIClient.registerSubtileModel(SubTileThermalily.class, new ModelResourceLocation("botania:thermalily"));
        BotaniaAPIClient.registerSubtileModel(SubTileNightshade.class, new ModelResourceLocation("botania:nightshade"));
        BotaniaAPIClient.registerSubtileModel(SubTileDecor.Nightshade.class, new ModelResourceLocation("botania:nightshadeDecor"));
        BotaniaAPIClient.registerSubtileModel(SubTileNightshade.Prime.class, new ModelResourceLocation("botania:nightshadePrime"));
        BotaniaAPIClient.registerSubtileModel(SubTileArcaneRose.class, new ModelResourceLocation("botania:arcanerose"));
        BotaniaAPIClient.registerSubtileModel(SubTileMunchdew.class, new ModelResourceLocation("botania:munchdew"));
        BotaniaAPIClient.registerSubtileModel(SubTileEntropinnyum.class, new ModelResourceLocation("botania:entropinnyum"));
        BotaniaAPIClient.registerSubtileModel(SubTileKekimurus.class, new ModelResourceLocation("botania:kekimurus"));
        BotaniaAPIClient.registerSubtileModel(SubTileGourmaryllis.class, new ModelResourceLocation("botania:gourmaryllis"));
        BotaniaAPIClient.registerSubtileModel(SubTileNarslimmus.class, new ModelResourceLocation("botania:narslimmus"));
        BotaniaAPIClient.registerSubtileModel(SubTileSpectrolus.class, new ModelResourceLocation("botania:spectrolus"));
        BotaniaAPIClient.registerSubtileModel(SubTileDandelifeon.class, new ModelResourceLocation("botania:dandelifeon"));
        BotaniaAPIClient.registerSubtileModel(SubTileRafflowsia.class, new ModelResourceLocation("botania:rafflowsia"));
        BotaniaAPIClient.registerSubtileModel(SubTileBellethorn.class, new ModelResourceLocation("botania:bellethorn"));
        BotaniaAPIClient.registerSubtileModel(SubTileBellethorn.Mini.class, new ModelResourceLocation("botania:bellethornChibi"));
        BotaniaAPIClient.registerSubtileModel(SubTileDreadthorn.class, new ModelResourceLocation("botania:dreadthorn"));
        BotaniaAPIClient.registerSubtileModel(SubTileHeiseiDream.class, new ModelResourceLocation("botania:heiseiDream"));
        BotaniaAPIClient.registerSubtileModel(SubTileTigerseye.class, new ModelResourceLocation("botania:tigerseye"));
        BotaniaAPIClient.registerSubtileModel(SubTileJadedAmaranthus.class, new ModelResourceLocation("botania:jadedAmaranthus"));
        BotaniaAPIClient.registerSubtileModel(SubTileOrechid.class, new ModelResourceLocation("botania:orechid"));
        BotaniaAPIClient.registerSubtileModel(SubTileOrechidIgnem.class, new ModelResourceLocation("botania:orechidIgnem"));
        BotaniaAPIClient.registerSubtileModel(SubTileFallenKanade.class, new ModelResourceLocation("botania:fallenKanade"));
        BotaniaAPIClient.registerSubtileModel(SubTileExoflame.class, new ModelResourceLocation("botania:exoflame"));
        BotaniaAPIClient.registerSubtileModel(SubTileAgricarnation.class, new ModelResourceLocation("botania:agricarnation"));
        BotaniaAPIClient.registerSubtileModel(SubTileAgricarnation.Mini.class, new ModelResourceLocation("botania:agricarnationChibi"));
        BotaniaAPIClient.registerSubtileModel(SubTileHopperhock.class, new ModelResourceLocation("botania:hopperhock"));
        BotaniaAPIClient.registerSubtileModel(SubTileHopperhock.Mini.class, new ModelResourceLocation("botania:hopperhockChibi"));
        BotaniaAPIClient.registerSubtileModel(SubTileTangleberrie.class, new ModelResourceLocation("botania:tangleberrie"));
        BotaniaAPIClient.registerSubtileModel(SubTileJiyuulia.class, new ModelResourceLocation("botania:jiyuulia"));
        BotaniaAPIClient.registerSubtileModel(SubTileRannuncarpus.class, new ModelResourceLocation("botania:rannuncarpus"));
        BotaniaAPIClient.registerSubtileModel(SubTileRannuncarpus.Mini.class, new ModelResourceLocation("botania:rannuncarpusChibi"));
        BotaniaAPIClient.registerSubtileModel(SubTileHyacidus.class, new ModelResourceLocation("botania:hyacidus"));
        BotaniaAPIClient.registerSubtileModel(SubTilePollidisiac.class, new ModelResourceLocation("botania:pollidisiac"));
        BotaniaAPIClient.registerSubtileModel(SubTileClayconia.class, new ModelResourceLocation("botania:clayconia"));
        BotaniaAPIClient.registerSubtileModel(SubTileLoonuim.class, new ModelResourceLocation("botania:loonium"));
        BotaniaAPIClient.registerSubtileModel(SubTileDaffomill.class, new ModelResourceLocation("botania:daffomill"));
        BotaniaAPIClient.registerSubtileModel(SubTileVinculotus.class, new ModelResourceLocation("botania:vinculotus"));
        BotaniaAPIClient.registerSubtileModel(SubTileSpectranthemum.class, new ModelResourceLocation("botania:spectranthemum"));
        BotaniaAPIClient.registerSubtileModel(SubTileMedumone.class, new ModelResourceLocation("botania:medumone"));
        BotaniaAPIClient.registerSubtileModel(SubTileMarimorphosis.class, new ModelResourceLocation("botania:marimorphosis"));
        BotaniaAPIClient.registerSubtileModel(SubTileMarimorphosis.Mini.class, new ModelResourceLocation("botania:marimorphosisChibi"));
        BotaniaAPIClient.registerSubtileModel(SubTileBubbell.class, new ModelResourceLocation("botania:bubbell"));
        BotaniaAPIClient.registerSubtileModel(SubTileBubbell.Mini.class, new ModelResourceLocation("botania:bubbellChibi"));
        BotaniaAPIClient.registerSubtileModel(SubTileSolegnolia.class, new ModelResourceLocation("botania:solegnolia"));
        BotaniaAPIClient.registerSubtileModel(SubTileSolegnolia.Mini.class, new ModelResourceLocation("botania:solegnoliaChibi"));
    }

    private static void registerStandardBlocks() {
        ModelHandler.registerItemModel(ModBlocks.manaGlass);
        ModelHandler.registerItemModel(ModBlocks.elfGlass);
        ModelHandler.registerItemModel(ModBlocks.runeAltar);
        ModelHandler.registerItemModel(ModBlocks.pistonRelay);
        ModelHandler.registerItemModel(ModBlocks.distributor);
        ModelHandler.registerItemModel(ModBlocks.starfield);
        ModelHandler.registerItemModel(ModBlocks.specialFlower);
        ModelHandler.registerItemModel(ModBlocks.dirtPath);
        ModelHandler.registerItemModel(ModBlocks.felPumpkin);
        ModelHandler.registerItemModel(ModBlocks.ghostRail);
        ModelHandler.registerItemModel(ModBlocks.shimmerrock);
        ModelHandler.registerItemModel(ModBlocks.shimmerwoodPlanks);
        ModelHandler.registerItemModel(ModBlocks.manaVoid);
        ModelHandler.registerItemModel(ModBlocks.alchemyCatalyst);
        ModelHandler.registerItemModel(ModBlocks.conjurationCatalyst);
        ModelHandler.registerItemModel(ModBlocks.reedBlock);
        ModelHandler.registerItemModel(ModBlocks.bifrost);
        ModelHandler.registerItemModel(ModBlocks.bifrostPerm);
        ModelHandler.registerItemModel(ModBlocks.enderEye);
        ModelHandler.registerItemModel(ModBlocks.tinyPlanet);
        ModelHandler.registerItemModel(ModBlocks.thatch);
        ModelHandler.registerItemModel(ModBlocks.blazeBlock);
        ModelHandler.registerItemModel(ModBlocks.forestEye);
        ModelHandler.registerItemModel(ModBlocks.seaLamp);
        ModelHandler.registerItemModel(ModBlocks.cellBlock);
        ModelHandler.registerItemModel(ModBlocks.enchantedSoil);
        ModelHandler.registerItemModel(ModBlocks.enchanter);
        ModelHandler.registerItemModel(ModBlocks.prism);
        ModelHandler.registerItemModel(ModBlocks.redStringContainer);
        ModelHandler.registerItemModel(ModBlocks.redStringDispenser);
        ModelHandler.registerItemModel(ModBlocks.redStringComparator);
        ModelHandler.registerItemModel(ModBlocks.redStringFertilizer);
        ModelHandler.registerItemModel(ModBlocks.redStringInterceptor);
        ModelHandler.registerItemModel(ModBlocks.redStringRelay);
        ModelHandler.registerItemModel(ModBlocks.floatingSpecialFlower);
        ModelHandler.registerItemModel(ModBlocks.sparkChanger);
        ModelHandler.registerItemModel(ModBlocks.terraPlate);
        ModelHandler.registerItemModel(ModBlocks.corporeaRetainer);
        ModelHandler.registerItemModel(ModBlocks.corporeaInterceptor);
        ModelHandler.registerItemModel(ModBlocks.corporeaFunnel);
        ModelHandler.registerItemModel(ModBlocks.lightLauncher);
        ModelHandler.registerItemModel(ModBlocks.manaDetector);
        ModelHandler.registerItemModel(ModBlocks.manaBomb);
        ModelHandler.registerItemModel(ModBlocks.rfGenerator);
        ModelHandler.registerItemModel(ModBlocks.alfPortal);
        ModelHandler.registerItemModel(ModBlocks.root);
        ModelHandler.registerItemModel(ModBlocks.cacophonium);
        ModelHandler.registerItemModel(ModBlocks.tinyPotato);
        ModelHandler.registerItemModelAllMeta(Item.func_150898_a((Block)ModBlocks.floatingFlower), EnumDyeColor.values().length);
        ModelHandler.registerItemModelAllMeta(Item.func_150898_a((Block)ModBlocks.unstableBlock), EnumDyeColor.values().length);
        ModelHandler.registerItemModelAllMeta(Item.func_150898_a((Block)ModBlocks.petalBlock), EnumDyeColor.values().length);
        ModelHandler.registerItemModelAllMeta(Item.func_150898_a((Block)ModBlocks.manaBeacon), EnumDyeColor.values().length);
        ModelHandler.registerVariantsDefaulted(ModBlocks.altGrass, AltGrassVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.storage, StorageVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.pylon, PylonVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.forestDrum, DrumVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.livingrock, LivingRockVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.livingwood, LivingWoodVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.dreamwood, LivingWoodVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModFluffBlocks.stone, FutureStoneVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModFluffBlocks.biomeStoneA, BiomeStoneVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModFluffBlocks.biomeStoneB, BiomeBrickVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.endStoneBrick, EndBrickVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.openCrate, CrateVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.customBrick, CustomBrickVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.prismarine, PrismarineVariant.class, "variant");
        ModelHandler.registerVariantsDefaulted(ModBlocks.pool, PoolVariant.class, "variant");
    }

    private static void registerStandardItems() {
        ModelHandler.registerItemModel(ModItems.pestleAndMortar);
        ModelHandler.registerItemModel(ModItems.blackLotus);
        ModelHandler.registerItemModel(ModItems.blackLotus, 1);
        ModelHandler.registerItemModel(ModItems.lexicon);
        ModelHandler.registerItemModel(ModItems.manaCookie);
        ModelHandler.registerItemModel(ModItems.manasteelHelm);
        ModelHandler.registerItemModel(ModItems.manasteelHelmRevealing);
        ModelHandler.registerItemModel(ModItems.manasteelChest);
        ModelHandler.registerItemModel(ModItems.manasteelLegs);
        ModelHandler.registerItemModel(ModItems.manasteelBoots);
        ModelHandler.registerItemModel(ModItems.manasteelPick);
        ModelHandler.registerItemModel(ModItems.manasteelShovel);
        ModelHandler.registerItemModel(ModItems.manasteelAxe);
        ModelHandler.registerItemModel(ModItems.manasteelShears);
        ModelHandler.registerItemModel(ModItems.elementiumHelm);
        ModelHandler.registerItemModel(ModItems.elementiumHelmRevealing);
        ModelHandler.registerItemModel(ModItems.elementiumChest);
        ModelHandler.registerItemModel(ModItems.elementiumLegs);
        ModelHandler.registerItemModel(ModItems.elementiumBoots);
        ModelHandler.registerItemModel(ModItems.elementiumPick);
        ModelHandler.registerItemModel(ModItems.elementiumShovel);
        ModelHandler.registerItemModel(ModItems.elementiumAxe);
        ModelHandler.registerItemModel(ModItems.elementiumShears);
        ModelHandler.registerItemModel(ModItems.elementiumSword);
        ModelHandler.registerItemModel(ModItems.terrasteelHelm);
        ModelHandler.registerItemModel(ModItems.terrasteelHelmRevealing);
        ModelHandler.registerItemModel(ModItems.terrasteelChest);
        ModelHandler.registerItemModel(ModItems.terrasteelLegs);
        ModelHandler.registerItemModel(ModItems.terrasteelBoots);
        ModelHandler.registerItemModel(ModItems.terraSword);
        ModelHandler.registerItemModelMetas(ModItems.terraAxe, "terraAxe", 2);
        ModelHandler.registerItemModel(ModItems.starSword);
        ModelHandler.registerItemModel(ModItems.thunderSword);
        ModelHandler.registerItemModel(ModItems.glassPick);
        ModelHandler.registerItemModel(ModItems.twigWand);
        ModelHandler.registerItemModel(ModItems.flowerBag);
        ModelHandler.registerItemModel(ModItems.fertilizer);
        ModelHandler.registerItemModel(ModItems.obedienceStick);
        ModelHandler.registerItemModel(ModItems.dirtRod);
        ModelHandler.registerItemModel(ModItems.waterRod);
        ModelHandler.registerItemModel(ModItems.cobbleRod);
        ModelHandler.registerItemModel(ModItems.fireRod);
        ModelHandler.registerItemModel(ModItems.rainbowRod);
        ModelHandler.registerItemModel(ModItems.skyDirtRod);
        ModelHandler.registerItemModel(ModItems.tornadoRod);
        ModelHandler.registerItemModel(ModItems.terraformRod);
        ModelHandler.registerItemModel(ModItems.diviningRod);
        ModelHandler.registerItemModel(ModItems.gravityRod);
        ModelHandler.registerItemModel(ModItems.missileRod);
        ModelHandler.registerItemModel(ModItems.smeltRod);
        ModelHandler.registerItemModel(ModItems.exchangeRod);
        ModelHandler.registerItemModel(ModItems.tornadoRod);
        ModelLoader.registerItemVariants((Item)ModItems.tornadoRod, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:tornadoRod_flying", "inventory")});
        ModelHandler.registerItemModel(ModItems.openBucket);
        ModelHandler.registerItemModel(ModItems.bloodPendant);
        ModelHandler.registerItemModel(ModItems.manaTablet);
        ModelHandler.registerItemModel(ModItems.enderDagger);
        ModelHandler.registerItemModel(ModItems.slingshot);
        ModelHandler.registerItemModel(ModItems.vineBall);
        ModelHandler.registerItemModel(ModItems.regenIvy);
        ModelHandler.registerItemModel(ModItems.keepIvy);
        ModelHandler.registerItemModel(ModItems.recordGaia1);
        ModelHandler.registerItemModel(ModItems.recordGaia2);
        ModelHandler.registerItemModel(ModItems.overgrowthSeed);
        ModelHandler.registerItemModel(ModItems.worldSeed);
        ModelHandler.registerItemModel(ModItems.incenseStick);
        ModelHandler.registerItemModel(ModItems.enderHand);
        ModelHandler.registerItemModel(ModItems.craftingHalo);
        ModelHandler.registerItemModel(ModItems.spellCloth);
        ModelHandler.registerItemModel(ModItems.autocraftingHalo);
        ModelHandler.registerItemModel(ModItems.sextant);
        ModelHandler.registerItemModel(ModItems.cacophonium);
        ModelHandler.registerItemModel(ModItems.clip);
        ModelHandler.registerItemModel(ModItems.phantomInk);
        ModelHandler.registerItemModel(ModItems.poolMinecart);
        ModelHandler.registerItemModel(ModItems.pinkinator);
        ModelHandler.registerItemModel(ModItems.dice);
        ModelHandler.registerItemModel(ModItems.kingKey);
        ModelHandler.registerItemModel(ModItems.flugelEye);
        ModelHandler.registerItemModel(ModItems.thorRing);
        ModelHandler.registerItemModel(ModItems.lokiRing);
        ModelHandler.registerItemModel(ModItems.odinRing);
        ModelHandler.registerItemModel(ModItems.aesirRing);
        ModelHandler.registerItemModel(ModItems.baubleBox);
        ModelHandler.registerItemModel(ModItems.tinyPlanet);
        ModelHandler.registerItemModel(ModItems.manaRing);
        ModelHandler.registerItemModel(ModItems.manaRingGreater);
        ModelHandler.registerItemModel(ModItems.auraRing);
        ModelHandler.registerItemModel(ModItems.auraRingGreater);
        ModelHandler.registerItemModel(ModItems.spark);
        ModelHandler.registerItemModel(ModItems.waterRing);
        ModelHandler.registerItemModel(ModItems.miningRing);
        ModelHandler.registerItemModel(ModItems.reachRing);
        ModelHandler.registerItemModel(ModItems.swapRing);
        ModelHandler.registerItemModel(ModItems.pixieRing);
        ModelHandler.registerItemModel(ModItems.travelBelt);
        ModelHandler.registerItemModel(ModItems.superTravelBelt);
        ModelHandler.registerItemModel(ModItems.speedUpBelt);
        ModelHandler.registerItemModel(ModItems.knockbackBelt);
        ModelHandler.registerItemModel(ModItems.itemFinder);
        ModelHandler.registerItemModel(ModItems.monocle);
        ModelHandler.registerItemModel(ModItems.icePendant);
        ModelHandler.registerItemModel(ModItems.lavaPendant);
        ModelHandler.registerItemModel(ModItems.superLavaPendant);
        ModelHandler.registerItemModel(ModItems.holyCloak);
        ModelHandler.registerItemModel(ModItems.unholyCloak);
        ModelHandler.registerItemModel(ModItems.goldLaurel);
        ModelHandler.registerItemModel(ModItems.flightTiara);
        ModelHandler.registerItemModel(ModItems.divaCharm);
        ModelHandler.registerItemModel(ModItems.manaMirror);
        ModelHandler.registerItemModelAllMeta(ModItems.flightTiara, 9);
        ModelHandler.registerItemModelAllMeta(ModItems.laputaShard, 20);
        ModelHandler.registerItemModelAllMeta(ModItems.signalFlare, EnumDyeColor.values().length);
        ModelHandler.registerItemModelAllMeta(ModItems.dye, EnumDyeColor.values().length);
        ModelHandler.registerItemModelAllMeta(ModItems.petal, EnumDyeColor.values().length);
        ModelHandler.registerItemModelMetas(ModItems.sparkUpgrade, "sparkUpgrade", 4);
        ModelHandler.registerItemModelMetas(ModItems.corporeaSpark, "corporeaSpark", 2);
        ModelHandler.registerItemModelMetas(ModItems.manaBottle, "manaBottle", 6);
        ModelHandler.registerItemModelMetas(ModItems.ancientWill, "ancientWill", 6);
        ModelHandler.registerItemModelMetas(ModItems.temperanceStone, "temperanceStone", 2);
        ModelHandler.registerItemModelMetas(ModItems.thornChakram, "thornChakram", 2);
        ModelHandler.registerItemModelMetas(ModItems.blackHoleTalisman, "blackHoleTalisman", 2);
        ModelHandler.registerItemModelMetas(ModItems.slimeBottle, "slimeBottle", 2);
        ModelHandler.registerItemModelMetas(ModItems.grassSeeds, "grassSeeds", 9);
        ModelHandler.registerItemModelMetas(ModItems.quartz, "quartz", 8);
        ModelHandler.registerItemModelMetas(ModItems.cosmetic, "cosmetic", 32);
        ModelHandler.registerItemModelMetas(ModItems.craftPattern, "craftPattern", 9);
        ModelHandler.registerItemModelMetas(ModItems.virus, "virus", 2);
        ModelHandler.registerItemModelMetas(ModItems.grassHorn, "grassHorn", 3);
    }

    private static void registerTESRItems() {
        ModelHandler.registerItemModel(ModBlocks.corporeaCrystalCube);
        ModelHandler.registerItemModel(ModBlocks.corporeaIndex);
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)ModBlocks.corporeaCrystalCube), (int)0, TileCorporeaCrystalCube.class);
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)ModBlocks.corporeaIndex), (int)0, TileCorporeaIndex.class);
    }

    private static void registerManaResources() {
        Item item = ModItems.manaResource;
        for (int i = 0; i < LibItemNames.MANA_RESOURCE_NAMES.length; ++i) {
            String name = "botania:" + LibItemNames.MANA_RESOURCE_NAMES[i];
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(name, "inventory")});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
        }
    }

    private static void registerRunes() {
        ImmutableList variantNames = ImmutableList.of((Object)"water", (Object)"fire", (Object)"earth", (Object)"air", (Object)"spring", (Object)"summer", (Object)"autumn", (Object)"winter", (Object)"mana", (Object)"lust", (Object)"gluttony", (Object)"greed", (Object[])new String[]{"sloth", "wrath", "envy", "pride"});
        for (int i = 0; i < variantNames.size(); ++i) {
            ModelLoader.registerItemVariants((Item)ModItems.rune, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:rune_" + (String)variantNames.get(i), "inventory")});
            ModelLoader.setCustomModelResourceLocation((Item)ModItems.rune, (int)i, (ModelResourceLocation)new ModelResourceLocation("botania:rune_" + (String)variantNames.get(i), "inventory"));
        }
    }

    private static void registerBows() {
        ModelLoader.registerItemVariants((Item)ModItems.livingwoodBow, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:livingwoodBow", "inventory")});
        ModelLoader.registerItemVariants((Item)ModItems.livingwoodBow, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:livingwoodBow_pulling_1", "inventory")});
        ModelLoader.registerItemVariants((Item)ModItems.livingwoodBow, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:livingwoodBow_pulling_2", "inventory")});
        ModelLoader.registerItemVariants((Item)ModItems.livingwoodBow, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:livingwoodBow_pulling_3", "inventory")});
        ModelHandler.registerItemModel(ModItems.livingwoodBow);
        ModelLoader.registerItemVariants((Item)ModItems.crystalBow, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:crystalBow", "inventory")});
        ModelLoader.registerItemVariants((Item)ModItems.crystalBow, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:crystalBow_pulling_1", "inventory")});
        ModelLoader.registerItemVariants((Item)ModItems.crystalBow, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:crystalBow_pulling_2", "inventory")});
        ModelLoader.registerItemVariants((Item)ModItems.crystalBow, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:crystalBow_pulling_3", "inventory")});
        ModelLoader.registerItemVariants((Item)ModItems.crystalBow, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:crystalBow_pulling_4", "inventory")});
        ModelLoader.registerItemVariants((Item)ModItems.crystalBow, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:crystalBow_pulling_5", "inventory")});
        ModelHandler.registerItemModel(ModItems.crystalBow);
    }

    private static void registerLens() {
        int counter = 0;
        for (String s : LibItemNames.LENS_NAMES) {
            ModelLoader.registerItemVariants((Item)ModItems.lens, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:" + s, "inventory")});
            ModelLoader.setCustomModelResourceLocation((Item)ModItems.lens, (int)counter++, (ModelResourceLocation)new ModelResourceLocation("botania:" + s, "inventory"));
        }
    }

    private static void registerBrews() {
        int i;
        ModelLoader.registerItemVariants((Item)ModItems.vial, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:vial", "inventory"), new ModelResourceLocation("botania:flask", "inventory")});
        ModelLoader.setCustomModelResourceLocation((Item)ModItems.vial, (int)0, (ModelResourceLocation)new ModelResourceLocation("botania:vial", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ModItems.vial, (int)1, (ModelResourceLocation)new ModelResourceLocation("botania:flask", "inventory"));
        for (i = 0; i < 6; ++i) {
            ModelLoader.registerItemVariants((Item)ModItems.brewFlask, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:flask1_" + i, "inventory")});
        }
        ModelLoader.setCustomMeshDefinition((Item)ModItems.brewFlask, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                int swigsTaken = 6 - ((ItemBrewBase)ModItems.brewFlask).getSwigsLeft(stack);
                return new ModelResourceLocation("botania:flask1_" + swigsTaken, "inventory");
            }
        });
        for (i = 0; i < 4; ++i) {
            ModelLoader.registerItemVariants((Item)ModItems.brewVial, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:vial1_" + i, "inventory")});
        }
        ModelLoader.setCustomMeshDefinition((Item)ModItems.brewVial, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                int swigsTaken = 4 - ((ItemBrewBase)ModItems.brewVial).getSwigsLeft(stack);
                return new ModelResourceLocation("botania:vial1_" + swigsTaken, "inventory");
            }
        });
    }

    private static void registerStateMappers() {
        ModelLoader.setCustomStateMapper((Block)ModBlocks.floatingSpecialFlower, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation("botania:floatingSpecialFlower", "normal");
            }
        });
        ModelLoader.setCustomStateMapper((Block)ModBlocks.floatingFlower, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation("botania:miniIsland", "normal");
            }
        });
        ModelLoader.setCustomStateMapper((Block)ModBlocks.doubleFlower1, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoublePlant.field_176493_a, BlockDoublePlant.field_181084_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.doubleFlower2, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoublePlant.field_176493_a, BlockDoublePlant.field_181084_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.unstableBlock, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.COLOR}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.manaBeacon, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.COLOR}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.petalBlock, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.COLOR}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.flower, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{((BlockFlower)ModBlocks.flower).func_176494_l()}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.shinyFlower, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{((BlockFlower)ModBlocks.shinyFlower).func_176494_l()}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.buriedPetals, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{((BlockFlower)ModBlocks.buriedPetals).func_176494_l()}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.specialFlower, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.COLOR, ((BlockFlower)ModBlocks.specialFlower).func_176494_l()}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModFluffBlocks.biomeStoneWall, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModFluffBlocks.dreamwoodWall, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModFluffBlocks.livingrockWall, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModFluffBlocks.livingwoodWall, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModFluffBlocks.prismarineWall, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModFluffBlocks.reedWall, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModFluffBlocks.stoneWall, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        for (Block b : ModFluffBlocks.biomeStoneSlabs) {
            ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockModSlab.DUMMY}).func_178441_a());
        }
        for (Block b : ModFluffBlocks.pavementSlabs) {
            ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockModSlab.DUMMY}).func_178441_a());
        }
        for (Block b : ModFluffBlocks.stoneSlabs) {
            ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockModSlab.DUMMY}).func_178441_a());
        }
        ImmutableList otherSlabs = ImmutableList.copyOf((Object[])new Block[]{ModFluffBlocks.livingwoodSlab, ModFluffBlocks.livingwoodPlankSlab, ModFluffBlocks.livingrockSlab, ModFluffBlocks.dreamwoodSlab, ModFluffBlocks.livingrockBrickSlab, ModFluffBlocks.dreamwoodPlankSlab, ModFluffBlocks.prismarineSlab, ModFluffBlocks.prismarineBrickSlab, ModFluffBlocks.darkPrismarineSlab, ModFluffBlocks.reedSlab, ModFluffBlocks.thatchSlab, ModFluffBlocks.netherBrickSlab, ModFluffBlocks.soulBrickSlab, ModFluffBlocks.snowBrickSlab, ModFluffBlocks.tileSlab, ModFluffBlocks.darkQuartzSlab, ModFluffBlocks.manaQuartzSlab, ModFluffBlocks.blazeQuartzSlab, ModFluffBlocks.lavenderQuartzSlab, ModFluffBlocks.redQuartzSlab, ModFluffBlocks.elfQuartzSlab, ModFluffBlocks.sunnyQuartzSlab, ModFluffBlocks.dirtPathSlab, ModFluffBlocks.shimmerrockSlab, ModFluffBlocks.shimmerwoodPlankSlab, ModFluffBlocks.endStoneSlab, ModFluffBlocks.enderBrickSlab});
        for (Block b : otherSlabs) {
            ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockModSlab.DUMMY}).func_178441_a());
        }
        for (Block b : ModFluffBlocks.biomeStoneFullSlabs) {
            ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockModSlab.DUMMY, BlockSlab.field_176554_a}).func_178441_a());
        }
        for (Block b : ModFluffBlocks.pavementFullSlabs) {
            ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockModSlab.DUMMY, BlockSlab.field_176554_a}).func_178441_a());
        }
        for (Block b : ModFluffBlocks.stoneFullSlabs) {
            ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockModSlab.DUMMY, BlockSlab.field_176554_a}).func_178441_a());
        }
        ImmutableList otherFullSlabs = ImmutableList.copyOf((Object[])new Block[]{ModFluffBlocks.livingwoodSlabFull, ModFluffBlocks.livingwoodPlankSlabFull, ModFluffBlocks.livingrockSlabFull, ModFluffBlocks.dreamwoodSlabFull, ModFluffBlocks.livingrockBrickSlabFull, ModFluffBlocks.dreamwoodPlankSlabFull, ModFluffBlocks.prismarineSlabFull, ModFluffBlocks.prismarineBrickSlabFull, ModFluffBlocks.darkPrismarineSlabFull, ModFluffBlocks.reedSlabFull, ModFluffBlocks.thatchSlabFull, ModFluffBlocks.netherBrickSlabFull, ModFluffBlocks.soulBrickSlabFull, ModFluffBlocks.snowBrickSlabFull, ModFluffBlocks.tileSlabFull, ModFluffBlocks.darkQuartzSlabFull, ModFluffBlocks.manaQuartzSlabFull, ModFluffBlocks.blazeQuartzSlabFull, ModFluffBlocks.lavenderQuartzSlabFull, ModFluffBlocks.redQuartzSlabFull, ModFluffBlocks.elfQuartzSlabFull, ModFluffBlocks.sunnyQuartzSlabFull, ModFluffBlocks.dirtPathSlabFull, ModFluffBlocks.shimmerrockSlabFull, ModFluffBlocks.shimmerwoodPlankSlabFull, ModFluffBlocks.endStoneSlabFull, ModFluffBlocks.enderBrickSlabFull});
        for (Block b : otherFullSlabs) {
            ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockModSlab.DUMMY, BlockSlab.field_176554_a}).func_178441_a());
        }
    }

    private static void registerMushrooms() {
        Item item = Item.func_150898_a((Block)ModBlocks.mushroom);
        for (EnumDyeColor color : EnumDyeColor.values()) {
            String name = GameData.getBlockRegistry().getNameForObject((Object)ModBlocks.mushroom).toString();
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(name, "inventory_" + color.func_176610_l())});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)color.func_176765_a(), (ModelResourceLocation)new ModelResourceLocation(name, "inventory_" + color.func_176610_l()));
        }
    }

    private static void registerFlowers() {
        String variant;
        String name;
        Item item = Item.func_150898_a((Block)ModBlocks.flower);
        for (EnumDyeColor color : EnumDyeColor.values()) {
            name = GameData.getBlockRegistry().getNameForObject((Object)ModBlocks.flower).toString();
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(name, "inventory_" + color.func_176610_l())});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)color.func_176765_a(), (ModelResourceLocation)new ModelResourceLocation(name, "inventory_" + color.func_176610_l()));
        }
        item = Item.func_150898_a((Block)ModBlocks.shinyFlower);
        for (EnumDyeColor color : EnumDyeColor.values()) {
            name = GameData.getBlockRegistry().getNameForObject((Object)ModBlocks.shinyFlower).toString();
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(name, "inventory_" + color.func_176610_l())});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)color.func_176765_a(), (ModelResourceLocation)new ModelResourceLocation(name, "inventory_" + color.func_176610_l()));
        }
        item = Item.func_150898_a((Block)ModBlocks.doubleFlower1);
        for (EnumDyeColor color : BotaniaStateProps.DOUBLEFLOWER_VARIANT_1.func_177700_c()) {
            String name2 = GameData.getBlockRegistry().getNameForObject((Object)ModBlocks.doubleFlower1).toString();
            variant = "inventory_" + color.func_176610_l();
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(name2, variant)});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)color.func_176765_a(), (ModelResourceLocation)new ModelResourceLocation(name2, variant));
        }
        item = Item.func_150898_a((Block)ModBlocks.doubleFlower2);
        for (EnumDyeColor color : BotaniaStateProps.DOUBLEFLOWER_VARIANT_2.func_177700_c()) {
            String name3 = GameData.getBlockRegistry().getNameForObject((Object)ModBlocks.doubleFlower2).toString();
            variant = "inventory_" + color.func_176610_l();
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(name3, variant)});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)(color.func_176765_a() - 8), (ModelResourceLocation)new ModelResourceLocation(name3, variant));
        }
    }

    private static void registerPavement() {
        Item item = Item.func_150898_a((Block)ModFluffBlocks.pavement);
        String name = GameData.getBlockRegistry().getNameForObject((Object)ModFluffBlocks.pavement).toString();
        block7: for (EnumDyeColor e : BotaniaStateProps.PAVEMENT_COLOR.func_177700_c()) {
            String variant = "color=" + e.func_176610_l();
            switch (e) {
                case BLACK: {
                    ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(name, variant)});
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)1, (ModelResourceLocation)new ModelResourceLocation(name, variant));
                    continue block7;
                }
                case BLUE: {
                    ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(name, variant)});
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)2, (ModelResourceLocation)new ModelResourceLocation(name, variant));
                    continue block7;
                }
                case RED: {
                    ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(name, variant)});
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)3, (ModelResourceLocation)new ModelResourceLocation(name, variant));
                    continue block7;
                }
                case YELLOW: {
                    ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(name, variant)});
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)4, (ModelResourceLocation)new ModelResourceLocation(name, variant));
                    continue block7;
                }
                case GREEN: {
                    ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(name, variant)});
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)5, (ModelResourceLocation)new ModelResourceLocation(name, variant));
                    continue block7;
                }
            }
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(name, variant)});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(name, variant));
        }
    }

    private static void registerStairs() {
        for (Block b : ModFluffBlocks.stoneStairs) {
            ModelHandler.registerItemModel(b);
        }
        for (Block b : ModFluffBlocks.pavementStairs) {
            ModelHandler.registerItemModel(b);
        }
        for (Block b : ModFluffBlocks.biomeStoneStairs) {
            ModelHandler.registerItemModel(b);
        }
        ModelHandler.registerItemModel(ModFluffBlocks.blazeQuartzStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.darkPrismarineStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.darkQuartzStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.dreamwoodStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.dreamwoodPlankStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.elfQuartzStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.enderBrickStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.endStoneStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.lavenderQuartzStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.livingrockStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.livingrockBrickStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.livingwoodStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.livingwoodPlankStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.manaQuartzStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.netherBrickStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.prismarineStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.prismarineBrickStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.redQuartzStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.reedStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.shimmerrockStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.shimmerwoodPlankStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.snowBrickStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.soulBrickStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.sunnyQuartzStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.thatchStairs);
        ModelHandler.registerItemModel(ModFluffBlocks.tileStairs);
    }

    private static void registerSlabs() {
        for (Block b : ModFluffBlocks.biomeStoneSlabs) {
            ModelHandler.registerItemModel(b);
        }
        for (Block b : ModFluffBlocks.pavementSlabs) {
            ModelHandler.registerItemModel(b);
        }
        for (Block b : ModFluffBlocks.stoneSlabs) {
            ModelHandler.registerItemModel(b);
        }
        ModelHandler.registerItemModel(ModFluffBlocks.livingwoodSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.livingwoodPlankSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.livingrockSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.livingrockBrickSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.blazeQuartzSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.darkQuartzSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.elfQuartzSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.lavenderQuartzSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.manaQuartzSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.redQuartzSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.sunnyQuartzSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.dreamwoodSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.dreamwoodPlankSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.prismarineSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.prismarineBrickSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.darkPrismarineSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.dirtPathSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.shimmerrockSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.shimmerwoodPlankSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.endStoneSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.enderBrickSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.netherBrickSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.soulBrickSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.snowBrickSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.tileSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.reedSlab);
        ModelHandler.registerItemModel(ModFluffBlocks.thatchSlab);
    }

    private static void registerWalls() {
        String variantName;
        Item item = Item.func_150898_a((Block)ModFluffBlocks.biomeStoneWall);
        for (Enum variant : BotaniaStateProps.BIOMESTONEWALL_VARIANT.func_177700_c()) {
            variantName = "inventory_" + ((BiomeStoneVariant)variant).func_176610_l();
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:biomeStoneA0Wall", variantName)});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)(variant.ordinal() - 8), (ModelResourceLocation)new ModelResourceLocation("botania:biomeStoneA0Wall", variantName));
        }
        item = Item.func_150898_a((Block)ModFluffBlocks.stoneWall);
        for (Enum variant : BotaniaStateProps.FUTURESTONEWALL_VARIANT.func_177700_c()) {
            variantName = "inventory_" + ((FutureStoneVariant)variant).func_176610_l();
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation("botania:stone0Wall", variantName)});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)variant.ordinal(), (ModelResourceLocation)new ModelResourceLocation("botania:stone0Wall", variantName));
        }
        ModelHandler.registerItemModel(ModFluffBlocks.livingrockWall);
        ModelHandler.registerItemModel(ModFluffBlocks.livingwoodWall);
        ModelHandler.registerItemModel(ModFluffBlocks.dreamwoodWall);
        ModelHandler.registerItemModel(ModFluffBlocks.prismarineWall);
        ModelHandler.registerItemModel(ModFluffBlocks.reedWall);
    }

    private static void registerPanes() {
        ModelHandler.registerItemModel(ModFluffBlocks.alfglassPane);
        ModelHandler.registerItemModel(ModFluffBlocks.bifrostPane);
        ModelHandler.registerItemModel(ModFluffBlocks.managlassPane);
    }

    private static void registerAltars() {
        Item item = Item.func_150898_a((Block)ModBlocks.altar);
        String name = GameData.getBlockRegistry().getNameForObject((Object)ModBlocks.altar).toString();
        for (int i = 0; i < AltarVariant.values().length - 1; ++i) {
            String variantName = "variant=" + AltarVariant.values()[i].func_176610_l();
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(name, variantName)});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(name, variantName));
        }
    }

    private static void registerQuartzBlocks() {
        for (Block b : ImmutableList.of((Object)ModFluffBlocks.blazeQuartz, (Object)ModFluffBlocks.darkQuartz, (Object)ModFluffBlocks.elfQuartz, (Object)ModFluffBlocks.lavenderQuartz, (Object)ModFluffBlocks.manaQuartz, (Object)ModFluffBlocks.redQuartz, (Object)ModFluffBlocks.sunnyQuartz)) {
            Item item = Item.func_150898_a((Block)b);
            String name = GameData.getBlockRegistry().getNameForObject((Object)b).toString();
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(name, "variant=normal")});
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(name, "variant=chiseled")});
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(name, "variant=pillar_y")});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(name, "variant=normal"));
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)1, (ModelResourceLocation)new ModelResourceLocation(name, "variant=chiseled"));
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)2, (ModelResourceLocation)new ModelResourceLocation(name, "variant=pillar_y"));
        }
    }

    private static void registerLuminizers() {
        Item item = Item.func_150898_a((Block)ModBlocks.lightRelay);
        String name = GameData.getBlockRegistry().getNameForObject((Object)ModBlocks.lightRelay).toString();
        for (LuminizerVariant v : LuminizerVariant.values()) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(name, "powered=false,variant=" + v.func_176610_l())});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)v.ordinal(), (ModelResourceLocation)new ModelResourceLocation(name, "powered=false,variant=" + v.func_176610_l()));
        }
    }

    private static <T extends Enum<T>> void registerVariantsDefaulted(Block b, Class<T> enumclazz, String variantHeader) {
        Item item = Item.func_150898_a((Block)b);
        for (Enum e : (Enum[])enumclazz.getEnumConstants()) {
            String baseName = GameData.getBlockRegistry().getNameForObject((Object)b).toString();
            String variantName = variantHeader + "=" + ((IStringSerializable)e).func_176610_l();
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(baseName, variantName)});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)e.ordinal(), (ModelResourceLocation)new ModelResourceLocation(baseName, variantName));
        }
    }

    private static void registerItemModelAllMeta(Item item, int range) {
        String loc = GameData.getItemRegistry().getNameForObject((Object)item).toString();
        for (int i = 0; i < range; ++i) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(loc, "inventory")});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(loc, "inventory"));
        }
    }

    private static void registerItemModelMetas(Item item, String loc, int range) {
        for (int i = 0; i < range; ++i) {
            String name = "botania:" + loc + i;
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ModelResourceLocation[]{new ModelResourceLocation(name, "inventory")});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
        }
    }

    private static void registerItemModel(Block b) {
        ModelHandler.registerItemModel(Item.func_150898_a((Block)b));
    }

    private static void registerItemModel(Item i, int meta) {
        ResourceLocation loc = GameData.getItemRegistry().getNameForObject((Object)i);
        ModelLoader.setCustomModelResourceLocation((Item)i, (int)meta, (ModelResourceLocation)new ModelResourceLocation(loc, "inventory"));
    }

    private static void registerItemModel(Item i) {
        ModelHandler.registerItemModel(i, 0);
    }

    private ModelHandler() {
    }
}

