/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.lexicon.multiblock.IMultiblockRenderHook;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.lexicon.multiblock.component.MultiblockComponent;
import vazkii.botania.client.core.handler.MultiblockBlockAccess;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.lib.LibObfuscation;

public final class MultiblockRenderHandler {
    public static boolean rendering = false;
    private static MultiblockBlockAccess blockAccess = new MultiblockBlockAccess();
    public static MultiblockSet currentMultiblock;
    public static BlockPos anchor;
    public static EnumFacing angle;
    public static int dimension;

    public static void setMultiblock(MultiblockSet set) {
        currentMultiblock = set;
        anchor = null;
        angle = EnumFacing.DOWN;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            dimension = mc.field_71441_e.field_73011_w.func_177502_q();
        }
    }

    @SubscribeEvent
    public void onWorldRenderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71439_g == null || mc.field_71476_x == null || mc.field_71439_g.func_70093_af() && anchor == null)) {
            mc.field_71439_g.func_71045_bC();
            this.renderPlayerLook((EntityPlayer)mc.field_71439_g, mc.field_71476_x);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (currentMultiblock != null && anchor == null && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer == Minecraft.func_71410_x().field_71439_g) {
            anchor = event.pos;
            angle = event.entityPlayer.func_174811_aO();
            event.setCanceled(true);
        }
    }

    private void renderPlayerLook(EntityPlayer player, MovingObjectPosition src) {
        if (currentMultiblock != null && dimension == player.field_70170_p.field_73011_w.func_177502_q()) {
            BlockPos anchorPos = anchor != null ? anchor : src.func_178782_a();
            GlStateManager.func_179094_E();
            GL11.glPushAttrib((int)2896);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179140_f();
            rendering = true;
            Multiblock mb = anchor != null ? currentMultiblock.getForFacing(angle) : currentMultiblock.getForEntity((Entity)player);
            boolean didAny = false;
            blockAccess.update((IBlockAccess)player.field_70170_p, mb, anchorPos);
            for (MultiblockComponent comp : mb.getComponents()) {
                if (!this.renderComponentInWorld(player.field_70170_p, mb, comp, anchorPos)) continue;
                didAny = true;
            }
            rendering = false;
            GL11.glPopAttrib();
            GlStateManager.func_179121_F();
            if (!didAny) {
                MultiblockRenderHandler.setMultiblock(null);
                player.func_146105_b(new ChatComponentTranslation("botaniamisc.structureComplete", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN)));
            }
        }
    }

    private double getRenderPosX() {
        return (Double)ObfuscationReflectionHelper.getPrivateValue(RenderManager.class, (Object)Minecraft.func_71410_x().func_175598_ae(), (String[])LibObfuscation.RENDERPOSX);
    }

    private double getRenderPosY() {
        return (Double)ObfuscationReflectionHelper.getPrivateValue(RenderManager.class, (Object)Minecraft.func_71410_x().func_175598_ae(), (String[])LibObfuscation.RENDERPOSY);
    }

    private double getRenderPosZ() {
        return (Double)ObfuscationReflectionHelper.getPrivateValue(RenderManager.class, (Object)Minecraft.func_71410_x().func_175598_ae(), (String[])LibObfuscation.RENDERPOSZ);
    }

    private boolean renderComponentInWorld(World world, Multiblock mb, MultiblockComponent comp, BlockPos anchorPos) {
        BlockPos pos = comp.getRelativePosition();
        BlockPos pos_ = pos.func_177971_a((Vec3i)anchorPos);
        if (anchor != null && comp.matches(world, pos_)) {
            return false;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-this.getRenderPosX()), (double)(-this.getRenderPosY()), (double)(-this.getRenderPosZ()));
        GlStateManager.func_179097_i();
        MultiblockRenderHandler.doRenderComponent(mb, comp, pos_, 0.4f);
        GlStateManager.func_179121_F();
        return true;
    }

    public static void renderMultiblockOnPage(Multiblock mb) {
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        blockAccess.update(null, mb, mb.offPos);
        for (MultiblockComponent comp : mb.getComponents()) {
            BlockPos pos = comp.getRelativePosition();
            MultiblockRenderHandler.doRenderComponent(mb, comp, pos.func_177971_a((Vec3i)mb.offPos), 1.0f);
        }
    }

    private static void doRenderComponent(Multiblock mb, MultiblockComponent comp, BlockPos pos, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        IBlockState state = comp.getBlockState();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        if (state == null) {
            return;
        }
        if (IMultiblockRenderHook.renderHooks.containsKey(state.func_177230_c())) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            IMultiblockRenderHook renderHook = IMultiblockRenderHook.renderHooks.get(state.func_177230_c());
            if (renderHook.needsTranslate(state)) {
                GlStateManager.func_179137_b((double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5));
            }
            renderHook.renderBlockForMultiblock(blockAccess, mb, state, comp, alpha);
        } else {
            BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
            GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)(pos.func_177952_p() + 1));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            brd.func_175016_a(state, 0.5f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    static {
        IMultiblockRenderHook.renderHooks.put(ModBlocks.pylon, new IMultiblockRenderHook(){

            @Override
            public void renderBlockForMultiblock(IBlockAccess world, Multiblock mb, IBlockState state, MultiblockComponent comp, float alpha) {
                IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
                Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178266_a(model, state, 1.0f, false);
            }

            @Override
            public boolean needsTranslate(IBlockState state) {
                return true;
            }
        });
    }
}

