/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.lwjgl.opengl.GL11;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.tile.string.TileRedString;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.LibObfuscation;

public final class RedStringRenderer {
    public static final Queue<TileRedString> redStringTiles = new ArrayDeque<TileRedString>();
    static float sizeAlpha = 0.0f;

    public static void renderAll() {
        if (!redStringTiles.isEmpty()) {
            TileRedString tile;
            GlStateManager.func_179094_E();
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            GL11.glPushAttrib((int)2896);
            GlStateManager.func_179140_f();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)sizeAlpha);
            while ((tile = redStringTiles.poll()) != null) {
                RedStringRenderer.renderTile(tile);
            }
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            GL11.glPopAttrib();
            GlStateManager.func_179121_F();
        }
    }

    public static void tick() {
        boolean hasWand;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean bl = hasWand = player != null && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == ModItems.twigWand;
        if (sizeAlpha > 0.0f && !hasWand) {
            sizeAlpha -= 0.1f;
        } else if (sizeAlpha < 1.0f && hasWand) {
            sizeAlpha += 0.1f;
        }
    }

    private static double getRenderPosX() {
        return (Double)ObfuscationReflectionHelper.getPrivateValue(RenderManager.class, (Object)Minecraft.func_71410_x().func_175598_ae(), (String[])LibObfuscation.RENDERPOSX);
    }

    private static double getRenderPosY() {
        return (Double)ObfuscationReflectionHelper.getPrivateValue(RenderManager.class, (Object)Minecraft.func_71410_x().func_175598_ae(), (String[])LibObfuscation.RENDERPOSY);
    }

    private static double getRenderPosZ() {
        return (Double)ObfuscationReflectionHelper.getPrivateValue(RenderManager.class, (Object)Minecraft.func_71410_x().func_175598_ae(), (String[])LibObfuscation.RENDERPOSZ);
    }

    private static void renderTile(TileRedString tile) {
        EnumFacing dir = tile.getOrientation();
        BlockPos bind = tile.getBinding();
        if (bind != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)tile.func_174877_v().func_177958_n() + 0.5 - RedStringRenderer.getRenderPosX()), (double)((double)tile.func_174877_v().func_177956_o() + 0.5 - RedStringRenderer.getRenderPosY()), (double)((double)tile.func_174877_v().func_177952_p() + 0.5 - RedStringRenderer.getRenderPosZ()));
            Vector3 vecOrig = new Vector3(bind.func_177958_n() - tile.func_174877_v().func_177958_n(), bind.func_177956_o() - tile.func_174877_v().func_177956_o(), bind.func_177952_p() - tile.func_174877_v().func_177952_p());
            Vector3 vecNorm = vecOrig.copy().normalize();
            Vector3 vecMag = vecNorm.copy().multiply(0.025);
            Vector3 vecApply = vecMag.copy();
            int stages = (int)(vecOrig.mag() / vecMag.mag());
            Tessellator tessellator = Tessellator.func_178181_a();
            GL11.glLineWidth((float)1.0f);
            tessellator.func_178180_c().func_181668_a(1, DefaultVertexFormats.field_181705_e);
            double len = (double)(-ClientTickHandler.ticksInGame) / 100.0 + (double)new Random(dir.ordinal() ^ tile.func_174877_v().hashCode()).nextInt(10000);
            double add = vecMag.mag();
            double rand = Math.random() - 0.5;
            for (int i = 0; i < stages; ++i) {
                RedStringRenderer.addVertexAtWithTranslation(tessellator, dir, vecApply.x, vecApply.y, vecApply.z, rand, len);
                rand = Math.random() - 0.5;
                vecApply.add(vecMag);
                RedStringRenderer.addVertexAtWithTranslation(tessellator, dir, vecApply.x, vecApply.y, vecApply.z, rand, len += add);
            }
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
    }

    private static void addVertexAtWithTranslation(Tessellator tess, EnumFacing dir, double xpos, double ypos, double zpos, double rand, double l) {
        double freq = 20.0;
        double ampl = (0.15 * (Math.sin(l * 2.0) * 0.5 + 0.5) + 0.1) * (double)sizeAlpha;
        double randMul = 0.05;
        double x = xpos + Math.sin(l * freq) * ampl * (double)Math.abs(Math.abs(dir.func_82601_c()) - 1) + rand * randMul;
        double y = ypos + Math.cos(l * freq) * ampl * (double)Math.abs(Math.abs(dir.func_96559_d()) - 1) + rand * randMul;
        double z = zpos + (dir.func_96559_d() == 0 ? Math.sin(l * freq) : Math.cos(l * freq)) * ampl * (double)Math.abs(Math.abs(dir.func_82599_e()) - 1) + rand * randMul;
        tess.func_178180_c().func_181662_b(x, y, z).func_181675_d();
    }
}

