/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.client.model.FloatingFlowerModel;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.integration.buildcraft.TriggerManaLevel;

public class RenderEventHandler {
    public static final RenderEventHandler INSTANCE = new RenderEventHandler();
    public TextureAtlasSprite alfPortalTex;
    public TextureAtlasSprite lightRelayWorldIcon;
    public TextureAtlasSprite lightRelayWorldIconRed;
    public TextureAtlasSprite alchemyCatalystOverlay;
    public TextureAtlasSprite enchanterOverlay;
    public TextureAtlasSprite manaVoidOverlay;
    public TextureAtlasSprite manaWater;
    public TextureAtlasSprite terraPlateOverlay;
    public TextureAtlasSprite corporeaWorldIcon;
    public TextureAtlasSprite corporeaWorldIconMaster;
    public TextureAtlasSprite corporeaIconStar;
    public TextureAtlasSprite sparkWorldIcon;
    public TextureAtlasSprite manaDetectorIcon;
    public TextureAtlasSprite runeAltarTriggerIcon;
    public TextureAtlasSprite[] sparkUpgradeIcons;
    public TextureAtlasSprite[] kingKeyWeaponIcons;
    public Map<TriggerManaLevel.State, TextureAtlasSprite> manaLevelTriggerIcons = Maps.newEnumMap(TriggerManaLevel.State.class);
    public TextureAtlasSprite tailIcon = null;
    public TextureAtlasSprite phiFlowerIcon = null;
    public TextureAtlasSprite goldfishIcon = null;
    public TextureAtlasSprite nerfBatIcon = null;

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent evt) {
        evt.modelManager.func_174954_c().func_178121_a(ModBlocks.specialFlower, (IStateMapper)new DefaultStateMapper(){

            public ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation("botania:specialFlower");
            }
        });
        evt.modelRegistry.func_82595_a((Object)new ModelResourceLocation("botania:miniIsland", "normal"), (Object)FloatingFlowerModel.INSTANCE);
        evt.modelRegistry.func_82595_a((Object)new ModelResourceLocation("botania:miniIsland", "inventory"), (Object)FloatingFlowerModel.INSTANCE);
        evt.modelRegistry.func_82595_a((Object)new ModelResourceLocation("botania:floatingSpecialFlower", "normal"), (Object)FloatingFlowerModel.INSTANCE);
        evt.modelRegistry.func_82595_a((Object)new ModelResourceLocation("botania:floatingSpecialFlower", "inventory"), (Object)FloatingFlowerModel.INSTANCE);
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre evt) {
        int i;
        System.out.println("CALLING TEXTURE STITCH");
        this.alfPortalTex = IconHelper.forName(evt.map, "alfheimPortalInside", "blocks");
        this.lightRelayWorldIcon = IconHelper.forName(evt.map, "lightRelay1", "blocks");
        this.lightRelayWorldIconRed = IconHelper.forName(evt.map, "lightRelay3", "blocks");
        this.alchemyCatalystOverlay = IconHelper.forName(evt.map, "alchemyCatalyst3", "blocks");
        this.enchanterOverlay = IconHelper.forName(evt.map, "enchanterOverlay", "blocks");
        this.manaVoidOverlay = IconHelper.forName(evt.map, "manaVoid1", "blocks");
        this.manaWater = IconHelper.forName(evt.map, "manaWater", "blocks");
        this.terraPlateOverlay = IconHelper.forName(evt.map, "terraPlateOverlay", "blocks");
        this.corporeaWorldIcon = IconHelper.forName(evt.map, "corporeaSpark1", "items");
        this.corporeaWorldIconMaster = IconHelper.forName(evt.map, "corporeaSpark3", "items");
        this.corporeaIconStar = IconHelper.forName(evt.map, "corporeaSparkStar", "items");
        this.sparkWorldIcon = IconHelper.forName(evt.map, "spark1", "items");
        this.sparkUpgradeIcons = new TextureAtlasSprite[4];
        for (i = 0; i < 4; ++i) {
            this.sparkUpgradeIcons[i] = IconHelper.forName(evt.map, "sparkUpgradeL" + i, "items");
        }
        this.tailIcon = IconHelper.forName(evt.map, "tail", "items");
        this.phiFlowerIcon = IconHelper.forName(evt.map, "phiFlower", "items");
        this.goldfishIcon = IconHelper.forName(evt.map, "goldfish", "items");
        this.nerfBatIcon = IconHelper.forName(evt.map, "nerfBat", "items");
        this.kingKeyWeaponIcons = new TextureAtlasSprite[12];
        for (i = 0; i < 12; ++i) {
            this.kingKeyWeaponIcons[i] = IconHelper.forName(evt.map, "gateWeapon" + i, "items");
        }
        this.manaDetectorIcon = IconHelper.forName(evt.map, "triggers/manaDetector", "items");
        this.runeAltarTriggerIcon = IconHelper.forName(evt.map, "triggers/runeAltarCanCraft", "items");
        for (TriggerManaLevel.State s : TriggerManaLevel.State.values()) {
            this.manaLevelTriggerIcons.put(s, IconHelper.forName(evt.map, "triggers/mana" + WordUtils.capitalizeFully((String)s.name()), "items"));
        }
    }

    private RenderEventHandler() {
    }
}

